//POVRay-fjl ltrehozsa mint 3d41.ulp v1.05
//J:/Program Files/Eagle/projects/examples/Tranzisztorkakterisztika1/Karakterisztika rajzolo.brd
//2008.12.29. 9:09:31

#version 3.5;

//Set to on if the file should be used as .inc
#local use_file_as_inc = off;
#if(use_file_as_inc=off)


//changes the apperance of resistors (1 Blob / 0 real)
#declare global_res_shape = 1;
//randomize color of resistors 1=random 0=same color
#declare global_res_colselect = 0;
//Number of the color for the resistors
//0=Green, 1="normal color" 2=Blue 3=Brown
#declare global_res_col = 1;
//Set to on if you want to render the PCB upside-down
#declare pcb_upsidedown = off;
//Set to x or z to rotate around the corresponding axis (referring to pcb_upsidedown)
#declare pcb_rotdir = x;
//Set the length off short pins over the PCB
#declare pin_length = 2.5;
#declare global_diode_bend_radius = 1;
#declare global_res_bend_radius = 1;
#declare global_solder = on;

#declare global_show_screws = on;
#declare global_show_washers = on;
#declare global_show_nuts = on;

//Animation
#declare global_anim = off;
#local global_anim_showcampath = no;

#declare global_fast_mode = off;

#declare col_preset = 2;
#declare pin_short = on;

#declare environment = off;

#local cam_x = 0;
#local cam_y = 365;
#local cam_z = -139;
#local cam_a = 20;
#local cam_look_x = 0;
#local cam_look_y = -6;
#local cam_look_z = 0;

#local pcb_rotate_x = 35;
#local pcb_rotate_y = 1;
#local pcb_rotate_z = 0;

#local pcb_board = on;
#local pcb_parts = on;
#if(global_fast_mode=off)
	#local pcb_polygons = on;
	#local pcb_silkscreen = on;
	#local pcb_wires = on;
	#local pcb_pads_smds = on;
#else
	#local pcb_polygons = off;
	#local pcb_silkscreen = off;
	#local pcb_wires = off;
	#local pcb_pads_smds = off;
#end

#local lgt1_pos_x = 43;
#local lgt1_pos_y = 65;
#local lgt1_pos_z = 32;
#local lgt1_intense = 0.798983;
#local lgt2_pos_x = -43;
#local lgt2_pos_y = 65;
#local lgt2_pos_z = 32;
#local lgt2_intense = 0.798983;
#local lgt3_pos_x = 43;
#local lgt3_pos_y = 65;
#local lgt3_pos_z = -21;
#local lgt3_intense = 0.798983;
#local lgt4_pos_x = -43;
#local lgt4_pos_y = 65;
#local lgt4_pos_z = -21;
#local lgt4_intense = 0.798983;

//Do not change these values
#declare pcb_height = 1.500000;
#declare pcb_cuheight = 0.035000;
#declare pcb_x_size = 114.280000;
#declare pcb_y_size = 60.630000;
#declare pcb_layer1_used = 1;
#declare pcb_layer16_used = 1;
#declare inc_testmode = off;
#declare global_seed=seed(333);
#declare global_pcb_layer_dis = array[16]
{
	0.000000,
	0.000000,
	0.000000,
	0.000000,
	0.000000,
	0.000000,
	0.000000,
	0.000000,
	0.000000,
	0.000000,
	0.000000,
	0.000000,
	0.000000,
	0.000000,
	0.000000,
	1.535000,
}
#declare global_pcb_real_hole = 2.000000;

#include "tools.inc"
#include "user.inc"

global_settings{charset utf8}

#if(environment=on)
sky_sphere {pigment {Navy}
pigment {bozo turbulence 0.65 octaves 7 omega 0.7 lambda 2
color_map {
[0.0 0.1 color rgb <0.85, 0.85, 0.85> color rgb <0.75, 0.75, 0.75>]
[0.1 0.5 color rgb <0.75, 0.75, 0.75> color rgbt <1, 1, 1, 1>]
[0.5 1.0 color rgbt <1, 1, 1, 1> color rgbt <1, 1, 1, 1>]}
scale <0.1, 0.5, 0.1>} rotate -90*x}
plane{y, -10.0-max(pcb_x_size,pcb_y_size)*abs(max(sin((pcb_rotate_x/180)*pi),sin((pcb_rotate_z/180)*pi)))
texture{T_Chrome_2D
normal{waves 0.1 frequency 3000.0 scale 3000.0}} translate<0,0,0>}
#end

//Animaci adat
#if(global_anim=on)
#declare global_anim_showcampath = no;
#end

#if((global_anim=on)|(global_anim_showcampath=yes))
#declare global_anim_npoints_cam_flight=0;
#warning "A rendelkezsre ll animcis adat nem elgsges (min. 3 pont) (Flight path)"
#end

#if((global_anim=on)|(global_anim_showcampath=yes))
#declare global_anim_npoints_cam_view=0;
#warning "A rendelkezsre ll animcis adat nem elgsges (min. 3 pont) (View path)"
#end

#if((global_anim=on)|(global_anim_showcampath=yes))
#end

#if((global_anim_showcampath=yes)&(global_anim=off))
#end
#if(global_anim=on)
camera
{
	location global_anim_spline_cam_flight(clock)
	#if(global_anim_npoints_cam_view>2)
		look_at global_anim_spline_cam_view(clock)
	#else
		look_at global_anim_spline_cam_flight(clock+0.01)-<0,-0.01,0>
	#end
	angle 45
}
light_source
{
	global_anim_spline_cam_flight(clock)
	color rgb <1,1,1>
	spotlight point_at 
	#if(global_anim_npoints_cam_view>2)
		global_anim_spline_cam_view(clock)
	#else
		global_anim_spline_cam_flight(clock+0.01)-<0,-0.01,0>
	#end
	radius 35 falloff  40
}
#else

camera {
  angle    20
  location <0.0 , 364.0 ,-100.0>
  right    x*image_width/image_height
  look_at  <0.0 , 1.5, 0.0>
  rotate   <0,-360*(clock+0.10),0>
}

#end

background{col_bgr}


//Axis uncomment to activate
//object{TOOLS_AXIS_XYZ(100,100,100 //texture{ pigment{rgb<1,0,0>} finish{diffuse 0.8 phong 1}}, //texture{ pigment{rgb<1,1,1>} finish{diffuse 0.8 phong 1}})}

light_source{<lgt1_pos_x,lgt1_pos_y,lgt1_pos_z> White*lgt1_intense}
light_source{<lgt2_pos_x,lgt2_pos_y,lgt2_pos_z> White*lgt2_intense}
light_source{<lgt3_pos_x,lgt3_pos_y,lgt3_pos_z> White*lgt3_intense}
light_source{<lgt4_pos_x,lgt4_pos_y,lgt4_pos_z> White*lgt4_intense}
#end


#macro KARAKTERISZTIKA_RAJZOLO(mac_x_ver,mac_y_ver,mac_z_ver,mac_x_rot,mac_y_rot,mac_z_rot)
union{
#if(pcb_board = on)
difference{
union{
//Panel
prism{-1.500000,0.000000,8
<-0.630000,-0.470000><113.650000,-0.470000>
<113.650000,-0.470000><113.650000,60.160000>
<113.650000,60.160000><-0.630000,60.160000>
<-0.630000,60.160000><-0.630000,-0.470000>
texture{col_brd}}
}//End union(Platine)
//Furat(vals md)/Alkatrszek
//Furat(vals md)/Panel
//Furat(vals md)/Vezetsv
}//End difference(reale Bohrungen/Durchbrche)
#end
#if(pcb_parts=on)//Alkatrszek
union{
#ifndef(pack_C1) #declare global_pack_C1=yes; object {CAP_DIS_ELKO_5MM_10MM("",)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-180.000000,0> rotate<0,0,0> translate<46.990000,0.000000,33.020000>}#end		//Elko 5mm Pitch, 10mm  Diameter, 16mm High C1  E5,0-10
#ifndef(pack_C2) #declare global_pack_C2=yes; object {CAP_DIS_ELKO_5MM_10MM("",)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-90.000000,0> rotate<0,0,0> translate<62.230000,0.000000,54.610000>}#end		//Elko 5mm Pitch, 10mm  Diameter, 16mm High C2  E5,0-10
#ifndef(pack_C3) #declare global_pack_C3=yes; object {CAP_DIS_ELKO_5MM_10MM("",)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-270.000000,0> rotate<0,0,0> translate<36.830000,0.000000,31.750000>}#end		//Elko 5mm Pitch, 10mm  Diameter, 16mm High C3  E5,0-10
#ifndef(pack_C4) #declare global_pack_C4=yes; object {CAP_DIS_ELKO_5MM_10MM("",)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-90.000000,0> rotate<0,0,0> translate<36.830000,0.000000,54.610000>}#end		//Elko 5mm Pitch, 10mm  Diameter, 16mm High C4  E5,0-10
#ifndef(pack_C5) #declare global_pack_C5=yes; object {CAP_DIS_CERAMIC_50MM_76MM("",)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-90.000000,0> rotate<0,0,0> translate<64.770000,0.000000,15.240000>}#end		//ceramic disc capacitator C5  C050-035X075
#ifndef(pack_C6) #declare global_pack_C6=yes; object {CAP_DIS_CERAMIC_50MM_76MM("",)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-180.000000,0> rotate<0,0,0> translate<83.820000,0.000000,13.970000>}#end		//ceramic disc capacitator C6  C050-035X075
#ifndef(pack_C7) #declare global_pack_C7=yes; object {CAP_DIS_CERAMIC_50MM_76MM("",)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-270.000000,0> rotate<0,0,0> translate<90.170000,0.000000,6.350000>}#end		//ceramic disc capacitator C7  C050-035X075
#ifndef(pack_C8) #declare global_pack_C8=yes; object {CAP_DIS_CERAMIC_50MM_76MM("",)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-90.000000,0> rotate<0,0,0> translate<82.550000,0.000000,26.670000>}#end		//ceramic disc capacitator C8  C050-035X075
#ifndef(pack_C9) #declare global_pack_C9=yes; object {CAP_DIS_CERAMIC_50MM_76MM("",)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-180.000000,0> rotate<0,0,0> translate<74.930000,0.000000,44.450000>}#end		//ceramic disc capacitator C9  C050-035X075
#ifndef(pack_C10) #declare global_pack_C10=yes; object {CAP_DIS_ELKO_5MM_10MM("",)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-270.000000,0> rotate<0,0,0> translate<62.230000,0.000000,39.370000>}#end		//Elko 5mm Pitch, 10mm  Diameter, 16mm High C10  E5,0-10
#ifndef(pack_C11) #declare global_pack_C11=yes; object {CAP_DIS_ELKO_5MM_10MM("",)translate<0,0,0> rotate<0,0.000000,0>rotate<0,0.000000,0> rotate<0,0,0> translate<72.390000,0.000000,54.610000>}#end		//Elko 5mm Pitch, 10mm  Diameter, 16mm High C11  E5,0-10
#ifndef(pack_D3) #declare global_pack_D3=yes; object {DIODE_DIS_DO35_102MM_H("1N4148",)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-180.000000,0> rotate<0,0,0> translate<40.640000,0.000000,25.400000>}#end		//Diode DO35 10mm hor. D3 1N4148 DO35-10
#ifndef(pack_D4) #declare global_pack_D4=yes; object {DIODE_DIS_DO35_102MM_H("1N4148",)translate<0,0,0> rotate<0,0.000000,0>rotate<0,0.000000,0> rotate<0,0,0> translate<40.640000,0.000000,22.860000>}#end		//Diode DO35 10mm hor. D4 1N4148 DO35-10
#ifndef(pack_D5) #declare global_pack_D5=yes; object {DIODE_DIS_DO35_102MM_H("1N4148",)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-180.000000,0> rotate<0,0,0> translate<40.640000,0.000000,20.320000>}#end		//Diode DO35 10mm hor. D5 1N4148 DO35-10
#ifndef(pack_D6) #declare global_pack_D6=yes; object {DIODE_DIS_DO35_102MM_H("1N4148",)translate<0,0,0> rotate<0,0.000000,0>rotate<0,0.000000,0> rotate<0,0,0> translate<40.640000,0.000000,17.780000>}#end		//Diode DO35 10mm hor. D6 1N4148 DO35-10
#ifndef(pack_D7) #declare global_pack_D7=yes; object {DIODE_DIS_DO35_102MM_H("1N4148",)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-180.000000,0> rotate<0,0,0> translate<40.640000,0.000000,15.240000>}#end		//Diode DO35 10mm hor. D7 1N4148 DO35-10
#ifndef(pack_D8) #declare global_pack_D8=yes; object {DIODE_DIS_DO35_102MM_H("1N4148",)translate<0,0,0> rotate<0,0.000000,0>rotate<0,0.000000,0> rotate<0,0,0> translate<40.640000,0.000000,12.700000>}#end		//Diode DO35 10mm hor. D8 1N4148 DO35-10
#ifndef(pack_D9) #declare global_pack_D9=yes; object {DIODE_DIS_DO35_102MM_H("1N4148",)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-180.000000,0> rotate<0,0,0> translate<59.690000,0.000000,10.160000>}#end		//Diode DO35 10mm hor. D9 1N4148 DO35-10
#ifndef(pack_D10) #declare global_pack_D10=yes; object {DIODE_DIS_DO35_102MM_H("1N4148",)translate<0,0,0> rotate<0,0.000000,0>rotate<0,0.000000,0> rotate<0,0,0> translate<59.690000,0.000000,5.080000>}#end		//Diode DO35 10mm hor. D10 1N4148 DO35-10
#ifndef(pack_IC1) #declare global_pack_IC1=yes; object {IC_DIS_DIP14("","",)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-90.000000,0> rotate<0,0,0> translate<74.930000,0.000000,33.020000>}#end		//DIP14 IC1  DIL14
#ifndef(pack_IC2) #declare global_pack_IC2=yes; object {IC_DIS_DIP8("","",)translate<0,0,0> rotate<0,0.000000,0>rotate<0,0.000000,0> rotate<0,0,0> translate<72.390000,0.000000,13.970000>}#end		//DIP8 IC2  DIL08
#ifndef(pack_IC3) #declare global_pack_IC3=yes; object {IC_DIS_DIP8("","",)translate<0,0,0> rotate<0,0.000000,0>rotate<0,0.000000,0> rotate<0,0,0> translate<91.440000,0.000000,25.400000>}#end		//DIP8 IC3  DIL08
#ifndef(pack_IC4) #declare global_pack_IC4=yes; object {TR_TO220_S("7815",)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-270.000000,0> rotate<0,0,0> translate<49.530000,0.000000,44.450000>}#end		//TO220 Vertical IC4 7815 78MXXS
#ifndef(pack_IC5) #declare global_pack_IC5=yes; object {TR_TO220_S("7915",)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-90.000000,0> rotate<0,0,0> translate<50.800000,0.000000,54.610000>}#end		//TO220 Vertical IC5 7915 79XXS
#ifndef(pack_IC6) #declare global_pack_IC6=yes; object {TR_TO92_G("78L05Z",)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-180.000000,0> rotate<0,0,0> translate<55.880000,0.000000,33.020000>}#end		//TO92 bend vertical IC6 78L05Z TO92
#ifndef(pack_IC7) #declare global_pack_IC7=yes; object {TR_TO92_G("79L05",)translate<0,0,0> rotate<0,0.000000,0>rotate<0,0.000000,0> rotate<0,0,0> translate<64.770000,0.000000,46.990000>}#end		//TO92 bend vertical IC7 79L05 TO92
#ifndef(pack_JP1) #declare global_pack_JP1=yes; object {PH_2X1J(0,)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-270.000000,0> rotate<0,0,0> translate<101.600000,0.000000,39.370000>}#end		//Jumper 2,54mm Grid 2Pin 1Row (jumper.lib) JP1  JP1
#ifndef(pack_JP2) #declare global_pack_JP2=yes; object {PH_2X1J(0,)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-270.000000,0> rotate<0,0,0> translate<101.600000,0.000000,19.050000>}#end		//Jumper 2,54mm Grid 2Pin 1Row (jumper.lib) JP2  JP1
#ifndef(pack_JP3) #declare global_pack_JP3=yes; object {PH_2X1J(0,)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-90.000000,0> rotate<0,0,0> translate<60.960000,0.000000,27.940000>}#end		//Jumper 2,54mm Grid 2Pin 1Row (jumper.lib) JP3  JP1
#ifndef(pack_JP4) #declare global_pack_JP4=yes; object {PH_1X3()translate<0,0,0> rotate<0,0.000000,0>rotate<0,-270.000000,0> rotate<0,0,0> translate<49.530000,0.000000,7.620000>}#end		//Jumper 2,54mm Grid 3Pin 1Row (jumper.lib) JP4  JP2
#ifndef(pack_JP5) #declare global_pack_JP5=yes; object {PH_1X3()translate<0,0,0> rotate<0,0.000000,0>rotate<0,-270.000000,0> rotate<0,0,0> translate<44.450000,0.000000,7.620000>}#end		//Jumper 2,54mm Grid 3Pin 1Row (jumper.lib) JP5  JP2
#ifndef(pack_JP6) #declare global_pack_JP6=yes; object {PH_1X3()translate<0,0,0> rotate<0,0.000000,0>rotate<0,-180.000000,0> rotate<0,0,0> translate<102.870000,0.000000,29.210000>}#end		//Jumper 2,54mm Grid 3Pin 1Row (jumper.lib) JP6  JP2
#ifndef(pack_Q1) #declare global_pack_Q1=yes; object {TR_TO126_V("BD139",)translate<0,0,0> rotate<0,0.000000,0>rotate<0,0.000000,0> rotate<0,0,0> translate<85.090000,0.000000,43.180000>}#end		//Allo TO-126 tok Q1 BD139 TO126AV
#ifndef(pack_Q2) #declare global_pack_Q2=yes; object {TR_TO126_V("BD140",)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-180.000000,0> rotate<0,0,0> translate<93.980000,0.000000,40.640000>}#end		//Allo TO-126 tok Q2 BD140 TO126AV
#ifndef(pack_R1) #declare global_pack_R1=yes; object {RES_DIS_0204_075MM(texture{pigment{Black}finish{phong 0.2}},texture{pigment{Black}finish{phong 0.2}},texture {T_Silver_5E finish{reflection 0.1}},texture {T_Gold_5C finish{reflection 0.1}},)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-270.000000,0> rotate<0,0,0> translate<67.310000,0.000000,25.400000>}#end		//Discrete Resistor 0,15W 7,5MM Grid R1  0204/7
#ifndef(pack_R2) #declare global_pack_R2=yes; object {RES_DIS_0204_075MM(texture{pigment{Black}finish{phong 0.2}},texture{pigment{Black}finish{phong 0.2}},texture {T_Silver_5E finish{reflection 0.1}},texture {T_Gold_5C finish{reflection 0.1}},)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-180.000000,0> rotate<0,0,0> translate<60.960000,0.000000,20.320000>}#end		//Discrete Resistor 0,15W 7,5MM Grid R2  0204/7
#ifndef(pack_R3) #declare global_pack_R3=yes; object {RES_DIS_0204_075MM(texture{pigment{Black}finish{phong 0.2}},texture{pigment{Black}finish{phong 0.2}},texture {T_Silver_5E finish{reflection 0.1}},texture {T_Gold_5C finish{reflection 0.1}},)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-180.000000,0> rotate<0,0,0> translate<60.960000,0.000000,22.860000>}#end		//Discrete Resistor 0,15W 7,5MM Grid R3  0204/7
#ifndef(pack_R4) #declare global_pack_R4=yes; object {RES_DIS_0204_075MM(texture{pigment{Black}finish{phong 0.2}},texture{pigment{Black}finish{phong 0.2}},texture {T_Silver_5E finish{reflection 0.1}},texture {T_Gold_5C finish{reflection 0.1}},)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-270.000000,0> rotate<0,0,0> translate<54.610000,0.000000,24.130000>}#end		//Discrete Resistor 0,15W 7,5MM Grid R4  0204/7
#ifndef(pack_R5) #declare global_pack_R5=yes; object {RES_DIS_0204_075MM(texture{pigment{Black}finish{phong 0.2}},texture{pigment{Black}finish{phong 0.2}},texture {T_Silver_5E finish{reflection 0.1}},texture {T_Gold_5C finish{reflection 0.1}},)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-270.000000,0> rotate<0,0,0> translate<52.070000,0.000000,24.130000>}#end		//Discrete Resistor 0,15W 7,5MM Grid R5  0204/7
#ifndef(pack_R6) #declare global_pack_R6=yes; object {RES_DIS_0204_075MM(texture{pigment{Black}finish{phong 0.2}},texture{pigment{Black}finish{phong 0.2}},texture {T_Silver_5E finish{reflection 0.1}},texture {T_Gold_5C finish{reflection 0.1}},)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-270.000000,0> rotate<0,0,0> translate<82.550000,0.000000,7.620000>}#end		//Discrete Resistor 0,15W 7,5MM Grid R6  0204/7
#ifndef(pack_R7) #declare global_pack_R7=yes; object {RES_DIS_0204_075MM(texture{pigment{Black}finish{phong 0.2}},texture{pigment{Black}finish{phong 0.2}},texture {T_Silver_5E finish{reflection 0.1}},texture {T_Gold_5C finish{reflection 0.1}},)translate<0,0,0> rotate<0,0.000000,0>rotate<0,0.000000,0> rotate<0,0,0> translate<72.390000,0.000000,5.080000>}#end		//Discrete Resistor 0,15W 7,5MM Grid R7  0204/7
#ifndef(pack_R8) #declare global_pack_R8=yes; object {RES_DIS_0204_075MM(texture{pigment{Black}finish{phong 0.2}},texture{pigment{Black}finish{phong 0.2}},texture {T_Silver_5E finish{reflection 0.1}},texture {T_Gold_5C finish{reflection 0.1}},)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-90.000000,0> rotate<0,0,0> translate<78.740000,0.000000,8.890000>}#end		//Discrete Resistor 0,15W 7,5MM Grid R8  0204/7
#ifndef(pack_R9) #declare global_pack_R9=yes; object {RES_DIS_0204_075MM(texture{pigment{Black}finish{phong 0.2}},texture{pigment{Black}finish{phong 0.2}},texture {T_Silver_5E finish{reflection 0.1}},texture {T_Gold_5C finish{reflection 0.1}},)translate<0,0,0> rotate<0,0.000000,0>rotate<0,0.000000,0> rotate<0,0,0> translate<74.930000,0.000000,21.590000>}#end		//Discrete Resistor 0,15W 7,5MM Grid R9  0204/7
#ifndef(pack_R10) #declare global_pack_R10=yes; object {RES_DIS_0204_075MM(texture{pigment{Black}finish{phong 0.2}},texture{pigment{Black}finish{phong 0.2}},texture {T_Silver_5E finish{reflection 0.1}},texture {T_Gold_5C finish{reflection 0.1}},)translate<0,0,0> rotate<0,0.000000,0>rotate<0,0.000000,0> rotate<0,0,0> translate<85.090000,0.000000,17.780000>}#end		//Discrete Resistor 0,15W 7,5MM Grid R10  0204/7
#ifndef(pack_R11) #declare global_pack_R11=yes; object {RES_DIS_0204_075MM(texture{pigment{Black}finish{phong 0.2}},texture{pigment{Black}finish{phong 0.2}},texture {T_Silver_5E finish{reflection 0.1}},texture {T_Gold_5C finish{reflection 0.1}},)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-90.000000,0> rotate<0,0,0> translate<86.360000,0.000000,7.620000>}#end		//Discrete Resistor 0,15W 7,5MM Grid R11  0204/7
#ifndef(pack_R12) #declare global_pack_R12=yes; object {RES_DIS_0204_075MM(texture{pigment{Black}finish{phong 0.2}},texture{pigment{Black}finish{phong 0.2}},texture {T_Silver_5E finish{reflection 0.1}},texture {T_Gold_5C finish{reflection 0.1}},)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-90.000000,0> rotate<0,0,0> translate<104.140000,0.000000,7.620000>}#end		//Discrete Resistor 0,15W 7,5MM Grid R12  0204/7
#ifndef(pack_R13) #declare global_pack_R13=yes; object {RES_DIS_0204_075MM(texture{pigment{Black}finish{phong 0.2}},texture{pigment{Black}finish{phong 0.2}},texture {T_Silver_5E finish{reflection 0.1}},texture {T_Gold_5C finish{reflection 0.1}},)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-90.000000,0> rotate<0,0,0> translate<97.790000,0.000000,7.620000>}#end		//Discrete Resistor 0,15W 7,5MM Grid R13  0204/7
#ifndef(pack_R14) #declare global_pack_R14=yes; object {RES_DIS_0204_075MM(texture{pigment{Black}finish{phong 0.2}},texture{pigment{Black}finish{phong 0.2}},texture {T_Silver_5E finish{reflection 0.1}},texture {T_Gold_5C finish{reflection 0.1}},)translate<0,0,0> rotate<0,0.000000,0>rotate<0,0.000000,0> rotate<0,0,0> translate<100.330000,0.000000,13.970000>}#end		//Discrete Resistor 0,15W 7,5MM Grid R14  0204/7
#ifndef(pack_R15) #declare global_pack_R15=yes; object {RES_DIS_0204_075MM(texture{pigment{Black}finish{phong 0.2}},texture{pigment{Black}finish{phong 0.2}},texture {T_Silver_5E finish{reflection 0.1}},texture {T_Gold_5C finish{reflection 0.1}},)translate<0,0,0> rotate<0,0.000000,0>rotate<0,0.000000,0> rotate<0,0,0> translate<97.790000,0.000000,33.020000>}#end		//Discrete Resistor 0,15W 7,5MM Grid R15  0204/7
#ifndef(pack_U_3) #declare global_pack_U_3=yes; object {TRAFO_MYRRA_EI_30_2_125()translate<0,0,0> rotate<0,0.000000,0>rotate<0,-180.000000,0> rotate<0,0,0> translate<15.240000,0.000000,39.370000>}#end		//IE30-12.5 Transformer 2 secondary wirings U$3 TRAFO_2_15V TRAFO_2_15V
#ifndef(pack_U_4) #declare global_pack_U_4=yes; object {DIODE_REC_RB1A("B80C",)translate<0,0,0> rotate<0,0.000000,0>rotate<0,-90.000000,0> rotate<0,0,0> translate<36.830000,0.000000,43.180000>}#end		//Rectifier 1A, Round U$4 B80C B80C
}//End union
#end
#if(pcb_pads_smds=on)
//Forrszemek s SMD/Alkatrszek
#ifndef(global_pack_B) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(2.540000,1.016000,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<100.330000,0,54.610000> texture{col_thl}}
#ifndef(global_pack_C) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(2.540000,1.016000,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<83.820000,0,54.610000> texture{col_thl}}
#ifndef(global_pack_C1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(2.184400,1.016000,1,16,1+global_tmp,0) rotate<0,-180.000000,0>translate<49.530000,0,33.020000> texture{col_thl}}
#ifndef(global_pack_C1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(2.184400,1.016000,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<44.450000,0,33.020000> texture{col_thl}}
#ifndef(global_pack_C2) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(2.184400,1.016000,1,16,1+global_tmp,0) rotate<0,-90.000000,0>translate<62.230000,0,52.070000> texture{col_thl}}
#ifndef(global_pack_C2) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(2.184400,1.016000,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<62.230000,0,57.150000> texture{col_thl}}
#ifndef(global_pack_C3) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(2.184400,1.016000,1,16,1+global_tmp,0) rotate<0,-270.000000,0>translate<36.830000,0,34.290000> texture{col_thl}}
#ifndef(global_pack_C3) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(2.184400,1.016000,1,16,2+global_tmp,0) rotate<0,-270.000000,0>translate<36.830000,0,29.210000> texture{col_thl}}
#ifndef(global_pack_C4) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(2.184400,1.016000,1,16,1+global_tmp,0) rotate<0,-90.000000,0>translate<36.830000,0,52.070000> texture{col_thl}}
#ifndef(global_pack_C4) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(2.184400,1.016000,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<36.830000,0,57.150000> texture{col_thl}}
#ifndef(global_pack_C5) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<64.770000,0,12.700000> texture{col_thl}}
#ifndef(global_pack_C5) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<64.770000,0,17.780000> texture{col_thl}}
#ifndef(global_pack_C6) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<86.360000,0,13.970000> texture{col_thl}}
#ifndef(global_pack_C6) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<81.280000,0,13.970000> texture{col_thl}}
#ifndef(global_pack_C7) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,2+global_tmp,0) rotate<0,-270.000000,0>translate<90.170000,0,8.890000> texture{col_thl}}
#ifndef(global_pack_C7) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,2+global_tmp,0) rotate<0,-270.000000,0>translate<90.170000,0,3.810000> texture{col_thl}}
#ifndef(global_pack_C8) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<82.550000,0,24.130000> texture{col_thl}}
#ifndef(global_pack_C8) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<82.550000,0,29.210000> texture{col_thl}}
#ifndef(global_pack_C9) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<77.470000,0,44.450000> texture{col_thl}}
#ifndef(global_pack_C9) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<72.390000,0,44.450000> texture{col_thl}}
#ifndef(global_pack_C10) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(2.184400,1.016000,1,16,1+global_tmp,0) rotate<0,-270.000000,0>translate<62.230000,0,41.910000> texture{col_thl}}
#ifndef(global_pack_C10) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(2.184400,1.016000,1,16,2+global_tmp,0) rotate<0,-270.000000,0>translate<62.230000,0,36.830000> texture{col_thl}}
#ifndef(global_pack_C11) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(2.184400,1.016000,1,16,1+global_tmp,0) rotate<0,-0.000000,0>translate<69.850000,0,54.610000> texture{col_thl}}
#ifndef(global_pack_C11) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(2.184400,1.016000,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<74.930000,0,54.610000> texture{col_thl}}
#ifndef(global_pack_D3) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,3+global_tmp,100) rotate<0,-180.000000,0>translate<35.560000,0,25.400000> texture{col_thl}}
#ifndef(global_pack_D3) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,3+global_tmp,100) rotate<0,-180.000000,0>translate<45.720000,0,25.400000> texture{col_thl}}
#ifndef(global_pack_D4) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,3+global_tmp,100) rotate<0,-0.000000,0>translate<45.720000,0,22.860000> texture{col_thl}}
#ifndef(global_pack_D4) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,3+global_tmp,100) rotate<0,-0.000000,0>translate<35.560000,0,22.860000> texture{col_thl}}
#ifndef(global_pack_D5) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,3+global_tmp,100) rotate<0,-180.000000,0>translate<35.560000,0,20.320000> texture{col_thl}}
#ifndef(global_pack_D5) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,3+global_tmp,100) rotate<0,-180.000000,0>translate<45.720000,0,20.320000> texture{col_thl}}
#ifndef(global_pack_D6) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,3+global_tmp,100) rotate<0,-0.000000,0>translate<45.720000,0,17.780000> texture{col_thl}}
#ifndef(global_pack_D6) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,3+global_tmp,100) rotate<0,-0.000000,0>translate<35.560000,0,17.780000> texture{col_thl}}
#ifndef(global_pack_D7) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,3+global_tmp,100) rotate<0,-180.000000,0>translate<35.560000,0,15.240000> texture{col_thl}}
#ifndef(global_pack_D7) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,3+global_tmp,100) rotate<0,-180.000000,0>translate<45.720000,0,15.240000> texture{col_thl}}
#ifndef(global_pack_D8) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,3+global_tmp,100) rotate<0,-0.000000,0>translate<45.720000,0,12.700000> texture{col_thl}}
#ifndef(global_pack_D8) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,3+global_tmp,100) rotate<0,-0.000000,0>translate<35.560000,0,12.700000> texture{col_thl}}
#ifndef(global_pack_D9) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,3+global_tmp,100) rotate<0,-180.000000,0>translate<54.610000,0,10.160000> texture{col_thl}}
#ifndef(global_pack_D9) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,3+global_tmp,100) rotate<0,-180.000000,0>translate<64.770000,0,10.160000> texture{col_thl}}
#ifndef(global_pack_D10) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,3+global_tmp,100) rotate<0,-0.000000,0>translate<64.770000,0,5.080000> texture{col_thl}}
#ifndef(global_pack_D10) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,3+global_tmp,100) rotate<0,-0.000000,0>translate<54.610000,0,5.080000> texture{col_thl}}
#ifndef(global_pack_E) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(2.540000,1.016000,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<92.710000,0,54.610000> texture{col_thl}}
#ifndef(global_pack_IC1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,3+global_tmp,100) rotate<0,-180.000000,0>translate<78.740000,0,25.400000> texture{col_thl}}
#ifndef(global_pack_IC1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,3+global_tmp,100) rotate<0,-180.000000,0>translate<78.740000,0,27.940000> texture{col_thl}}
#ifndef(global_pack_IC1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,3+global_tmp,100) rotate<0,-180.000000,0>translate<78.740000,0,30.480000> texture{col_thl}}
#ifndef(global_pack_IC1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,3+global_tmp,100) rotate<0,-180.000000,0>translate<78.740000,0,33.020000> texture{col_thl}}
#ifndef(global_pack_IC1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,3+global_tmp,100) rotate<0,-180.000000,0>translate<78.740000,0,35.560000> texture{col_thl}}
#ifndef(global_pack_IC1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,3+global_tmp,100) rotate<0,-180.000000,0>translate<78.740000,0,38.100000> texture{col_thl}}
#ifndef(global_pack_IC1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,3+global_tmp,100) rotate<0,-180.000000,0>translate<78.740000,0,40.640000> texture{col_thl}}
#ifndef(global_pack_IC1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,3+global_tmp,100) rotate<0,-180.000000,0>translate<71.120000,0,40.640000> texture{col_thl}}
#ifndef(global_pack_IC1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,3+global_tmp,100) rotate<0,-180.000000,0>translate<71.120000,0,38.100000> texture{col_thl}}
#ifndef(global_pack_IC1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,3+global_tmp,100) rotate<0,-180.000000,0>translate<71.120000,0,35.560000> texture{col_thl}}
#ifndef(global_pack_IC1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,3+global_tmp,100) rotate<0,-180.000000,0>translate<71.120000,0,33.020000> texture{col_thl}}
#ifndef(global_pack_IC1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,3+global_tmp,100) rotate<0,-180.000000,0>translate<71.120000,0,30.480000> texture{col_thl}}
#ifndef(global_pack_IC1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,3+global_tmp,100) rotate<0,-180.000000,0>translate<71.120000,0,27.940000> texture{col_thl}}
#ifndef(global_pack_IC1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,3+global_tmp,100) rotate<0,-180.000000,0>translate<71.120000,0,25.400000> texture{col_thl}}
#ifndef(global_pack_IC2) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,3+global_tmp,100) rotate<0,-90.000000,0>translate<68.580000,0,10.160000> texture{col_thl}}
#ifndef(global_pack_IC2) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,3+global_tmp,100) rotate<0,-90.000000,0>translate<71.120000,0,10.160000> texture{col_thl}}
#ifndef(global_pack_IC2) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,3+global_tmp,100) rotate<0,-90.000000,0>translate<73.660000,0,10.160000> texture{col_thl}}
#ifndef(global_pack_IC2) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,3+global_tmp,100) rotate<0,-90.000000,0>translate<76.200000,0,10.160000> texture{col_thl}}
#ifndef(global_pack_IC2) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,3+global_tmp,100) rotate<0,-90.000000,0>translate<76.200000,0,17.780000> texture{col_thl}}
#ifndef(global_pack_IC2) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,3+global_tmp,100) rotate<0,-90.000000,0>translate<73.660000,0,17.780000> texture{col_thl}}
#ifndef(global_pack_IC2) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,3+global_tmp,100) rotate<0,-90.000000,0>translate<71.120000,0,17.780000> texture{col_thl}}
#ifndef(global_pack_IC2) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,3+global_tmp,100) rotate<0,-90.000000,0>translate<68.580000,0,17.780000> texture{col_thl}}
#ifndef(global_pack_IC3) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,3+global_tmp,100) rotate<0,-90.000000,0>translate<87.630000,0,21.590000> texture{col_thl}}
#ifndef(global_pack_IC3) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,3+global_tmp,100) rotate<0,-90.000000,0>translate<90.170000,0,21.590000> texture{col_thl}}
#ifndef(global_pack_IC3) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,3+global_tmp,100) rotate<0,-90.000000,0>translate<92.710000,0,21.590000> texture{col_thl}}
#ifndef(global_pack_IC3) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,3+global_tmp,100) rotate<0,-90.000000,0>translate<95.250000,0,21.590000> texture{col_thl}}
#ifndef(global_pack_IC3) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,3+global_tmp,100) rotate<0,-90.000000,0>translate<95.250000,0,29.210000> texture{col_thl}}
#ifndef(global_pack_IC3) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,3+global_tmp,100) rotate<0,-90.000000,0>translate<92.710000,0,29.210000> texture{col_thl}}
#ifndef(global_pack_IC3) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,3+global_tmp,100) rotate<0,-90.000000,0>translate<90.170000,0,29.210000> texture{col_thl}}
#ifndef(global_pack_IC3) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,3+global_tmp,100) rotate<0,-90.000000,0>translate<87.630000,0,29.210000> texture{col_thl}}
#ifndef(global_pack_IC4) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(2.032000,1.016000,1,16,3+global_tmp,100) rotate<0,-0.000000,0>translate<46.990000,0,44.450000> texture{col_thl}}
#ifndef(global_pack_IC4) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(2.032000,1.016000,1,16,3+global_tmp,100) rotate<0,-0.000000,0>translate<46.990000,0,46.990000> texture{col_thl}}
#ifndef(global_pack_IC4) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(2.032000,1.016000,1,16,3+global_tmp,100) rotate<0,-0.000000,0>translate<46.990000,0,41.910000> texture{col_thl}}
#ifndef(global_pack_IC5) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(2.032000,1.016000,1,16,3+global_tmp,100) rotate<0,-180.000000,0>translate<53.340000,0,52.070000> texture{col_thl}}
#ifndef(global_pack_IC5) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(2.032000,1.016000,1,16,3+global_tmp,100) rotate<0,-180.000000,0>translate<53.340000,0,54.610000> texture{col_thl}}
#ifndef(global_pack_IC5) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(2.032000,1.016000,1,16,3+global_tmp,100) rotate<0,-180.000000,0>translate<53.340000,0,57.150000> texture{col_thl}}
#ifndef(global_pack_IC6) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<57.150000,0,33.020000> texture{col_thl}}
#ifndef(global_pack_IC6) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<55.880000,0,31.115000> texture{col_thl}}
#ifndef(global_pack_IC6) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<54.610000,0,33.020000> texture{col_thl}}
#ifndef(global_pack_IC7) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<63.500000,0,46.990000> texture{col_thl}}
#ifndef(global_pack_IC7) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<64.770000,0,48.895000> texture{col_thl}}
#ifndef(global_pack_IC7) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<66.040000,0,46.990000> texture{col_thl}}
#ifndef(global_pack_J1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<62.230000,0,15.240000> texture{col_thl}}
#ifndef(global_pack_J1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<57.150000,0,15.240000> texture{col_thl}}
#ifndef(global_pack_J2) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<80.010000,0,45.720000> texture{col_thl}}
#ifndef(global_pack_J2) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<80.010000,0,50.800000> texture{col_thl}}
#ifndef(global_pack_J3) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<93.980000,0,35.560000> texture{col_thl}}
#ifndef(global_pack_J3) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<99.060000,0,35.560000> texture{col_thl}}
#ifndef(global_pack_J4) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<82.550000,0,45.720000> texture{col_thl}}
#ifndef(global_pack_J4) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<82.550000,0,50.800000> texture{col_thl}}
#ifndef(global_pack_J5) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<49.530000,0,38.100000> texture{col_thl}}
#ifndef(global_pack_J5) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<54.610000,0,38.100000> texture{col_thl}}
#ifndef(global_pack_J6) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<100.330000,0,6.350000> texture{col_thl}}
#ifndef(global_pack_J6) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<100.330000,0,11.430000> texture{col_thl}}
#ifndef(global_pack_J7) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<85.090000,0,21.590000> texture{col_thl}}
#ifndef(global_pack_J7) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<85.090000,0,31.750000> texture{col_thl}}
#ifndef(global_pack_J8) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<95.250000,0,46.990000> texture{col_thl}}
#ifndef(global_pack_J8) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<85.090000,0,46.990000> texture{col_thl}}
#ifndef(global_pack_JP1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.930400,0.914400,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<100.330000,0,39.370000> texture{col_thl}}
#ifndef(global_pack_JP1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.930400,0.914400,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<102.870000,0,39.370000> texture{col_thl}}
#ifndef(global_pack_JP2) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.930400,0.914400,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<100.330000,0,19.050000> texture{col_thl}}
#ifndef(global_pack_JP2) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.930400,0.914400,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<102.870000,0,19.050000> texture{col_thl}}
#ifndef(global_pack_JP3) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.930400,0.914400,1,16,3+global_tmp,100) rotate<0,-90.000000,0>translate<62.230000,0,27.940000> texture{col_thl}}
#ifndef(global_pack_JP3) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.930400,0.914400,1,16,3+global_tmp,100) rotate<0,-90.000000,0>translate<59.690000,0,27.940000> texture{col_thl}}
#ifndef(global_pack_JP4) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.930400,0.914400,1,16,3+global_tmp,100) rotate<0,-0.000000,0>translate<49.530000,0,10.160000> texture{col_thl}}
#ifndef(global_pack_JP4) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.930400,0.914400,1,16,3+global_tmp,100) rotate<0,-0.000000,0>translate<49.530000,0,7.620000> texture{col_thl}}
#ifndef(global_pack_JP4) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.930400,0.914400,1,16,3+global_tmp,100) rotate<0,-0.000000,0>translate<49.530000,0,5.080000> texture{col_thl}}
#ifndef(global_pack_JP5) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.930400,0.914400,1,16,3+global_tmp,100) rotate<0,-0.000000,0>translate<44.450000,0,10.160000> texture{col_thl}}
#ifndef(global_pack_JP5) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.930400,0.914400,1,16,3+global_tmp,100) rotate<0,-0.000000,0>translate<44.450000,0,7.620000> texture{col_thl}}
#ifndef(global_pack_JP5) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.930400,0.914400,1,16,3+global_tmp,100) rotate<0,-0.000000,0>translate<44.450000,0,5.080000> texture{col_thl}}
#ifndef(global_pack_JP6) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.930400,0.914400,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<105.410000,0,29.210000> texture{col_thl}}
#ifndef(global_pack_JP6) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.930400,0.914400,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<102.870000,0,29.210000> texture{col_thl}}
#ifndef(global_pack_JP6) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.930400,0.914400,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<100.330000,0,29.210000> texture{col_thl}}
#ifndef(global_pack_PAD3) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(2.540000,1.016000,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<5.080000,0,21.590000> texture{col_thl}}
#ifndef(global_pack_PAD4) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(2.540000,1.016000,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<25.400000,0,21.590000> texture{col_thl}}
#ifndef(global_pack_PAD6) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(2.540000,1.016000,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<2.540000,0,57.150000> texture{col_thl}}
#ifndef(global_pack_PAD7) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(2.540000,1.016000,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<110.490000,0,57.150000> texture{col_thl}}
#ifndef(global_pack_PAD8) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(2.540000,1.016000,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<2.540000,0,2.540000> texture{col_thl}}
#ifndef(global_pack_PAD9) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(2.540000,1.016000,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<110.490000,0,3.810000> texture{col_thl}}
#ifndef(global_pack_Q1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(2.032000,1.016000,1,16,3+global_tmp,100) rotate<0,-90.000000,0>translate<87.376000,0,41.910000> texture{col_thl}}
#ifndef(global_pack_Q1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(2.032000,1.016000,1,16,3+global_tmp,100) rotate<0,-90.000000,0>translate<85.090000,0,41.910000> texture{col_thl}}
#ifndef(global_pack_Q1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(2.032000,1.016000,1,16,3+global_tmp,100) rotate<0,-90.000000,0>translate<82.804000,0,41.910000> texture{col_thl}}
#ifndef(global_pack_Q2) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(2.032000,1.016000,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<91.694000,0,41.910000> texture{col_thl}}
#ifndef(global_pack_Q2) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(2.032000,1.016000,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<93.980000,0,41.910000> texture{col_thl}}
#ifndef(global_pack_Q2) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(2.032000,1.016000,1,16,3+global_tmp,100) rotate<0,-270.000000,0>translate<96.266000,0,41.910000> texture{col_thl}}
#ifndef(global_pack_R1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,2+global_tmp,0) rotate<0,-270.000000,0>translate<67.310000,0,29.210000> texture{col_thl}}
#ifndef(global_pack_R1) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,2+global_tmp,0) rotate<0,-270.000000,0>translate<67.310000,0,21.590000> texture{col_thl}}
#ifndef(global_pack_R2) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<64.770000,0,20.320000> texture{col_thl}}
#ifndef(global_pack_R2) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<57.150000,0,20.320000> texture{col_thl}}
#ifndef(global_pack_R3) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<64.770000,0,22.860000> texture{col_thl}}
#ifndef(global_pack_R3) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,2+global_tmp,0) rotate<0,-180.000000,0>translate<57.150000,0,22.860000> texture{col_thl}}
#ifndef(global_pack_R4) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,2+global_tmp,0) rotate<0,-270.000000,0>translate<54.610000,0,27.940000> texture{col_thl}}
#ifndef(global_pack_R4) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,2+global_tmp,0) rotate<0,-270.000000,0>translate<54.610000,0,20.320000> texture{col_thl}}
#ifndef(global_pack_R5) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,2+global_tmp,0) rotate<0,-270.000000,0>translate<52.070000,0,27.940000> texture{col_thl}}
#ifndef(global_pack_R5) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,2+global_tmp,0) rotate<0,-270.000000,0>translate<52.070000,0,20.320000> texture{col_thl}}
#ifndef(global_pack_R6) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,2+global_tmp,0) rotate<0,-270.000000,0>translate<82.550000,0,11.430000> texture{col_thl}}
#ifndef(global_pack_R6) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,2+global_tmp,0) rotate<0,-270.000000,0>translate<82.550000,0,3.810000> texture{col_thl}}
#ifndef(global_pack_R7) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<68.580000,0,5.080000> texture{col_thl}}
#ifndef(global_pack_R7) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<76.200000,0,5.080000> texture{col_thl}}
#ifndef(global_pack_R8) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<78.740000,0,5.080000> texture{col_thl}}
#ifndef(global_pack_R8) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<78.740000,0,12.700000> texture{col_thl}}
#ifndef(global_pack_R9) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<71.120000,0,21.590000> texture{col_thl}}
#ifndef(global_pack_R9) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<78.740000,0,21.590000> texture{col_thl}}
#ifndef(global_pack_R10) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<81.280000,0,17.780000> texture{col_thl}}
#ifndef(global_pack_R10) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<88.900000,0,17.780000> texture{col_thl}}
#ifndef(global_pack_R11) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<86.360000,0,3.810000> texture{col_thl}}
#ifndef(global_pack_R11) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<86.360000,0,11.430000> texture{col_thl}}
#ifndef(global_pack_R12) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<104.140000,0,3.810000> texture{col_thl}}
#ifndef(global_pack_R12) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<104.140000,0,11.430000> texture{col_thl}}
#ifndef(global_pack_R13) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<97.790000,0,3.810000> texture{col_thl}}
#ifndef(global_pack_R13) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,2+global_tmp,0) rotate<0,-90.000000,0>translate<97.790000,0,11.430000> texture{col_thl}}
#ifndef(global_pack_R14) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<96.520000,0,13.970000> texture{col_thl}}
#ifndef(global_pack_R14) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<104.140000,0,13.970000> texture{col_thl}}
#ifndef(global_pack_R15) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<93.980000,0,33.020000> texture{col_thl}}
#ifndef(global_pack_R15) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.828800,0.812800,1,16,2+global_tmp,0) rotate<0,-0.000000,0>translate<101.600000,0,33.020000> texture{col_thl}}
#ifndef(global_pack_U_3) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(2.316000,1.300000,1,16,1+global_tmp,0) rotate<0,-180.000000,0>translate<25.400000,0,29.210000> texture{col_thl}}
#ifndef(global_pack_U_3) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(2.316000,1.300000,1,16,1+global_tmp,0) rotate<0,-180.000000,0>translate<5.080000,0,29.210000> texture{col_thl}}
#ifndef(global_pack_U_3) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(2.316000,1.300000,1,16,1+global_tmp,0) rotate<0,-180.000000,0>translate<25.400000,0,49.530000> texture{col_thl}}
#ifndef(global_pack_U_3) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(2.316000,1.300000,1,16,1+global_tmp,0) rotate<0,-180.000000,0>translate<20.320000,0,49.530000> texture{col_thl}}
#ifndef(global_pack_U_3) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(2.316000,1.300000,1,16,1+global_tmp,0) rotate<0,-180.000000,0>translate<10.160000,0,49.530000> texture{col_thl}}
#ifndef(global_pack_U_3) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(2.316000,1.300000,1,16,1+global_tmp,0) rotate<0,-180.000000,0>translate<5.080000,0,49.530000> texture{col_thl}}
#ifndef(global_pack_U_4) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.816000,0.800000,1,16,1+global_tmp,0) rotate<0,-90.000000,0>translate<34.290000,0,40.640000> texture{col_thl}}
#ifndef(global_pack_U_4) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.816000,0.800000,1,16,1+global_tmp,0) rotate<0,-90.000000,0>translate<39.370000,0,45.720000> texture{col_thl}}
#ifndef(global_pack_U_4) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.816000,0.800000,1,16,1+global_tmp,0) rotate<0,-90.000000,0>translate<34.290000,0,45.720000> texture{col_thl}}
#ifndef(global_pack_U_4) #local global_tmp=0; #else #local global_tmp=100; #end object{TOOLS_PCB_VIA(1.816000,0.800000,1,16,1+global_tmp,0) rotate<0,-90.000000,0>translate<39.370000,0,40.640000> texture{col_thl}}
//Alkatrszek/Vezetsv
#end
#if(pcb_wires=on)
union{
//Jelek
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<2.540000,-1.535000,33.020000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<2.540000,-1.535000,50.800000>}
box{<0,0,-0.203200><17.780000,0.035000,0.203200> rotate<0,90.000000,0> translate<2.540000,-1.535000,50.800000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<2.540000,-1.535000,33.020000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<3.810000,-1.535000,31.750000>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,44.997030,0> translate<2.540000,-1.535000,33.020000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<2.540000,-1.535000,50.800000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<3.810000,-1.535000,52.070000>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,-44.997030,0> translate<2.540000,-1.535000,50.800000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<5.080000,-1.535000,21.590000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<5.080000,-1.535000,29.210000>}
box{<0,0,-0.203200><7.620000,0.035000,0.203200> rotate<0,90.000000,0> translate<5.080000,-1.535000,29.210000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<3.810000,-1.535000,52.070000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<7.620000,-1.535000,52.070000>}
box{<0,0,-0.203200><3.810000,0.035000,0.203200> rotate<0,0.000000,0> translate<3.810000,-1.535000,52.070000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<5.080000,-1.535000,49.530000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<8.890000,-1.535000,45.720000>}
box{<0,0,-0.203200><5.388154,0.035000,0.203200> rotate<0,44.997030,0> translate<5.080000,-1.535000,49.530000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<7.620000,-1.535000,52.070000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<10.160000,-1.535000,49.530000>}
box{<0,0,-0.203200><3.592102,0.035000,0.203200> rotate<0,44.997030,0> translate<7.620000,-1.535000,52.070000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<10.160000,-1.535000,49.530000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<12.700000,-1.535000,52.070000>}
box{<0,0,-0.203200><3.592102,0.035000,0.203200> rotate<0,-44.997030,0> translate<10.160000,-1.535000,49.530000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<12.700000,-1.535000,52.070000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<17.780000,-1.535000,52.070000>}
box{<0,0,-0.203200><5.080000,0.035000,0.203200> rotate<0,0.000000,0> translate<12.700000,-1.535000,52.070000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<17.780000,-1.535000,52.070000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<20.320000,-1.535000,49.530000>}
box{<0,0,-0.203200><3.592102,0.035000,0.203200> rotate<0,44.997030,0> translate<17.780000,-1.535000,52.070000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<20.320000,-1.535000,49.530000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<24.130000,-1.535000,53.340000>}
box{<0,0,-0.203200><5.388154,0.035000,0.203200> rotate<0,-44.997030,0> translate<20.320000,-1.535000,49.530000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<25.400000,-1.535000,21.590000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<25.400000,-1.535000,29.210000>}
box{<0,0,-0.203200><7.620000,0.035000,0.203200> rotate<0,90.000000,0> translate<25.400000,-1.535000,29.210000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<33.020000,-1.535000,12.700000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<33.020000,-1.535000,17.780000>}
box{<0,0,-0.203200><5.080000,0.035000,0.203200> rotate<0,90.000000,0> translate<33.020000,-1.535000,17.780000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<33.020000,-1.535000,17.780000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<33.020000,-1.535000,22.860000>}
box{<0,0,-0.203200><5.080000,0.035000,0.203200> rotate<0,90.000000,0> translate<33.020000,-1.535000,22.860000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<24.130000,-1.535000,53.340000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<33.020000,-1.535000,53.340000>}
box{<0,0,-0.203200><8.890000,0.035000,0.203200> rotate<0,0.000000,0> translate<24.130000,-1.535000,53.340000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<33.020000,-1.535000,53.340000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<33.020000,-1.535000,57.931100>}
box{<0,0,-0.203200><4.591100,0.035000,0.203200> rotate<0,90.000000,0> translate<33.020000,-1.535000,57.931100> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.290000,-1.535000,38.100000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.290000,-1.535000,40.640000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,90.000000,0> translate<34.290000,-1.535000,40.640000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<8.890000,-1.535000,45.720000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.290000,-1.535000,45.720000>}
box{<0,0,-0.203200><25.400000,0.035000,0.203200> rotate<0,0.000000,0> translate<8.890000,-1.535000,45.720000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<33.020000,-1.535000,53.340000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.290000,-1.535000,52.070000>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,44.997030,0> translate<33.020000,-1.535000,53.340000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<33.020000,-1.535000,57.931100>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.290000,-1.535000,59.201100>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,-44.997030,0> translate<33.020000,-1.535000,57.931100> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<33.020000,-1.535000,12.700000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<35.560000,-1.535000,12.700000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,0.000000,0> translate<33.020000,-1.535000,12.700000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<35.560000,-1.535000,6.350000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<35.560000,-1.535000,12.700000>}
box{<0,0,-0.203200><6.350000,0.035000,0.203200> rotate<0,90.000000,0> translate<35.560000,-1.535000,12.700000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<33.020000,-1.535000,17.780000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<35.560000,-1.535000,17.780000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,0.000000,0> translate<33.020000,-1.535000,17.780000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<33.020000,-1.535000,22.860000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<35.560000,-1.535000,22.860000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,0.000000,0> translate<33.020000,-1.535000,22.860000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.290000,-1.535000,38.100000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<35.560000,-1.535000,38.100000>}
box{<0,0,-0.203200><1.270000,0.035000,0.203200> rotate<0,0.000000,0> translate<34.290000,-1.535000,38.100000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<25.400000,-1.535000,49.530000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<35.560000,-1.535000,49.530000>}
box{<0,0,-0.203200><10.160000,0.035000,0.203200> rotate<0,0.000000,0> translate<25.400000,-1.535000,49.530000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<35.560000,-1.535000,6.350000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<36.830000,-1.535000,5.080000>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,44.997030,0> translate<35.560000,-1.535000,6.350000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<35.560000,-1.535000,38.100000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<36.830000,-1.535000,36.830000>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,44.997030,0> translate<35.560000,-1.535000,38.100000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<36.830000,-1.535000,34.290000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<36.830000,-1.535000,36.830000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,90.000000,0> translate<36.830000,-1.535000,36.830000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<36.830000,-1.535000,48.260000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<36.830000,-1.535000,43.180000>}
box{<0,0,-0.203200><5.080000,0.035000,0.203200> rotate<0,-90.000000,0> translate<36.830000,-1.535000,43.180000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<35.560000,-1.535000,49.530000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<36.830000,-1.535000,48.260000>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,44.997030,0> translate<35.560000,-1.535000,49.530000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.290000,-1.535000,52.070000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<36.830000,-1.535000,52.070000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,0.000000,0> translate<34.290000,-1.535000,52.070000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<35.560000,-1.535000,15.240000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<38.100000,-1.535000,15.240000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,0.000000,0> translate<35.560000,-1.535000,15.240000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<38.100000,-1.535000,11.430000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<38.100000,-1.535000,15.240000>}
box{<0,0,-0.203200><3.810000,0.035000,0.203200> rotate<0,90.000000,0> translate<38.100000,-1.535000,15.240000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<35.560000,-1.535000,20.320000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<38.100000,-1.535000,20.320000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,0.000000,0> translate<35.560000,-1.535000,20.320000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<35.560000,-1.535000,25.400000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<38.100000,-1.535000,25.400000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,0.000000,0> translate<35.560000,-1.535000,25.400000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<38.100000,-1.535000,20.320000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<38.100000,-1.535000,25.400000>}
box{<0,0,-0.203200><5.080000,0.035000,0.203200> rotate<0,90.000000,0> translate<38.100000,-1.535000,25.400000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<38.100000,-1.535000,11.430000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<39.370000,-1.535000,10.160000>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,44.997030,0> translate<38.100000,-1.535000,11.430000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<38.100000,-1.535000,15.240000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<39.370000,-1.535000,16.510000>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,-44.997030,0> translate<38.100000,-1.535000,15.240000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<38.100000,-1.535000,20.320000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<39.370000,-1.535000,19.050000>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,44.997030,0> translate<38.100000,-1.535000,20.320000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<39.370000,-1.535000,16.510000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<39.370000,-1.535000,19.050000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,90.000000,0> translate<39.370000,-1.535000,19.050000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<36.830000,-1.535000,43.180000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<39.370000,-1.535000,40.640000>}
box{<0,0,-0.203200><3.592102,0.035000,0.203200> rotate<0,44.997030,0> translate<36.830000,-1.535000,43.180000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<36.830000,-1.535000,57.150000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<39.370000,-1.535000,54.610000>}
box{<0,0,-0.203200><3.592102,0.035000,0.203200> rotate<0,44.997030,0> translate<36.830000,-1.535000,57.150000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<39.370000,-1.535000,45.720000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<39.370000,-1.535000,54.610000>}
box{<0,0,-0.203200><8.890000,0.035000,0.203200> rotate<0,90.000000,0> translate<39.370000,-1.535000,54.610000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<3.810000,-1.535000,31.750000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<40.640000,-1.535000,31.750000>}
box{<0,0,-0.203200><36.830000,0.035000,0.203200> rotate<0,0.000000,0> translate<3.810000,-1.535000,31.750000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<40.640000,-1.535000,31.750000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<41.910000,-1.535000,33.020000>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,-44.997030,0> translate<40.640000,-1.535000,31.750000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<36.830000,-1.535000,34.290000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<41.910000,-1.535000,39.370000>}
box{<0,0,-0.203200><7.184205,0.035000,0.203200> rotate<0,-44.997030,0> translate<36.830000,-1.535000,34.290000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<41.910000,-1.535000,39.370000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<41.910000,-1.535000,45.720000>}
box{<0,0,-0.203200><6.350000,0.035000,0.203200> rotate<0,90.000000,0> translate<41.910000,-1.535000,45.720000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<43.180000,-1.535000,12.700000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<43.180000,-1.535000,15.240000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,90.000000,0> translate<43.180000,-1.535000,15.240000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<43.180000,-1.535000,17.780000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<43.180000,-1.535000,20.320000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,90.000000,0> translate<43.180000,-1.535000,20.320000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<43.180000,-1.535000,20.320000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<43.180000,-1.535000,26.670000>}
box{<0,0,-0.203200><6.350000,0.035000,0.203200> rotate<0,90.000000,0> translate<43.180000,-1.535000,26.670000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<43.180000,-1.535000,40.640000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<43.180000,-1.535000,44.450000>}
box{<0,0,-0.203200><3.810000,0.035000,0.203200> rotate<0,90.000000,0> translate<43.180000,-1.535000,44.450000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<41.910000,-1.535000,45.720000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<43.180000,-1.535000,46.990000>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,-44.997030,0> translate<41.910000,-1.535000,45.720000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<36.830000,-1.535000,5.080000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<44.450000,-1.535000,5.080000>}
box{<0,0,-0.203200><7.620000,0.035000,0.203200> rotate<0,0.000000,0> translate<36.830000,-1.535000,5.080000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<39.370000,-1.535000,10.160000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<44.450000,-1.535000,10.160000>}
box{<0,0,-0.203200><5.080000,0.035000,0.203200> rotate<0,0.000000,0> translate<39.370000,-1.535000,10.160000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<43.180000,-1.535000,26.670000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<44.450000,-1.535000,27.940000>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,-44.997030,0> translate<43.180000,-1.535000,26.670000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<36.830000,-1.535000,29.210000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<44.450000,-1.535000,29.210000>}
box{<0,0,-0.203200><7.620000,0.035000,0.203200> rotate<0,0.000000,0> translate<36.830000,-1.535000,29.210000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<44.450000,-1.535000,30.480000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<44.450000,-1.535000,29.210000>}
box{<0,0,-0.203200><1.270000,0.035000,0.203200> rotate<0,-90.000000,0> translate<44.450000,-1.535000,29.210000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<44.450000,-1.535000,33.020000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<44.450000,-1.535000,30.480000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,-90.000000,0> translate<44.450000,-1.535000,30.480000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<41.910000,-1.535000,33.020000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<44.450000,-1.535000,33.020000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,0.000000,0> translate<41.910000,-1.535000,33.020000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<43.180000,-1.535000,40.640000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<44.450000,-1.535000,39.370000>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,44.997030,0> translate<43.180000,-1.535000,40.640000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<44.450000,-1.535000,33.020000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<44.450000,-1.535000,39.370000>}
box{<0,0,-0.203200><6.350000,0.035000,0.203200> rotate<0,90.000000,0> translate<44.450000,-1.535000,39.370000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<43.180000,-1.535000,12.700000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<45.720000,-1.535000,12.700000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,0.000000,0> translate<43.180000,-1.535000,12.700000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<43.180000,-1.535000,15.240000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<45.720000,-1.535000,15.240000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,0.000000,0> translate<43.180000,-1.535000,15.240000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<43.180000,-1.535000,17.780000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<45.720000,-1.535000,17.780000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,0.000000,0> translate<43.180000,-1.535000,17.780000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<43.180000,-1.535000,20.320000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<45.720000,-1.535000,20.320000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,0.000000,0> translate<43.180000,-1.535000,20.320000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<45.720000,-1.535000,22.860000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<45.720000,-1.535000,25.400000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,90.000000,0> translate<45.720000,-1.535000,25.400000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<44.450000,-1.535000,7.620000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<46.990000,-1.535000,7.620000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,0.000000,0> translate<44.450000,-1.535000,7.620000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<46.990000,-1.535000,1.568400>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<46.990000,-1.535000,7.620000>}
box{<0,0,-0.203200><6.051600,0.035000,0.203200> rotate<0,90.000000,0> translate<46.990000,-1.535000,7.620000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<43.180000,-1.535000,44.450000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<46.990000,-1.535000,44.450000>}
box{<0,0,-0.203200><3.810000,0.035000,0.203200> rotate<0,0.000000,0> translate<43.180000,-1.535000,44.450000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<43.180000,-1.535000,46.990000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<46.990000,-1.535000,46.990000>}
box{<0,0,-0.203200><3.810000,0.035000,0.203200> rotate<0,0.000000,0> translate<43.180000,-1.535000,46.990000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<46.990000,-1.535000,1.568400>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<48.260000,-1.535000,0.298400>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,44.997030,0> translate<46.990000,-1.535000,1.568400> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<44.450000,-1.535000,27.940000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<48.260000,-1.535000,27.940000>}
box{<0,0,-0.203200><3.810000,0.035000,0.203200> rotate<0,0.000000,0> translate<44.450000,-1.535000,27.940000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<45.720000,0.000000,22.860000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.530000,0.000000,22.860000>}
box{<0,0,-0.203200><3.810000,0.035000,0.203200> rotate<0,0.000000,0> translate<45.720000,0.000000,22.860000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.530000,0.000000,17.780000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.530000,0.000000,22.860000>}
box{<0,0,-0.203200><5.080000,0.035000,0.203200> rotate<0,90.000000,0> translate<49.530000,0.000000,22.860000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.530000,-1.535000,33.020000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.530000,-1.535000,38.100000>}
box{<0,0,-0.203200><5.080000,0.035000,0.203200> rotate<0,90.000000,0> translate<49.530000,-1.535000,38.100000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.530000,-1.535000,38.100000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.631600,-1.535000,38.201600>}
box{<0,0,-0.203200><0.143684,0.035000,0.203200> rotate<0,-44.997030,0> translate<49.530000,-1.535000,38.100000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<46.990000,-1.535000,41.910000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.631600,-1.535000,41.910000>}
box{<0,0,-0.203200><2.641600,0.035000,0.203200> rotate<0,0.000000,0> translate<46.990000,-1.535000,41.910000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.631600,-1.535000,38.201600>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.631600,-1.535000,41.910000>}
box{<0,0,-0.203200><3.708400,0.035000,0.203200> rotate<0,90.000000,0> translate<49.631600,-1.535000,41.910000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<45.720000,-1.535000,15.240000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<50.800000,-1.535000,15.240000>}
box{<0,0,-0.203200><5.080000,0.035000,0.203200> rotate<0,0.000000,0> translate<45.720000,-1.535000,15.240000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<44.450000,-1.535000,30.480000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<51.435000,-1.535000,30.480000>}
box{<0,0,-0.203200><6.985000,0.035000,0.203200> rotate<0,0.000000,0> translate<44.450000,-1.535000,30.480000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<50.800000,-1.535000,15.240000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<52.070000,-1.535000,16.510000>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,-44.997030,0> translate<50.800000,-1.535000,15.240000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<52.070000,-1.535000,16.510000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<52.070000,-1.535000,20.320000>}
box{<0,0,-0.203200><3.810000,0.035000,0.203200> rotate<0,90.000000,0> translate<52.070000,-1.535000,20.320000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<51.435000,-1.535000,30.480000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<52.070000,-1.535000,31.115000>}
box{<0,0,-0.203200><0.898026,0.035000,0.203200> rotate<0,-44.997030,0> translate<51.435000,-1.535000,30.480000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<46.990000,-1.535000,44.450000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<52.070000,-1.535000,44.450000>}
box{<0,0,-0.203200><5.080000,0.035000,0.203200> rotate<0,0.000000,0> translate<46.990000,-1.535000,44.450000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<48.260000,-1.535000,27.940000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<53.340000,-1.535000,22.860000>}
box{<0,0,-0.203200><7.184205,0.035000,0.203200> rotate<0,44.997030,0> translate<48.260000,-1.535000,27.940000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<52.070000,-1.535000,44.450000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<53.340000,-1.535000,45.720000>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,-44.997030,0> translate<52.070000,-1.535000,44.450000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<39.370000,-1.535000,54.610000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<53.340000,-1.535000,54.610000>}
box{<0,0,-0.203200><13.970000,0.035000,0.203200> rotate<0,0.000000,0> translate<39.370000,-1.535000,54.610000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.530000,-1.535000,5.080000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<54.610000,-1.535000,5.080000>}
box{<0,0,-0.203200><5.080000,0.035000,0.203200> rotate<0,0.000000,0> translate<49.530000,-1.535000,5.080000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.530000,-1.535000,10.160000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<54.610000,-1.535000,10.160000>}
box{<0,0,-0.203200><5.080000,0.035000,0.203200> rotate<0,0.000000,0> translate<49.530000,-1.535000,10.160000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<52.070000,-1.535000,20.320000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<54.610000,-1.535000,20.320000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,0.000000,0> translate<52.070000,-1.535000,20.320000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<52.070000,-1.535000,27.940000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<54.610000,-1.535000,27.940000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,0.000000,0> translate<52.070000,-1.535000,27.940000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<54.610000,-1.535000,38.100000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<54.610000,-1.535000,33.020000>}
box{<0,0,-0.203200><5.080000,0.035000,0.203200> rotate<0,-90.000000,0> translate<54.610000,-1.535000,33.020000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.530000,-1.535000,7.620000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<55.880000,-1.535000,7.620000>}
box{<0,0,-0.203200><6.350000,0.035000,0.203200> rotate<0,0.000000,0> translate<49.530000,-1.535000,7.620000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<52.070000,-1.535000,31.115000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<55.880000,-1.535000,31.115000>}
box{<0,0,-0.203200><3.810000,0.035000,0.203200> rotate<0,0.000000,0> translate<52.070000,-1.535000,31.115000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<53.340000,-1.535000,45.720000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<55.880000,-1.535000,45.720000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,0.000000,0> translate<53.340000,-1.535000,45.720000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<55.880000,-1.535000,7.620000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<57.150000,-1.535000,8.890000>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,-44.997030,0> translate<55.880000,-1.535000,7.620000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<57.150000,-1.535000,8.890000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<57.150000,-1.535000,15.240000>}
box{<0,0,-0.203200><6.350000,0.035000,0.203200> rotate<0,90.000000,0> translate<57.150000,-1.535000,15.240000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<49.530000,0.000000,17.780000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<57.150000,0.000000,17.780000>}
box{<0,0,-0.203200><7.620000,0.035000,0.203200> rotate<0,0.000000,0> translate<49.530000,0.000000,17.780000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<57.150000,0.000000,17.780000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<57.150000,0.000000,20.320000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,90.000000,0> translate<57.150000,0.000000,20.320000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<53.340000,-1.535000,22.860000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<57.150000,-1.535000,22.860000>}
box{<0,0,-0.203200><3.810000,0.035000,0.203200> rotate<0,0.000000,0> translate<53.340000,-1.535000,22.860000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<57.150000,-1.535000,33.020000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<57.150000,-1.535000,36.830000>}
box{<0,0,-0.203200><3.810000,0.035000,0.203200> rotate<0,90.000000,0> translate<57.150000,-1.535000,36.830000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<54.610000,-1.535000,27.940000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<59.690000,-1.535000,27.940000>}
box{<0,0,-0.203200><5.080000,0.035000,0.203200> rotate<0,0.000000,0> translate<54.610000,-1.535000,27.940000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<55.880000,-1.535000,31.115000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<59.690000,-1.535000,31.115000>}
box{<0,0,-0.203200><3.810000,0.035000,0.203200> rotate<0,0.000000,0> translate<55.880000,-1.535000,31.115000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<59.690000,-1.535000,31.115000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<60.960000,-1.535000,32.385000>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,-44.997030,0> translate<59.690000,-1.535000,31.115000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<60.960000,-1.535000,32.385000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<60.960000,-1.535000,35.560000>}
box{<0,0,-0.203200><3.175000,0.035000,0.203200> rotate<0,90.000000,0> translate<60.960000,-1.535000,35.560000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<54.610000,-1.535000,38.100000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<60.960000,-1.535000,44.450000>}
box{<0,0,-0.203200><8.980256,0.035000,0.203200> rotate<0,-44.997030,0> translate<54.610000,-1.535000,38.100000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<60.960000,-1.535000,48.260000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<60.960000,-1.535000,46.990000>}
box{<0,0,-0.203200><1.270000,0.035000,0.203200> rotate<0,-90.000000,0> translate<60.960000,-1.535000,46.990000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<62.230000,-1.535000,2.540000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<62.230000,-1.535000,12.700000>}
box{<0,0,-0.203200><10.160000,0.035000,0.203200> rotate<0,90.000000,0> translate<62.230000,-1.535000,12.700000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<62.230000,-1.535000,27.940000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<62.230000,-1.535000,33.020000>}
box{<0,0,-0.203200><5.080000,0.035000,0.203200> rotate<0,90.000000,0> translate<62.230000,-1.535000,33.020000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<60.960000,-1.535000,35.560000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<62.230000,-1.535000,36.830000>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,-44.997030,0> translate<60.960000,-1.535000,35.560000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<57.150000,-1.535000,36.830000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<62.230000,-1.535000,41.910000>}
box{<0,0,-0.203200><7.184205,0.035000,0.203200> rotate<0,-44.997030,0> translate<57.150000,-1.535000,36.830000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<60.960000,-1.535000,48.260000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<62.230000,-1.535000,49.530000>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,-44.997030,0> translate<60.960000,-1.535000,48.260000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<62.230000,-1.535000,52.070000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<62.230000,-1.535000,49.530000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,-90.000000,0> translate<62.230000,-1.535000,49.530000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<53.340000,-1.535000,52.070000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<62.230000,-1.535000,52.070000>}
box{<0,0,-0.203200><8.890000,0.035000,0.203200> rotate<0,0.000000,0> translate<53.340000,-1.535000,52.070000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<55.880000,-1.535000,45.720000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<62.230000,-1.535000,52.070000>}
box{<0,0,-0.203200><8.980256,0.035000,0.203200> rotate<0,-44.997030,0> translate<55.880000,-1.535000,45.720000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<53.340000,-1.535000,57.150000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<62.230000,-1.535000,57.150000>}
box{<0,0,-0.203200><8.890000,0.035000,0.203200> rotate<0,0.000000,0> translate<53.340000,-1.535000,57.150000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<62.230000,-1.535000,2.540000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<63.500000,-1.535000,1.270000>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,44.997030,0> translate<62.230000,-1.535000,2.540000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<60.960000,-1.535000,46.990000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<63.500000,-1.535000,46.990000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,0.000000,0> translate<60.960000,-1.535000,46.990000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<64.770000,-1.535000,7.620000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<64.770000,-1.535000,10.160000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,90.000000,0> translate<64.770000,-1.535000,10.160000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<62.230000,-1.535000,12.700000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<64.770000,-1.535000,12.700000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,0.000000,0> translate<62.230000,-1.535000,12.700000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<64.770000,-1.535000,22.860000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<64.770000,-1.535000,31.750000>}
box{<0,0,-0.203200><8.890000,0.035000,0.203200> rotate<0,90.000000,0> translate<64.770000,-1.535000,31.750000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<64.770000,-1.535000,7.620000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<66.040000,-1.535000,7.620000>}
box{<0,0,-0.203200><1.270000,0.035000,0.203200> rotate<0,0.000000,0> translate<64.770000,-1.535000,7.620000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<64.770000,-1.535000,31.750000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<66.040000,-1.535000,33.020000>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,-44.997030,0> translate<64.770000,-1.535000,31.750000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<64.770000,-1.535000,20.320000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<66.395600,-1.535000,20.320000>}
box{<0,0,-0.203200><1.625600,0.035000,0.203200> rotate<0,0.000000,0> translate<64.770000,-1.535000,20.320000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<66.395600,-1.535000,20.320000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<67.310000,-1.535000,21.234400>}
box{<0,0,-0.203200><1.293157,0.035000,0.203200> rotate<0,-44.997030,0> translate<66.395600,-1.535000,20.320000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<67.310000,-1.535000,21.234400>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<67.310000,-1.535000,21.590000>}
box{<0,0,-0.203200><0.355600,0.035000,0.203200> rotate<0,90.000000,0> translate<67.310000,-1.535000,21.590000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<67.310000,-1.535000,29.210000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<67.310000,-1.535000,29.565600>}
box{<0,0,-0.203200><0.355600,0.035000,0.203200> rotate<0,90.000000,0> translate<67.310000,-1.535000,29.565600> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<62.230000,-1.535000,33.020000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<67.310000,-1.535000,38.100000>}
box{<0,0,-0.203200><7.184205,0.035000,0.203200> rotate<0,-44.997030,0> translate<62.230000,-1.535000,33.020000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<62.230000,-1.535000,41.910000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<67.310000,-1.535000,41.910000>}
box{<0,0,-0.203200><5.080000,0.035000,0.203200> rotate<0,0.000000,0> translate<62.230000,-1.535000,41.910000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<60.960000,-1.535000,44.450000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<67.310000,-1.535000,44.450000>}
box{<0,0,-0.203200><6.350000,0.035000,0.203200> rotate<0,0.000000,0> translate<60.960000,-1.535000,44.450000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<62.230000,-1.535000,52.070000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<67.310000,-1.535000,52.070000>}
box{<0,0,-0.203200><5.080000,0.035000,0.203200> rotate<0,0.000000,0> translate<62.230000,-1.535000,52.070000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<67.310000,-1.535000,29.565600>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<68.224400,-1.535000,30.480000>}
box{<0,0,-0.203200><1.293157,0.035000,0.203200> rotate<0,-44.997030,0> translate<67.310000,-1.535000,29.565600> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<64.770000,-1.535000,5.080000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<68.580000,-1.535000,5.080000>}
box{<0,0,-0.203200><3.810000,0.035000,0.203200> rotate<0,0.000000,0> translate<64.770000,-1.535000,5.080000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<66.040000,-1.535000,7.620000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<68.580000,-1.535000,5.080000>}
box{<0,0,-0.203200><3.592102,0.035000,0.203200> rotate<0,44.997030,0> translate<66.040000,-1.535000,7.620000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<68.580000,-1.535000,5.080000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<68.580000,-1.535000,10.160000>}
box{<0,0,-0.203200><5.080000,0.035000,0.203200> rotate<0,90.000000,0> translate<68.580000,-1.535000,10.160000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<64.770000,-1.535000,17.780000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<68.580000,-1.535000,17.780000>}
box{<0,0,-0.203200><3.810000,0.035000,0.203200> rotate<0,0.000000,0> translate<64.770000,-1.535000,17.780000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<68.580000,0.000000,17.780000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<68.580000,0.000000,21.590000>}
box{<0,0,-0.203200><3.810000,0.035000,0.203200> rotate<0,90.000000,0> translate<68.580000,0.000000,21.590000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<67.310000,-1.535000,41.910000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<68.580000,-1.535000,43.180000>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,-44.997030,0> translate<67.310000,-1.535000,41.910000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<67.310000,-1.535000,44.450000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<68.935600,-1.535000,46.075600>}
box{<0,0,-0.203200><2.298946,0.035000,0.203200> rotate<0,-44.997030,0> translate<67.310000,-1.535000,44.450000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<68.580000,0.000000,21.590000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<69.850000,0.000000,22.860000>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,-44.997030,0> translate<68.580000,0.000000,21.590000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<68.580000,-1.535000,43.180000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<69.850000,-1.535000,43.180000>}
box{<0,0,-0.203200><1.270000,0.035000,0.203200> rotate<0,0.000000,0> translate<68.580000,-1.535000,43.180000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<69.850000,-1.535000,43.180000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<69.850000,-1.535000,44.450000>}
box{<0,0,-0.203200><1.270000,0.035000,0.203200> rotate<0,90.000000,0> translate<69.850000,-1.535000,44.450000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<67.310000,-1.535000,52.070000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<69.850000,-1.535000,54.610000>}
box{<0,0,-0.203200><3.592102,0.035000,0.203200> rotate<0,-44.997030,0> translate<67.310000,-1.535000,52.070000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<64.770000,-1.535000,48.895000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<70.485000,-1.535000,48.895000>}
box{<0,0,-0.203200><5.715000,0.035000,0.203200> rotate<0,0.000000,0> translate<64.770000,-1.535000,48.895000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<69.850000,-1.535000,43.180000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<70.764400,-1.535000,42.265600>}
box{<0,0,-0.203200><1.293157,0.035000,0.203200> rotate<0,44.997030,0> translate<69.850000,-1.535000,43.180000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<71.120000,-1.535000,6.350000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<71.120000,-1.535000,10.160000>}
box{<0,0,-0.203200><3.810000,0.035000,0.203200> rotate<0,90.000000,0> translate<71.120000,-1.535000,10.160000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<71.120000,-1.535000,17.780000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<71.120000,-1.535000,21.590000>}
box{<0,0,-0.203200><3.810000,0.035000,0.203200> rotate<0,90.000000,0> translate<71.120000,-1.535000,21.590000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<68.224400,-1.535000,30.480000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<71.120000,-1.535000,30.480000>}
box{<0,0,-0.203200><2.895600,0.035000,0.203200> rotate<0,0.000000,0> translate<68.224400,-1.535000,30.480000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<66.040000,-1.535000,33.020000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<71.120000,-1.535000,33.020000>}
box{<0,0,-0.203200><5.080000,0.035000,0.203200> rotate<0,0.000000,0> translate<66.040000,-1.535000,33.020000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<67.310000,-1.535000,38.100000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<71.120000,-1.535000,38.100000>}
box{<0,0,-0.203200><3.810000,0.035000,0.203200> rotate<0,0.000000,0> translate<67.310000,-1.535000,38.100000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<62.230000,-1.535000,57.150000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<71.120000,-1.535000,57.150000>}
box{<0,0,-0.203200><8.890000,0.035000,0.203200> rotate<0,0.000000,0> translate<62.230000,-1.535000,57.150000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<71.120000,-1.535000,6.350000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<72.390000,-1.535000,5.080000>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,44.997030,0> translate<71.120000,-1.535000,6.350000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<69.850000,-1.535000,44.450000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<72.390000,-1.535000,44.450000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,0.000000,0> translate<69.850000,-1.535000,44.450000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<66.040000,-1.535000,46.990000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<72.390000,-1.535000,46.990000>}
box{<0,0,-0.203200><6.350000,0.035000,0.203200> rotate<0,0.000000,0> translate<66.040000,-1.535000,46.990000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<70.485000,-1.535000,48.895000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<72.390000,-1.535000,50.800000>}
box{<0,0,-0.203200><2.694077,0.035000,0.203200> rotate<0,-44.997030,0> translate<70.485000,-1.535000,48.895000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<72.390000,-1.535000,55.880000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<72.390000,-1.535000,50.800000>}
box{<0,0,-0.203200><5.080000,0.035000,0.203200> rotate<0,-90.000000,0> translate<72.390000,-1.535000,50.800000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<71.120000,-1.535000,57.150000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<72.390000,-1.535000,55.880000>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,44.997030,0> translate<71.120000,-1.535000,57.150000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<73.660000,-1.535000,7.620000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<73.660000,-1.535000,10.160000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,90.000000,0> translate<73.660000,-1.535000,10.160000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<62.230000,-1.535000,15.240000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<73.660000,-1.535000,15.240000>}
box{<0,0,-0.203200><11.430000,0.035000,0.203200> rotate<0,0.000000,0> translate<62.230000,-1.535000,15.240000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<73.660000,-1.535000,15.240000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<73.660000,-1.535000,17.780000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,90.000000,0> translate<73.660000,-1.535000,17.780000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<71.120000,-1.535000,25.400000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<73.660000,-1.535000,25.400000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,0.000000,0> translate<71.120000,-1.535000,25.400000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<73.660000,-1.535000,42.265600>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<73.660000,-1.535000,25.400000>}
box{<0,0,-0.203200><16.865600,0.035000,0.203200> rotate<0,-90.000000,0> translate<73.660000,-1.535000,25.400000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<70.764400,-1.535000,42.265600>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<73.660000,-1.535000,42.265600>}
box{<0,0,-0.203200><2.895600,0.035000,0.203200> rotate<0,0.000000,0> translate<70.764400,-1.535000,42.265600> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<72.390000,-1.535000,55.880000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<73.660000,-1.535000,57.150000>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,-44.997030,0> translate<72.390000,-1.535000,55.880000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<69.850000,0.000000,22.860000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<74.930000,0.000000,22.860000>}
box{<0,0,-0.203200><5.080000,0.035000,0.203200> rotate<0,0.000000,0> translate<69.850000,0.000000,22.860000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<74.930000,-1.535000,22.860000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<74.930000,-1.535000,41.275000>}
box{<0,0,-0.203200><18.415000,0.035000,0.203200> rotate<0,90.000000,0> translate<74.930000,-1.535000,41.275000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<74.930000,-1.535000,52.070000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<74.930000,-1.535000,54.610000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,90.000000,0> translate<74.930000,-1.535000,54.610000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<76.200000,-1.535000,5.080000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<76.200000,-1.535000,2.540000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,-90.000000,0> translate<76.200000,-1.535000,2.540000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<72.390000,-1.535000,5.080000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<76.200000,-1.535000,5.080000>}
box{<0,0,-0.203200><3.810000,0.035000,0.203200> rotate<0,0.000000,0> translate<72.390000,-1.535000,5.080000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<73.660000,-1.535000,7.620000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<76.200000,-1.535000,7.620000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,0.000000,0> translate<73.660000,-1.535000,7.620000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<76.200000,-1.535000,12.700000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<76.200000,-1.535000,10.160000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,-90.000000,0> translate<76.200000,-1.535000,10.160000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<64.770000,-1.535000,12.700000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<76.200000,-1.535000,12.700000>}
box{<0,0,-0.203200><11.430000,0.035000,0.203200> rotate<0,0.000000,0> translate<64.770000,-1.535000,12.700000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<73.660000,-1.535000,15.240000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<76.200000,-1.535000,15.240000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,0.000000,0> translate<73.660000,-1.535000,15.240000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<74.930000,-1.535000,22.860000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<76.200000,-1.535000,21.590000>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,44.997030,0> translate<74.930000,-1.535000,22.860000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<76.200000,-1.535000,17.780000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<76.200000,-1.535000,21.590000>}
box{<0,0,-0.203200><3.810000,0.035000,0.203200> rotate<0,90.000000,0> translate<76.200000,-1.535000,21.590000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<76.200000,-1.535000,27.940000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<76.200000,-1.535000,40.640000>}
box{<0,0,-0.203200><12.700000,0.035000,0.203200> rotate<0,90.000000,0> translate<76.200000,-1.535000,40.640000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<74.930000,-1.535000,41.275000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<76.200000,-1.535000,42.545000>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,-44.997030,0> translate<74.930000,-1.535000,41.275000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<68.935600,-1.535000,46.075600>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<76.200000,-1.535000,46.075600>}
box{<0,0,-0.203200><7.264400,0.035000,0.203200> rotate<0,0.000000,0> translate<68.935600,-1.535000,46.075600> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<72.390000,-1.535000,46.990000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<76.200000,-1.535000,50.800000>}
box{<0,0,-0.203200><5.388154,0.035000,0.203200> rotate<0,-44.997030,0> translate<72.390000,-1.535000,46.990000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<74.930000,-1.535000,52.070000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<76.200000,-1.535000,50.800000>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,44.997030,0> translate<74.930000,-1.535000,52.070000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<76.200000,-1.535000,7.620000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<78.740000,-1.535000,5.080000>}
box{<0,0,-0.203200><3.592102,0.035000,0.203200> rotate<0,44.997030,0> translate<76.200000,-1.535000,7.620000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<76.200000,-1.535000,15.240000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<78.740000,-1.535000,12.700000>}
box{<0,0,-0.203200><3.592102,0.035000,0.203200> rotate<0,44.997030,0> translate<76.200000,-1.535000,15.240000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<76.200000,-1.535000,17.780000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<78.740000,-1.535000,17.780000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,0.000000,0> translate<76.200000,-1.535000,17.780000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<78.740000,-1.535000,16.510000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<78.740000,-1.535000,17.780000>}
box{<0,0,-0.203200><1.270000,0.035000,0.203200> rotate<0,90.000000,0> translate<78.740000,-1.535000,17.780000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<74.930000,0.000000,22.860000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<78.740000,0.000000,19.050000>}
box{<0,0,-0.203200><5.388154,0.035000,0.203200> rotate<0,44.997030,0> translate<74.930000,0.000000,22.860000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<78.740000,-1.535000,21.590000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<78.740000,-1.535000,25.400000>}
box{<0,0,-0.203200><3.810000,0.035000,0.203200> rotate<0,90.000000,0> translate<78.740000,-1.535000,25.400000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<76.200000,-1.535000,27.940000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<78.740000,-1.535000,27.940000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,0.000000,0> translate<76.200000,-1.535000,27.940000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<76.200000,-1.535000,40.640000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<78.740000,-1.535000,40.640000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,0.000000,0> translate<76.200000,-1.535000,40.640000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<76.200000,-1.535000,46.075600>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<79.019400,-1.535000,48.895000>}
box{<0,0,-0.203200><3.987234,0.035000,0.203200> rotate<0,-44.997030,0> translate<76.200000,-1.535000,46.075600> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<77.470000,-1.535000,44.450000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<79.095600,-1.535000,44.450000>}
box{<0,0,-0.203200><1.625600,0.035000,0.203200> rotate<0,0.000000,0> translate<77.470000,-1.535000,44.450000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<76.200000,-1.535000,2.540000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<79.375000,-1.535000,2.540000>}
box{<0,0,-0.203200><3.175000,0.035000,0.203200> rotate<0,0.000000,0> translate<76.200000,-1.535000,2.540000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<78.740000,0.000000,40.640000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<80.010000,0.000000,40.640000>}
box{<0,0,-0.203200><1.270000,0.035000,0.203200> rotate<0,0.000000,0> translate<78.740000,0.000000,40.640000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<79.095600,-1.535000,44.450000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<80.010000,-1.535000,45.364400>}
box{<0,0,-0.203200><1.293157,0.035000,0.203200> rotate<0,-44.997030,0> translate<79.095600,-1.535000,44.450000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<80.010000,-1.535000,45.720000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<80.010000,-1.535000,45.364400>}
box{<0,0,-0.203200><0.355600,0.035000,0.203200> rotate<0,-90.000000,0> translate<80.010000,-1.535000,45.364400> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<80.010000,0.000000,40.640000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<80.010000,0.000000,45.720000>}
box{<0,0,-0.203200><5.080000,0.035000,0.203200> rotate<0,90.000000,0> translate<80.010000,0.000000,45.720000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<76.200000,-1.535000,50.800000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<80.010000,-1.535000,50.800000>}
box{<0,0,-0.203200><3.810000,0.035000,0.203200> rotate<0,0.000000,0> translate<76.200000,-1.535000,50.800000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<79.375000,-1.535000,2.540000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<80.645000,-1.535000,3.810000>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,-44.997030,0> translate<79.375000,-1.535000,2.540000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<80.797400,-1.535000,10.160000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<80.797400,-1.535000,13.487400>}
box{<0,0,-0.203200><3.327400,0.035000,0.203200> rotate<0,90.000000,0> translate<80.797400,-1.535000,13.487400> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<78.740000,-1.535000,5.080000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<81.280000,-1.535000,7.620000>}
box{<0,0,-0.203200><3.592102,0.035000,0.203200> rotate<0,-44.997030,0> translate<78.740000,-1.535000,5.080000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<78.740000,-1.535000,16.510000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<81.280000,-1.535000,13.970000>}
box{<0,0,-0.203200><3.592102,0.035000,0.203200> rotate<0,44.997030,0> translate<78.740000,-1.535000,16.510000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<80.797400,-1.535000,13.487400>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<81.280000,-1.535000,13.970000>}
box{<0,0,-0.203200><0.682499,0.035000,0.203200> rotate<0,-44.997030,0> translate<80.797400,-1.535000,13.487400> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<78.740000,0.000000,19.050000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<81.280000,0.000000,21.590000>}
box{<0,0,-0.203200><3.592102,0.035000,0.203200> rotate<0,-44.997030,0> translate<78.740000,0.000000,19.050000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<78.740000,-1.535000,21.590000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<81.280000,-1.535000,21.590000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,0.000000,0> translate<78.740000,-1.535000,21.590000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<81.280000,-1.535000,17.780000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<81.280000,-1.535000,21.590000>}
box{<0,0,-0.203200><3.810000,0.035000,0.203200> rotate<0,90.000000,0> translate<81.280000,-1.535000,21.590000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<81.280000,-1.535000,42.545000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<81.280000,-1.535000,39.370000>}
box{<0,0,-0.203200><3.175000,0.035000,0.203200> rotate<0,-90.000000,0> translate<81.280000,-1.535000,39.370000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<76.200000,-1.535000,42.545000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<81.280000,-1.535000,42.545000>}
box{<0,0,-0.203200><5.080000,0.035000,0.203200> rotate<0,0.000000,0> translate<76.200000,-1.535000,42.545000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<80.797400,-1.535000,10.160000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<82.067400,-1.535000,8.890000>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,44.997030,0> translate<80.797400,-1.535000,10.160000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<80.645000,-1.535000,3.810000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<82.550000,-1.535000,3.810000>}
box{<0,0,-0.203200><1.905000,0.035000,0.203200> rotate<0,0.000000,0> translate<80.645000,-1.535000,3.810000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<81.280000,0.000000,21.590000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<82.550000,0.000000,21.590000>}
box{<0,0,-0.203200><1.270000,0.035000,0.203200> rotate<0,0.000000,0> translate<81.280000,0.000000,21.590000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<82.550000,0.000000,26.670000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<82.550000,0.000000,29.210000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,90.000000,0> translate<82.550000,0.000000,29.210000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<82.550000,-1.535000,29.210000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<82.550000,-1.535000,33.020000>}
box{<0,0,-0.203200><3.810000,0.035000,0.203200> rotate<0,90.000000,0> translate<82.550000,-1.535000,33.020000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<81.280000,-1.535000,39.370000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<82.804000,-1.535000,39.370000>}
box{<0,0,-0.203200><1.524000,0.035000,0.203200> rotate<0,0.000000,0> translate<81.280000,-1.535000,39.370000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<82.804000,-1.535000,39.370000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<82.804000,-1.535000,41.910000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,90.000000,0> translate<82.804000,-1.535000,41.910000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<82.550000,-1.535000,45.720000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<82.804000,-1.535000,45.466000>}
box{<0,0,-0.203200><0.359210,0.035000,0.203200> rotate<0,44.997030,0> translate<82.550000,-1.535000,45.720000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<82.804000,-1.535000,41.910000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<82.804000,-1.535000,45.466000>}
box{<0,0,-0.203200><3.556000,0.035000,0.203200> rotate<0,90.000000,0> translate<82.804000,-1.535000,45.466000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<82.550000,-1.535000,45.720000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<82.905600,-1.535000,45.720000>}
box{<0,0,-0.203200><0.355600,0.035000,0.203200> rotate<0,0.000000,0> translate<82.550000,-1.535000,45.720000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<82.067400,-1.535000,8.890000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<83.820000,-1.535000,8.890000>}
box{<0,0,-0.203200><1.752600,0.035000,0.203200> rotate<0,0.000000,0> translate<82.067400,-1.535000,8.890000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<82.905600,-1.535000,45.720000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<83.820000,-1.535000,46.634400>}
box{<0,0,-0.203200><1.293157,0.035000,0.203200> rotate<0,-44.997030,0> translate<82.905600,-1.535000,45.720000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<83.820000,-1.535000,46.634400>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<83.820000,-1.535000,47.701200>}
box{<0,0,-0.203200><1.066800,0.035000,0.203200> rotate<0,90.000000,0> translate<83.820000,-1.535000,47.701200> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<83.820000,-1.535000,47.701200>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<84.175600,-1.535000,47.701200>}
box{<0,0,-0.203200><0.355600,0.035000,0.203200> rotate<0,0.000000,0> translate<83.820000,-1.535000,47.701200> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<82.550000,-1.535000,11.430000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<84.455000,-1.535000,13.335000>}
box{<0,0,-0.203200><2.694077,0.035000,0.203200> rotate<0,-44.997030,0> translate<82.550000,-1.535000,11.430000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<81.280000,-1.535000,17.780000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<84.455000,-1.535000,17.780000>}
box{<0,0,-0.203200><3.175000,0.035000,0.203200> rotate<0,0.000000,0> translate<81.280000,-1.535000,17.780000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<84.455000,-1.535000,13.335000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<84.455000,-1.535000,17.780000>}
box{<0,0,-0.203200><4.445000,0.035000,0.203200> rotate<0,90.000000,0> translate<84.455000,-1.535000,17.780000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<84.175600,-1.535000,47.701200>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<84.886800,-1.535000,46.990000>}
box{<0,0,-0.203200><1.005789,0.035000,0.203200> rotate<0,44.997030,0> translate<84.175600,-1.535000,47.701200> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<82.550000,0.000000,21.590000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<85.090000,0.000000,24.130000>}
box{<0,0,-0.203200><3.592102,0.035000,0.203200> rotate<0,-44.997030,0> translate<82.550000,0.000000,21.590000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<82.550000,0.000000,26.670000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<85.090000,0.000000,26.670000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,0.000000,0> translate<82.550000,0.000000,26.670000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<85.090000,0.000000,24.130000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<85.090000,0.000000,26.670000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,90.000000,0> translate<85.090000,0.000000,26.670000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<82.550000,-1.535000,33.020000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<85.090000,-1.535000,35.560000>}
box{<0,0,-0.203200><3.592102,0.035000,0.203200> rotate<0,-44.997030,0> translate<82.550000,-1.535000,33.020000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<85.090000,-1.535000,35.560000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<85.090000,-1.535000,41.910000>}
box{<0,0,-0.203200><6.350000,0.035000,0.203200> rotate<0,90.000000,0> translate<85.090000,-1.535000,41.910000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<85.090000,-1.535000,41.910000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<85.090000,-1.535000,45.008800>}
box{<0,0,-0.203200><3.098800,0.035000,0.203200> rotate<0,90.000000,0> translate<85.090000,-1.535000,45.008800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<84.886800,-1.535000,46.990000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<85.090000,-1.535000,46.990000>}
box{<0,0,-0.203200><0.203200,0.035000,0.203200> rotate<0,0.000000,0> translate<84.886800,-1.535000,46.990000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<82.550000,-1.535000,50.800000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<85.090000,-1.535000,50.800000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,0.000000,0> translate<82.550000,-1.535000,50.800000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<81.280000,-1.535000,7.620000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<86.360000,-1.535000,7.620000>}
box{<0,0,-0.203200><5.080000,0.035000,0.203200> rotate<0,0.000000,0> translate<81.280000,-1.535000,7.620000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<83.820000,-1.535000,8.890000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<86.360000,-1.535000,11.430000>}
box{<0,0,-0.203200><3.592102,0.035000,0.203200> rotate<0,-44.997030,0> translate<83.820000,-1.535000,8.890000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<86.360000,-1.535000,13.970000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<86.360000,-1.535000,17.780000>}
box{<0,0,-0.203200><3.810000,0.035000,0.203200> rotate<0,90.000000,0> translate<86.360000,-1.535000,17.780000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<85.090000,-1.535000,50.800000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<86.360000,-1.535000,52.070000>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,-44.997030,0> translate<85.090000,-1.535000,50.800000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<83.820000,-1.535000,54.610000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<86.360000,-1.535000,54.610000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,0.000000,0> translate<83.820000,-1.535000,54.610000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<86.360000,-1.535000,52.070000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<86.360000,-1.535000,54.610000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,90.000000,0> translate<86.360000,-1.535000,54.610000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<73.660000,-1.535000,57.150000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<86.360000,-1.535000,57.150000>}
box{<0,0,-0.203200><12.700000,0.035000,0.203200> rotate<0,0.000000,0> translate<73.660000,-1.535000,57.150000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<85.090000,-1.535000,45.008800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<86.715600,-1.535000,45.008800>}
box{<0,0,-0.203200><1.625600,0.035000,0.203200> rotate<0,0.000000,0> translate<85.090000,-1.535000,45.008800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<79.019400,-1.535000,48.895000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<86.715600,-1.535000,48.895000>}
box{<0,0,-0.203200><7.696200,0.035000,0.203200> rotate<0,0.000000,0> translate<79.019400,-1.535000,48.895000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<86.715600,-1.535000,45.008800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<86.715600,-1.535000,48.895000>}
box{<0,0,-0.203200><3.886200,0.035000,0.203200> rotate<0,90.000000,0> translate<86.715600,-1.535000,48.895000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<34.290000,-1.535000,59.201100>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<86.848900,-1.535000,59.201100>}
box{<0,0,-0.203200><52.558900,0.035000,0.203200> rotate<0,0.000000,0> translate<34.290000,-1.535000,59.201100> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<85.090000,-1.535000,31.750000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<87.376000,-1.535000,34.036000>}
box{<0,0,-0.203200><3.232892,0.035000,0.203200> rotate<0,-44.997030,0> translate<85.090000,-1.535000,31.750000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<87.376000,-1.535000,34.036000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<87.376000,-1.535000,41.910000>}
box{<0,0,-0.203200><7.874000,0.035000,0.203200> rotate<0,90.000000,0> translate<87.376000,-1.535000,41.910000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<86.360000,-1.535000,7.620000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<87.630000,-1.535000,8.890000>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,-44.997030,0> translate<86.360000,-1.535000,7.620000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<85.090000,-1.535000,21.590000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<87.630000,-1.535000,21.590000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,0.000000,0> translate<85.090000,-1.535000,21.590000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<82.550000,-1.535000,29.210000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<87.630000,-1.535000,29.210000>}
box{<0,0,-0.203200><5.080000,0.035000,0.203200> rotate<0,0.000000,0> translate<82.550000,-1.535000,29.210000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<86.360000,-1.535000,57.150000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<87.630000,-1.535000,55.880000>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,44.997030,0> translate<86.360000,-1.535000,57.150000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<87.630000,-1.535000,46.278800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<87.630000,-1.535000,55.880000>}
box{<0,0,-0.203200><9.601200,0.035000,0.203200> rotate<0,90.000000,0> translate<87.630000,-1.535000,55.880000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<86.360000,-1.535000,17.780000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<88.900000,-1.535000,17.780000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,0.000000,0> translate<86.360000,-1.535000,17.780000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<87.630000,-1.535000,46.278800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<88.900000,-1.535000,45.008800>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,44.997030,0> translate<87.630000,-1.535000,46.278800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<88.900000,-1.535000,57.150000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<88.900000,-1.535000,50.800000>}
box{<0,0,-0.203200><6.350000,0.035000,0.203200> rotate<0,-90.000000,0> translate<88.900000,-1.535000,50.800000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<86.848900,-1.535000,59.201100>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<88.900000,-1.535000,57.150000>}
box{<0,0,-0.203200><2.900693,0.035000,0.203200> rotate<0,44.997030,0> translate<86.848900,-1.535000,59.201100> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<88.900000,-1.535000,17.780000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<89.255600,-1.535000,17.780000>}
box{<0,0,-0.203200><0.355600,0.035000,0.203200> rotate<0,0.000000,0> translate<88.900000,-1.535000,17.780000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<86.360000,-1.535000,3.810000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<90.170000,-1.535000,3.810000>}
box{<0,0,-0.203200><3.810000,0.035000,0.203200> rotate<0,0.000000,0> translate<86.360000,-1.535000,3.810000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<87.630000,-1.535000,8.890000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<90.170000,-1.535000,8.890000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,0.000000,0> translate<87.630000,-1.535000,8.890000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<89.255600,-1.535000,17.780000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<90.170000,-1.535000,18.694400>}
box{<0,0,-0.203200><1.293157,0.035000,0.203200> rotate<0,-44.997030,0> translate<89.255600,-1.535000,17.780000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<90.170000,-1.535000,18.694400>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<90.170000,-1.535000,21.590000>}
box{<0,0,-0.203200><2.895600,0.035000,0.203200> rotate<0,90.000000,0> translate<90.170000,-1.535000,21.590000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<90.170000,-1.535000,29.210000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<90.170000,-1.535000,31.750000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,90.000000,0> translate<90.170000,-1.535000,31.750000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<88.900000,-1.535000,50.800000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<90.170000,-1.535000,49.530000>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,44.997030,0> translate<88.900000,-1.535000,50.800000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<87.376000,-1.535000,41.910000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<91.694000,-1.535000,41.910000>}
box{<0,0,-0.203200><4.318000,0.035000,0.203200> rotate<0,0.000000,0> translate<87.376000,-1.535000,41.910000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<90.170000,-1.535000,8.890000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<92.710000,-1.535000,11.430000>}
box{<0,0,-0.203200><3.592102,0.035000,0.203200> rotate<0,-44.997030,0> translate<90.170000,-1.535000,8.890000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<92.710000,-1.535000,11.430000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<92.710000,-1.535000,21.590000>}
box{<0,0,-0.203200><10.160000,0.035000,0.203200> rotate<0,90.000000,0> translate<92.710000,-1.535000,21.590000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<92.710000,-1.535000,31.750000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<92.710000,-1.535000,29.210000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,-90.000000,0> translate<92.710000,-1.535000,29.210000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<93.980000,-1.535000,11.430000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<93.980000,-1.535000,17.780000>}
box{<0,0,-0.203200><6.350000,0.035000,0.203200> rotate<0,90.000000,0> translate<93.980000,-1.535000,17.780000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<92.710000,-1.535000,31.750000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<93.980000,-1.535000,33.020000>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,-44.997030,0> translate<92.710000,-1.535000,31.750000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<90.170000,-1.535000,31.750000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<93.980000,-1.535000,35.560000>}
box{<0,0,-0.203200><5.388154,0.035000,0.203200> rotate<0,-44.997030,0> translate<90.170000,-1.535000,31.750000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<93.980000,0.000000,38.100000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<93.980000,0.000000,41.910000>}
box{<0,0,-0.203200><3.810000,0.035000,0.203200> rotate<0,90.000000,0> translate<93.980000,0.000000,41.910000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<88.900000,-1.535000,45.008800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<93.980000,-1.535000,45.008800>}
box{<0,0,-0.203200><5.080000,0.035000,0.203200> rotate<0,0.000000,0> translate<88.900000,-1.535000,45.008800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<93.980000,-1.535000,41.910000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<93.980000,-1.535000,45.008800>}
box{<0,0,-0.203200><3.098800,0.035000,0.203200> rotate<0,90.000000,0> translate<93.980000,-1.535000,45.008800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<94.894400,-1.535000,12.700000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<94.894400,-1.535000,17.424400>}
box{<0,0,-0.203200><4.724400,0.035000,0.203200> rotate<0,90.000000,0> translate<94.894400,-1.535000,17.424400> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<93.980000,-1.535000,17.780000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<95.250000,-1.535000,19.050000>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,-44.997030,0> translate<93.980000,-1.535000,17.780000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<95.250000,-1.535000,19.050000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<95.250000,-1.535000,21.590000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,90.000000,0> translate<95.250000,-1.535000,21.590000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<82.550000,-1.535000,24.130000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<95.250000,-1.535000,24.130000>}
box{<0,0,-0.203200><12.700000,0.035000,0.203200> rotate<0,0.000000,0> translate<82.550000,-1.535000,24.130000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<95.250000,-1.535000,21.590000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<95.250000,-1.535000,24.130000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,90.000000,0> translate<95.250000,-1.535000,24.130000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<95.250000,0.000000,21.590000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<95.250000,0.000000,25.400000>}
box{<0,0,-0.203200><3.810000,0.035000,0.203200> rotate<0,90.000000,0> translate<95.250000,0.000000,25.400000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<95.250000,-1.535000,45.008800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<95.250000,-1.535000,46.990000>}
box{<0,0,-0.203200><1.981200,0.035000,0.203200> rotate<0,90.000000,0> translate<95.250000,-1.535000,46.990000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<93.980000,-1.535000,11.430000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<95.605600,-1.535000,9.804400>}
box{<0,0,-0.203200><2.298946,0.035000,0.203200> rotate<0,44.997030,0> translate<93.980000,-1.535000,11.430000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<94.894400,-1.535000,12.700000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<96.164400,-1.535000,11.430000>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,44.997030,0> translate<94.894400,-1.535000,12.700000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<96.266000,-1.535000,39.370000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<96.266000,-1.535000,41.910000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,90.000000,0> translate<96.266000,-1.535000,41.910000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<95.250000,-1.535000,45.008800>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<96.266000,-1.535000,45.008800>}
box{<0,0,-0.203200><1.016000,0.035000,0.203200> rotate<0,0.000000,0> translate<95.250000,-1.535000,45.008800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<96.266000,-1.535000,41.910000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<96.266000,-1.535000,45.008800>}
box{<0,0,-0.203200><3.098800,0.035000,0.203200> rotate<0,90.000000,0> translate<96.266000,-1.535000,45.008800> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<90.170000,-1.535000,8.890000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<96.520000,-1.535000,8.890000>}
box{<0,0,-0.203200><6.350000,0.035000,0.203200> rotate<0,0.000000,0> translate<90.170000,-1.535000,8.890000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<94.894400,-1.535000,17.424400>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<96.520000,-1.535000,19.050000>}
box{<0,0,-0.203200><2.298946,0.035000,0.203200> rotate<0,-44.997030,0> translate<94.894400,-1.535000,17.424400> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<96.520000,-1.535000,19.050000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<96.520000,-1.535000,19.625300>}
box{<0,0,-0.203200><0.575300,0.035000,0.203200> rotate<0,90.000000,0> translate<96.520000,-1.535000,19.625300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<93.980000,-1.535000,33.020000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<96.520000,-1.535000,33.020000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,0.000000,0> translate<93.980000,-1.535000,33.020000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<93.980000,0.000000,38.100000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<96.520000,0.000000,38.100000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,0.000000,0> translate<93.980000,0.000000,38.100000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<96.520000,0.000000,31.750000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<96.520000,0.000000,38.100000>}
box{<0,0,-0.203200><6.350000,0.035000,0.203200> rotate<0,90.000000,0> translate<96.520000,0.000000,38.100000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<92.710000,-1.535000,54.610000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<96.520000,-1.535000,50.800000>}
box{<0,0,-0.203200><5.388154,0.035000,0.203200> rotate<0,44.997030,0> translate<92.710000,-1.535000,54.610000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<96.520000,-1.535000,19.625300>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<97.214700,-1.535000,20.320000>}
box{<0,0,-0.203200><0.982454,0.035000,0.203200> rotate<0,-44.997030,0> translate<96.520000,-1.535000,19.625300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<95.250000,-1.535000,29.210000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<97.214700,-1.535000,27.245300>}
box{<0,0,-0.203200><2.778505,0.035000,0.203200> rotate<0,44.997030,0> translate<95.250000,-1.535000,29.210000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<97.214700,-1.535000,20.320000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<97.214700,-1.535000,27.245300>}
box{<0,0,-0.203200><6.925300,0.035000,0.203200> rotate<0,90.000000,0> translate<97.214700,-1.535000,27.245300> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<97.790000,-1.535000,7.620000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<97.790000,-1.535000,3.810000>}
box{<0,0,-0.203200><3.810000,0.035000,0.203200> rotate<0,-90.000000,0> translate<97.790000,-1.535000,3.810000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<96.520000,-1.535000,8.890000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<97.790000,-1.535000,7.620000>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,44.997030,0> translate<96.520000,-1.535000,8.890000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<96.164400,-1.535000,11.430000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<97.790000,-1.535000,11.430000>}
box{<0,0,-0.203200><1.625600,0.035000,0.203200> rotate<0,0.000000,0> translate<96.164400,-1.535000,11.430000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<96.520000,-1.535000,13.970000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<97.790000,-1.535000,15.240000>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,-44.997030,0> translate<96.520000,-1.535000,13.970000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<97.790000,-1.535000,15.240000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<97.790000,-1.535000,18.448600>}
box{<0,0,-0.203200><3.208600,0.035000,0.203200> rotate<0,90.000000,0> translate<97.790000,-1.535000,18.448600> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<95.250000,0.000000,25.400000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<97.790000,0.000000,25.400000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,0.000000,0> translate<95.250000,0.000000,25.400000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<96.520000,0.000000,31.750000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<97.790000,0.000000,30.480000>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,44.997030,0> translate<96.520000,0.000000,31.750000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<97.790000,0.000000,25.400000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<97.790000,0.000000,30.480000>}
box{<0,0,-0.203200><5.080000,0.035000,0.203200> rotate<0,90.000000,0> translate<97.790000,0.000000,30.480000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<97.790000,-1.535000,18.448600>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<98.391400,-1.535000,19.050000>}
box{<0,0,-0.203200><0.850508,0.035000,0.203200> rotate<0,-44.997030,0> translate<97.790000,-1.535000,18.448600> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<96.520000,-1.535000,33.020000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<98.391400,-1.535000,31.148600>}
box{<0,0,-0.203200><2.646559,0.035000,0.203200> rotate<0,44.997030,0> translate<96.520000,-1.535000,33.020000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<98.391400,-1.535000,19.050000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<98.391400,-1.535000,31.148600>}
box{<0,0,-0.203200><12.098600,0.035000,0.203200> rotate<0,90.000000,0> translate<98.391400,-1.535000,31.148600> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<95.605600,-1.535000,9.804400>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<98.704400,-1.535000,9.804400>}
box{<0,0,-0.203200><3.098800,0.035000,0.203200> rotate<0,0.000000,0> translate<95.605600,-1.535000,9.804400> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<63.500000,-1.535000,1.270000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<99.060000,-1.535000,1.270000>}
box{<0,0,-0.203200><35.560000,0.035000,0.203200> rotate<0,0.000000,0> translate<63.500000,-1.535000,1.270000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<97.790000,-1.535000,7.620000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<99.060000,-1.535000,8.890000>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,-44.997030,0> translate<97.790000,-1.535000,7.620000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<99.060000,-1.535000,1.270000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<100.330000,-1.535000,2.540000>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,-44.997030,0> translate<99.060000,-1.535000,1.270000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<100.330000,-1.535000,2.540000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<100.330000,-1.535000,6.350000>}
box{<0,0,-0.203200><3.810000,0.035000,0.203200> rotate<0,90.000000,0> translate<100.330000,-1.535000,6.350000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<98.704400,-1.535000,9.804400>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<100.330000,-1.535000,11.430000>}
box{<0,0,-0.203200><2.298946,0.035000,0.203200> rotate<0,-44.997030,0> translate<98.704400,-1.535000,9.804400> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<100.330000,-1.535000,19.050000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<100.330000,-1.535000,24.130000>}
box{<0,0,-0.203200><5.080000,0.035000,0.203200> rotate<0,90.000000,0> translate<100.330000,-1.535000,24.130000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<100.330000,-1.535000,29.210000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<100.330000,-1.535000,31.750000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,90.000000,0> translate<100.330000,-1.535000,31.750000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<96.266000,-1.535000,39.370000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<100.330000,-1.535000,39.370000>}
box{<0,0,-0.203200><4.064000,0.035000,0.203200> rotate<0,0.000000,0> translate<96.266000,-1.535000,39.370000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<99.060000,-1.535000,8.890000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<100.965000,-1.535000,8.890000>}
box{<0,0,-0.203200><1.905000,0.035000,0.203200> rotate<0,0.000000,0> translate<99.060000,-1.535000,8.890000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<100.330000,-1.535000,31.750000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<101.600000,-1.535000,33.020000>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,-44.997030,0> translate<100.330000,-1.535000,31.750000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<99.060000,-1.535000,35.560000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<101.600000,-1.535000,35.560000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,0.000000,0> translate<99.060000,-1.535000,35.560000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<101.600000,-1.535000,33.020000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<101.600000,-1.535000,35.560000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,90.000000,0> translate<101.600000,-1.535000,35.560000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<90.170000,-1.535000,49.530000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<101.600000,-1.535000,49.530000>}
box{<0,0,-0.203200><11.430000,0.035000,0.203200> rotate<0,0.000000,0> translate<90.170000,-1.535000,49.530000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<100.965000,-1.535000,8.890000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<102.235000,-1.535000,10.160000>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,-44.997030,0> translate<100.965000,-1.535000,8.890000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<102.235000,-1.535000,15.240000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<102.235000,-1.535000,10.160000>}
box{<0,0,-0.203200><5.080000,0.035000,0.203200> rotate<0,-90.000000,0> translate<102.235000,-1.535000,10.160000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<102.235000,-1.535000,15.240000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<102.870000,-1.535000,15.875000>}
box{<0,0,-0.203200><0.898026,0.035000,0.203200> rotate<0,-44.997030,0> translate<102.235000,-1.535000,15.240000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<102.870000,-1.535000,19.050000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<102.870000,-1.535000,15.875000>}
box{<0,0,-0.203200><3.175000,0.035000,0.203200> rotate<0,-90.000000,0> translate<102.870000,-1.535000,15.875000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<102.870000,0.000000,24.130000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<102.870000,0.000000,19.050000>}
box{<0,0,-0.203200><5.080000,0.035000,0.203200> rotate<0,-90.000000,0> translate<102.870000,0.000000,19.050000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<100.330000,-1.535000,24.130000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<102.870000,-1.535000,26.670000>}
box{<0,0,-0.203200><3.592102,0.035000,0.203200> rotate<0,-44.997030,0> translate<100.330000,-1.535000,24.130000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<102.870000,-1.535000,26.670000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<102.870000,-1.535000,29.210000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,90.000000,0> translate<102.870000,-1.535000,29.210000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<102.870000,0.000000,39.370000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<102.870000,0.000000,35.560000>}
box{<0,0,-0.203200><3.810000,0.035000,0.203200> rotate<0,-90.000000,0> translate<102.870000,0.000000,35.560000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<102.870000,-1.535000,48.260000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<102.870000,-1.535000,39.370000>}
box{<0,0,-0.203200><8.890000,0.035000,0.203200> rotate<0,-90.000000,0> translate<102.870000,-1.535000,39.370000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<101.600000,-1.535000,49.530000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<102.870000,-1.535000,48.260000>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,44.997030,0> translate<101.600000,-1.535000,49.530000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<102.235000,-1.535000,10.160000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<103.505000,-1.535000,8.890000>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,44.997030,0> translate<102.235000,-1.535000,10.160000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<104.140000,-1.535000,8.890000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<104.140000,-1.535000,3.810000>}
box{<0,0,-0.203200><5.080000,0.035000,0.203200> rotate<0,-90.000000,0> translate<104.140000,-1.535000,3.810000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<103.505000,-1.535000,8.890000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<104.140000,-1.535000,8.890000>}
box{<0,0,-0.203200><0.635000,0.035000,0.203200> rotate<0,0.000000,0> translate<103.505000,-1.535000,8.890000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<104.140000,-1.535000,11.430000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<104.140000,-1.535000,13.970000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,90.000000,0> translate<104.140000,-1.535000,13.970000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<104.140000,-1.535000,13.970000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<104.140000,-1.535000,16.510000>}
box{<0,0,-0.203200><2.540000,0.035000,0.203200> rotate<0,90.000000,0> translate<104.140000,-1.535000,16.510000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<96.520000,-1.535000,50.800000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<104.140000,-1.535000,50.800000>}
box{<0,0,-0.203200><7.620000,0.035000,0.203200> rotate<0,0.000000,0> translate<96.520000,-1.535000,50.800000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<104.140000,-1.535000,16.510000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<105.410000,-1.535000,17.780000>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,-44.997030,0> translate<104.140000,-1.535000,16.510000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<105.410000,-1.535000,17.780000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<105.410000,-1.535000,29.210000>}
box{<0,0,-0.203200><11.430000,0.035000,0.203200> rotate<0,90.000000,0> translate<105.410000,-1.535000,29.210000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<104.140000,-1.535000,50.800000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<105.410000,-1.535000,49.530000>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,44.997030,0> translate<104.140000,-1.535000,50.800000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<105.410000,-1.535000,29.210000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<105.410000,-1.535000,49.530000>}
box{<0,0,-0.203200><20.320000,0.035000,0.203200> rotate<0,90.000000,0> translate<105.410000,-1.535000,49.530000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<102.870000,0.000000,24.130000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<107.950000,0.000000,24.130000>}
box{<0,0,-0.203200><5.080000,0.035000,0.203200> rotate<0,0.000000,0> translate<102.870000,0.000000,24.130000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<107.950000,0.000000,35.560000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<107.950000,0.000000,24.130000>}
box{<0,0,-0.203200><11.430000,0.035000,0.203200> rotate<0,-90.000000,0> translate<107.950000,0.000000,24.130000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<102.870000,0.000000,35.560000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<107.950000,0.000000,35.560000>}
box{<0,0,-0.203200><5.080000,0.035000,0.203200> rotate<0,0.000000,0> translate<102.870000,0.000000,35.560000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<48.260000,-1.535000,0.298400>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<110.788400,-1.535000,0.298400>}
box{<0,0,-0.203200><62.528400,0.035000,0.203200> rotate<0,0.000000,0> translate<48.260000,-1.535000,0.298400> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<100.330000,-1.535000,54.610000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<111.760000,-1.535000,54.610000>}
box{<0,0,-0.203200><11.430000,0.035000,0.203200> rotate<0,0.000000,0> translate<100.330000,-1.535000,54.610000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<110.788400,-1.535000,0.298400>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<113.030000,-1.535000,2.540000>}
box{<0,0,-0.203200><3.170101,0.035000,0.203200> rotate<0,-44.997030,0> translate<110.788400,-1.535000,0.298400> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<111.760000,-1.535000,54.610000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<113.030000,-1.535000,53.340000>}
box{<0,0,-0.203200><1.796051,0.035000,0.203200> rotate<0,44.997030,0> translate<111.760000,-1.535000,54.610000> }
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<113.030000,-1.535000,2.540000>}
cylinder{<0,0,0><0,0.035000,0>0.203200 translate<113.030000,-1.535000,53.340000>}
box{<0,0,-0.203200><50.800000,0.035000,0.203200> rotate<0,90.000000,0> translate<113.030000,-1.535000,53.340000> }
//Text
//Rect
union{
texture{col_pds}
}
texture{col_wrs}
}
#end
#if(pcb_polygons=on)
union{
//Poligonok
texture{col_pol}
}
#end
union{
cylinder{<100.330000,0.038000,54.610000><100.330000,-1.538000,54.610000>0.508000}
cylinder{<83.820000,0.038000,54.610000><83.820000,-1.538000,54.610000>0.508000}
cylinder{<49.530000,0.038000,33.020000><49.530000,-1.538000,33.020000>0.508000}
cylinder{<44.450000,0.038000,33.020000><44.450000,-1.538000,33.020000>0.508000}
cylinder{<62.230000,0.038000,52.070000><62.230000,-1.538000,52.070000>0.508000}
cylinder{<62.230000,0.038000,57.150000><62.230000,-1.538000,57.150000>0.508000}
cylinder{<36.830000,0.038000,34.290000><36.830000,-1.538000,34.290000>0.508000}
cylinder{<36.830000,0.038000,29.210000><36.830000,-1.538000,29.210000>0.508000}
cylinder{<36.830000,0.038000,52.070000><36.830000,-1.538000,52.070000>0.508000}
cylinder{<36.830000,0.038000,57.150000><36.830000,-1.538000,57.150000>0.508000}
cylinder{<64.770000,0.038000,12.700000><64.770000,-1.538000,12.700000>0.406400}
cylinder{<64.770000,0.038000,17.780000><64.770000,-1.538000,17.780000>0.406400}
cylinder{<86.360000,0.038000,13.970000><86.360000,-1.538000,13.970000>0.406400}
cylinder{<81.280000,0.038000,13.970000><81.280000,-1.538000,13.970000>0.406400}
cylinder{<90.170000,0.038000,8.890000><90.170000,-1.538000,8.890000>0.406400}
cylinder{<90.170000,0.038000,3.810000><90.170000,-1.538000,3.810000>0.406400}
cylinder{<82.550000,0.038000,24.130000><82.550000,-1.538000,24.130000>0.406400}
cylinder{<82.550000,0.038000,29.210000><82.550000,-1.538000,29.210000>0.406400}
cylinder{<77.470000,0.038000,44.450000><77.470000,-1.538000,44.450000>0.406400}
cylinder{<72.390000,0.038000,44.450000><72.390000,-1.538000,44.450000>0.406400}
cylinder{<62.230000,0.038000,41.910000><62.230000,-1.538000,41.910000>0.508000}
cylinder{<62.230000,0.038000,36.830000><62.230000,-1.538000,36.830000>0.508000}
cylinder{<69.850000,0.038000,54.610000><69.850000,-1.538000,54.610000>0.508000}
cylinder{<74.930000,0.038000,54.610000><74.930000,-1.538000,54.610000>0.508000}
cylinder{<35.560000,0.038000,25.400000><35.560000,-1.538000,25.400000>0.406400}
cylinder{<45.720000,0.038000,25.400000><45.720000,-1.538000,25.400000>0.406400}
cylinder{<45.720000,0.038000,22.860000><45.720000,-1.538000,22.860000>0.406400}
cylinder{<35.560000,0.038000,22.860000><35.560000,-1.538000,22.860000>0.406400}
cylinder{<35.560000,0.038000,20.320000><35.560000,-1.538000,20.320000>0.406400}
cylinder{<45.720000,0.038000,20.320000><45.720000,-1.538000,20.320000>0.406400}
cylinder{<45.720000,0.038000,17.780000><45.720000,-1.538000,17.780000>0.406400}
cylinder{<35.560000,0.038000,17.780000><35.560000,-1.538000,17.780000>0.406400}
cylinder{<35.560000,0.038000,15.240000><35.560000,-1.538000,15.240000>0.406400}
cylinder{<45.720000,0.038000,15.240000><45.720000,-1.538000,15.240000>0.406400}
cylinder{<45.720000,0.038000,12.700000><45.720000,-1.538000,12.700000>0.406400}
cylinder{<35.560000,0.038000,12.700000><35.560000,-1.538000,12.700000>0.406400}
cylinder{<54.610000,0.038000,10.160000><54.610000,-1.538000,10.160000>0.406400}
cylinder{<64.770000,0.038000,10.160000><64.770000,-1.538000,10.160000>0.406400}
cylinder{<64.770000,0.038000,5.080000><64.770000,-1.538000,5.080000>0.406400}
cylinder{<54.610000,0.038000,5.080000><54.610000,-1.538000,5.080000>0.406400}
cylinder{<92.710000,0.038000,54.610000><92.710000,-1.538000,54.610000>0.508000}
cylinder{<78.740000,0.038000,25.400000><78.740000,-1.538000,25.400000>0.406400}
cylinder{<78.740000,0.038000,27.940000><78.740000,-1.538000,27.940000>0.406400}
cylinder{<78.740000,0.038000,30.480000><78.740000,-1.538000,30.480000>0.406400}
cylinder{<78.740000,0.038000,33.020000><78.740000,-1.538000,33.020000>0.406400}
cylinder{<78.740000,0.038000,35.560000><78.740000,-1.538000,35.560000>0.406400}
cylinder{<78.740000,0.038000,38.100000><78.740000,-1.538000,38.100000>0.406400}
cylinder{<78.740000,0.038000,40.640000><78.740000,-1.538000,40.640000>0.406400}
cylinder{<71.120000,0.038000,40.640000><71.120000,-1.538000,40.640000>0.406400}
cylinder{<71.120000,0.038000,38.100000><71.120000,-1.538000,38.100000>0.406400}
cylinder{<71.120000,0.038000,35.560000><71.120000,-1.538000,35.560000>0.406400}
cylinder{<71.120000,0.038000,33.020000><71.120000,-1.538000,33.020000>0.406400}
cylinder{<71.120000,0.038000,30.480000><71.120000,-1.538000,30.480000>0.406400}
cylinder{<71.120000,0.038000,27.940000><71.120000,-1.538000,27.940000>0.406400}
cylinder{<71.120000,0.038000,25.400000><71.120000,-1.538000,25.400000>0.406400}
cylinder{<68.580000,0.038000,10.160000><68.580000,-1.538000,10.160000>0.406400}
cylinder{<71.120000,0.038000,10.160000><71.120000,-1.538000,10.160000>0.406400}
cylinder{<73.660000,0.038000,10.160000><73.660000,-1.538000,10.160000>0.406400}
cylinder{<76.200000,0.038000,10.160000><76.200000,-1.538000,10.160000>0.406400}
cylinder{<76.200000,0.038000,17.780000><76.200000,-1.538000,17.780000>0.406400}
cylinder{<73.660000,0.038000,17.780000><73.660000,-1.538000,17.780000>0.406400}
cylinder{<71.120000,0.038000,17.780000><71.120000,-1.538000,17.780000>0.406400}
cylinder{<68.580000,0.038000,17.780000><68.580000,-1.538000,17.780000>0.406400}
cylinder{<87.630000,0.038000,21.590000><87.630000,-1.538000,21.590000>0.406400}
cylinder{<90.170000,0.038000,21.590000><90.170000,-1.538000,21.590000>0.406400}
cylinder{<92.710000,0.038000,21.590000><92.710000,-1.538000,21.590000>0.406400}
cylinder{<95.250000,0.038000,21.590000><95.250000,-1.538000,21.590000>0.406400}
cylinder{<95.250000,0.038000,29.210000><95.250000,-1.538000,29.210000>0.406400}
cylinder{<92.710000,0.038000,29.210000><92.710000,-1.538000,29.210000>0.406400}
cylinder{<90.170000,0.038000,29.210000><90.170000,-1.538000,29.210000>0.406400}
cylinder{<87.630000,0.038000,29.210000><87.630000,-1.538000,29.210000>0.406400}
cylinder{<46.990000,0.038000,44.450000><46.990000,-1.538000,44.450000>0.508000}
cylinder{<46.990000,0.038000,46.990000><46.990000,-1.538000,46.990000>0.508000}
cylinder{<46.990000,0.038000,41.910000><46.990000,-1.538000,41.910000>0.508000}
cylinder{<53.340000,0.038000,52.070000><53.340000,-1.538000,52.070000>0.508000}
cylinder{<53.340000,0.038000,54.610000><53.340000,-1.538000,54.610000>0.508000}
cylinder{<53.340000,0.038000,57.150000><53.340000,-1.538000,57.150000>0.508000}
cylinder{<57.150000,0.038000,33.020000><57.150000,-1.538000,33.020000>0.406400}
cylinder{<55.880000,0.038000,31.115000><55.880000,-1.538000,31.115000>0.406400}
cylinder{<54.610000,0.038000,33.020000><54.610000,-1.538000,33.020000>0.406400}
cylinder{<63.500000,0.038000,46.990000><63.500000,-1.538000,46.990000>0.406400}
cylinder{<64.770000,0.038000,48.895000><64.770000,-1.538000,48.895000>0.406400}
cylinder{<66.040000,0.038000,46.990000><66.040000,-1.538000,46.990000>0.406400}
cylinder{<62.230000,0.038000,15.240000><62.230000,-1.538000,15.240000>0.406400}
cylinder{<57.150000,0.038000,15.240000><57.150000,-1.538000,15.240000>0.406400}
cylinder{<80.010000,0.038000,45.720000><80.010000,-1.538000,45.720000>0.406400}
cylinder{<80.010000,0.038000,50.800000><80.010000,-1.538000,50.800000>0.406400}
cylinder{<93.980000,0.038000,35.560000><93.980000,-1.538000,35.560000>0.406400}
cylinder{<99.060000,0.038000,35.560000><99.060000,-1.538000,35.560000>0.406400}
cylinder{<82.550000,0.038000,45.720000><82.550000,-1.538000,45.720000>0.406400}
cylinder{<82.550000,0.038000,50.800000><82.550000,-1.538000,50.800000>0.406400}
cylinder{<49.530000,0.038000,38.100000><49.530000,-1.538000,38.100000>0.406400}
cylinder{<54.610000,0.038000,38.100000><54.610000,-1.538000,38.100000>0.406400}
cylinder{<100.330000,0.038000,6.350000><100.330000,-1.538000,6.350000>0.406400}
cylinder{<100.330000,0.038000,11.430000><100.330000,-1.538000,11.430000>0.406400}
cylinder{<85.090000,0.038000,21.590000><85.090000,-1.538000,21.590000>0.406400}
cylinder{<85.090000,0.038000,31.750000><85.090000,-1.538000,31.750000>0.406400}
cylinder{<95.250000,0.038000,46.990000><95.250000,-1.538000,46.990000>0.406400}
cylinder{<85.090000,0.038000,46.990000><85.090000,-1.538000,46.990000>0.406400}
cylinder{<100.330000,0.038000,39.370000><100.330000,-1.538000,39.370000>0.457200}
cylinder{<102.870000,0.038000,39.370000><102.870000,-1.538000,39.370000>0.457200}
cylinder{<100.330000,0.038000,19.050000><100.330000,-1.538000,19.050000>0.457200}
cylinder{<102.870000,0.038000,19.050000><102.870000,-1.538000,19.050000>0.457200}
cylinder{<62.230000,0.038000,27.940000><62.230000,-1.538000,27.940000>0.457200}
cylinder{<59.690000,0.038000,27.940000><59.690000,-1.538000,27.940000>0.457200}
cylinder{<49.530000,0.038000,10.160000><49.530000,-1.538000,10.160000>0.457200}
cylinder{<49.530000,0.038000,7.620000><49.530000,-1.538000,7.620000>0.457200}
cylinder{<49.530000,0.038000,5.080000><49.530000,-1.538000,5.080000>0.457200}
cylinder{<44.450000,0.038000,10.160000><44.450000,-1.538000,10.160000>0.457200}
cylinder{<44.450000,0.038000,7.620000><44.450000,-1.538000,7.620000>0.457200}
cylinder{<44.450000,0.038000,5.080000><44.450000,-1.538000,5.080000>0.457200}
cylinder{<105.410000,0.038000,29.210000><105.410000,-1.538000,29.210000>0.457200}
cylinder{<102.870000,0.038000,29.210000><102.870000,-1.538000,29.210000>0.457200}
cylinder{<100.330000,0.038000,29.210000><100.330000,-1.538000,29.210000>0.457200}
cylinder{<5.080000,0.038000,21.590000><5.080000,-1.538000,21.590000>0.508000}
cylinder{<25.400000,0.038000,21.590000><25.400000,-1.538000,21.590000>0.508000}
cylinder{<2.540000,0.038000,57.150000><2.540000,-1.538000,57.150000>0.508000}
cylinder{<110.490000,0.038000,57.150000><110.490000,-1.538000,57.150000>0.508000}
cylinder{<2.540000,0.038000,2.540000><2.540000,-1.538000,2.540000>0.508000}
cylinder{<110.490000,0.038000,3.810000><110.490000,-1.538000,3.810000>0.508000}
cylinder{<87.376000,0.038000,41.910000><87.376000,-1.538000,41.910000>0.508000}
cylinder{<85.090000,0.038000,41.910000><85.090000,-1.538000,41.910000>0.508000}
cylinder{<82.804000,0.038000,41.910000><82.804000,-1.538000,41.910000>0.508000}
cylinder{<91.694000,0.038000,41.910000><91.694000,-1.538000,41.910000>0.508000}
cylinder{<93.980000,0.038000,41.910000><93.980000,-1.538000,41.910000>0.508000}
cylinder{<96.266000,0.038000,41.910000><96.266000,-1.538000,41.910000>0.508000}
cylinder{<67.310000,0.038000,29.210000><67.310000,-1.538000,29.210000>0.406400}
cylinder{<67.310000,0.038000,21.590000><67.310000,-1.538000,21.590000>0.406400}
cylinder{<64.770000,0.038000,20.320000><64.770000,-1.538000,20.320000>0.406400}
cylinder{<57.150000,0.038000,20.320000><57.150000,-1.538000,20.320000>0.406400}
cylinder{<64.770000,0.038000,22.860000><64.770000,-1.538000,22.860000>0.406400}
cylinder{<57.150000,0.038000,22.860000><57.150000,-1.538000,22.860000>0.406400}
cylinder{<54.610000,0.038000,27.940000><54.610000,-1.538000,27.940000>0.406400}
cylinder{<54.610000,0.038000,20.320000><54.610000,-1.538000,20.320000>0.406400}
cylinder{<52.070000,0.038000,27.940000><52.070000,-1.538000,27.940000>0.406400}
cylinder{<52.070000,0.038000,20.320000><52.070000,-1.538000,20.320000>0.406400}
cylinder{<82.550000,0.038000,11.430000><82.550000,-1.538000,11.430000>0.406400}
cylinder{<82.550000,0.038000,3.810000><82.550000,-1.538000,3.810000>0.406400}
cylinder{<68.580000,0.038000,5.080000><68.580000,-1.538000,5.080000>0.406400}
cylinder{<76.200000,0.038000,5.080000><76.200000,-1.538000,5.080000>0.406400}
cylinder{<78.740000,0.038000,5.080000><78.740000,-1.538000,5.080000>0.406400}
cylinder{<78.740000,0.038000,12.700000><78.740000,-1.538000,12.700000>0.406400}
cylinder{<71.120000,0.038000,21.590000><71.120000,-1.538000,21.590000>0.406400}
cylinder{<78.740000,0.038000,21.590000><78.740000,-1.538000,21.590000>0.406400}
cylinder{<81.280000,0.038000,17.780000><81.280000,-1.538000,17.780000>0.406400}
cylinder{<88.900000,0.038000,17.780000><88.900000,-1.538000,17.780000>0.406400}
cylinder{<86.360000,0.038000,3.810000><86.360000,-1.538000,3.810000>0.406400}
cylinder{<86.360000,0.038000,11.430000><86.360000,-1.538000,11.430000>0.406400}
cylinder{<104.140000,0.038000,3.810000><104.140000,-1.538000,3.810000>0.406400}
cylinder{<104.140000,0.038000,11.430000><104.140000,-1.538000,11.430000>0.406400}
cylinder{<97.790000,0.038000,3.810000><97.790000,-1.538000,3.810000>0.406400}
cylinder{<97.790000,0.038000,11.430000><97.790000,-1.538000,11.430000>0.406400}
cylinder{<96.520000,0.038000,13.970000><96.520000,-1.538000,13.970000>0.406400}
cylinder{<104.140000,0.038000,13.970000><104.140000,-1.538000,13.970000>0.406400}
cylinder{<93.980000,0.038000,33.020000><93.980000,-1.538000,33.020000>0.406400}
cylinder{<101.600000,0.038000,33.020000><101.600000,-1.538000,33.020000>0.406400}
cylinder{<25.400000,0.038000,29.210000><25.400000,-1.538000,29.210000>0.650000}
cylinder{<5.080000,0.038000,29.210000><5.080000,-1.538000,29.210000>0.650000}
cylinder{<25.400000,0.038000,49.530000><25.400000,-1.538000,49.530000>0.650000}
cylinder{<20.320000,0.038000,49.530000><20.320000,-1.538000,49.530000>0.650000}
cylinder{<10.160000,0.038000,49.530000><10.160000,-1.538000,49.530000>0.650000}
cylinder{<5.080000,0.038000,49.530000><5.080000,-1.538000,49.530000>0.650000}
cylinder{<34.290000,0.038000,40.640000><34.290000,-1.538000,40.640000>0.400000}
cylinder{<39.370000,0.038000,45.720000><39.370000,-1.538000,45.720000>0.400000}
cylinder{<34.290000,0.038000,45.720000><34.290000,-1.538000,45.720000>0.400000}
cylinder{<39.370000,0.038000,40.640000><39.370000,-1.538000,40.640000>0.400000}
//Furat(gyors md)/Vezetsv
//Furat(gyors md)/Panel
texture{col_hls}
}
#if(pcb_silkscreen=on)
//Pozcinyomat
union{
//B silk screen
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<101.600000,0.000000,55.880000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<101.600000,0.000000,55.372000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,-90.000000,0> translate<101.600000,0.000000,55.372000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<101.600000,0.000000,55.880000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<101.092000,0.000000,55.880000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,0.000000,0> translate<101.092000,0.000000,55.880000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<99.060000,0.000000,55.880000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<99.568000,0.000000,55.880000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,0.000000,0> translate<99.060000,0.000000,55.880000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<99.060000,0.000000,55.880000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<99.060000,0.000000,55.372000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,-90.000000,0> translate<99.060000,0.000000,55.372000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<99.060000,0.000000,53.340000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<99.060000,0.000000,53.848000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,90.000000,0> translate<99.060000,0.000000,53.848000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<99.060000,0.000000,53.340000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<99.568000,0.000000,53.340000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,0.000000,0> translate<99.060000,0.000000,53.340000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<101.092000,0.000000,53.340000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<101.600000,0.000000,53.340000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,0.000000,0> translate<101.092000,0.000000,53.340000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<101.600000,0.000000,53.340000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<101.600000,0.000000,53.848000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,90.000000,0> translate<101.600000,0.000000,53.848000> }
difference{
cylinder{<100.330000,0,54.610000><100.330000,0.036000,54.610000>1.092200 translate<0,0.000000,0>}
cylinder{<100.330000,-0.1,54.610000><100.330000,0.135000,54.610000>0.939800 translate<0,0.000000,0>}}
//C silk screen
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<85.090000,0.000000,55.880000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<85.090000,0.000000,55.372000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,-90.000000,0> translate<85.090000,0.000000,55.372000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<85.090000,0.000000,55.880000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<84.582000,0.000000,55.880000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,0.000000,0> translate<84.582000,0.000000,55.880000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<82.550000,0.000000,55.880000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.058000,0.000000,55.880000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,0.000000,0> translate<82.550000,0.000000,55.880000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<82.550000,0.000000,55.880000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<82.550000,0.000000,55.372000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,-90.000000,0> translate<82.550000,0.000000,55.372000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<82.550000,0.000000,53.340000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<82.550000,0.000000,53.848000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,90.000000,0> translate<82.550000,0.000000,53.848000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<82.550000,0.000000,53.340000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.058000,0.000000,53.340000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,0.000000,0> translate<82.550000,0.000000,53.340000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<84.582000,0.000000,53.340000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<85.090000,0.000000,53.340000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,0.000000,0> translate<84.582000,0.000000,53.340000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<85.090000,0.000000,53.340000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<85.090000,0.000000,53.848000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,90.000000,0> translate<85.090000,0.000000,53.848000> }
difference{
cylinder{<83.820000,0,54.610000><83.820000,0.036000,54.610000>1.092200 translate<0,0.000000,0>}
cylinder{<83.820000,-0.1,54.610000><83.820000,0.135000,54.610000>0.939800 translate<0,0.000000,0>}}
//C1 silk screen
cylinder{<0,0,0><0,0.036000,0>0.088900 translate<50.165000,0.000000,30.480000>}
cylinder{<0,0,0><0,0.036000,0>0.088900 translate<48.895000,0.000000,30.480000>}
box{<0,0,-0.088900><1.270000,0.036000,0.088900> rotate<0,0.000000,0> translate<48.895000,0.000000,30.480000> }
cylinder{<0,0,0><0,0.036000,0>0.088900 translate<49.530000,0.000000,29.845000>}
cylinder{<0,0,0><0,0.036000,0>0.088900 translate<49.530000,0.000000,31.115000>}
box{<0,0,-0.088900><1.270000,0.036000,0.088900> rotate<0,90.000000,0> translate<49.530000,0.000000,31.115000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<47.942500,0.000000,31.432500>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<47.942500,0.000000,33.020000>}
box{<0,0,-0.076200><1.587500,0.036000,0.076200> rotate<0,90.000000,0> translate<47.942500,0.000000,33.020000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<47.942500,0.000000,33.020000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<47.942500,0.000000,34.607500>}
box{<0,0,-0.076200><1.587500,0.036000,0.076200> rotate<0,90.000000,0> translate<47.942500,0.000000,34.607500> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<47.942500,0.000000,34.607500>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<47.307500,0.000000,34.607500>}
box{<0,0,-0.076200><0.635000,0.036000,0.076200> rotate<0,0.000000,0> translate<47.307500,0.000000,34.607500> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<47.307500,0.000000,34.607500>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<47.307500,0.000000,31.432500>}
box{<0,0,-0.076200><3.175000,0.036000,0.076200> rotate<0,-90.000000,0> translate<47.307500,0.000000,31.432500> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<47.307500,0.000000,31.432500>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<47.942500,0.000000,31.432500>}
box{<0,0,-0.076200><0.635000,0.036000,0.076200> rotate<0,0.000000,0> translate<47.307500,0.000000,31.432500> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<47.942500,0.000000,33.020000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<49.530000,0.000000,33.020000>}
box{<0,0,-0.076200><1.587500,0.036000,0.076200> rotate<0,0.000000,0> translate<47.942500,0.000000,33.020000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<45.720000,0.000000,33.020000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<44.450000,0.000000,33.020000>}
box{<0,0,-0.076200><1.270000,0.036000,0.076200> rotate<0,0.000000,0> translate<44.450000,0.000000,33.020000> }
difference{
cylinder{<46.990000,0,33.020000><46.990000,0.036000,33.020000>5.218200 translate<0,0.000000,0>}
cylinder{<46.990000,-0.1,33.020000><46.990000,0.135000,33.020000>5.040400 translate<0,0.000000,0>}}
box{<-0.476200,0,-1.587500><0.476200,0.036000,1.587500> rotate<0,-180.000000,0> translate<46.196300,0.000000,33.020000>}
//C2 silk screen
cylinder{<0,0,0><0,0.036000,0>0.088900 translate<59.690000,0.000000,51.435000>}
cylinder{<0,0,0><0,0.036000,0>0.088900 translate<59.690000,0.000000,52.705000>}
box{<0,0,-0.088900><1.270000,0.036000,0.088900> rotate<0,90.000000,0> translate<59.690000,0.000000,52.705000> }
cylinder{<0,0,0><0,0.036000,0>0.088900 translate<59.055000,0.000000,52.070000>}
cylinder{<0,0,0><0,0.036000,0>0.088900 translate<60.325000,0.000000,52.070000>}
box{<0,0,-0.088900><1.270000,0.036000,0.088900> rotate<0,0.000000,0> translate<59.055000,0.000000,52.070000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<60.642500,0.000000,53.657500>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<62.230000,0.000000,53.657500>}
box{<0,0,-0.076200><1.587500,0.036000,0.076200> rotate<0,0.000000,0> translate<60.642500,0.000000,53.657500> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<62.230000,0.000000,53.657500>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<63.817500,0.000000,53.657500>}
box{<0,0,-0.076200><1.587500,0.036000,0.076200> rotate<0,0.000000,0> translate<62.230000,0.000000,53.657500> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<63.817500,0.000000,53.657500>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<63.817500,0.000000,54.292500>}
box{<0,0,-0.076200><0.635000,0.036000,0.076200> rotate<0,90.000000,0> translate<63.817500,0.000000,54.292500> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<63.817500,0.000000,54.292500>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<60.642500,0.000000,54.292500>}
box{<0,0,-0.076200><3.175000,0.036000,0.076200> rotate<0,0.000000,0> translate<60.642500,0.000000,54.292500> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<60.642500,0.000000,54.292500>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<60.642500,0.000000,53.657500>}
box{<0,0,-0.076200><0.635000,0.036000,0.076200> rotate<0,-90.000000,0> translate<60.642500,0.000000,53.657500> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<62.230000,0.000000,53.657500>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<62.230000,0.000000,52.070000>}
box{<0,0,-0.076200><1.587500,0.036000,0.076200> rotate<0,-90.000000,0> translate<62.230000,0.000000,52.070000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<62.230000,0.000000,55.880000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<62.230000,0.000000,57.150000>}
box{<0,0,-0.076200><1.270000,0.036000,0.076200> rotate<0,90.000000,0> translate<62.230000,0.000000,57.150000> }
difference{
cylinder{<62.230000,0,54.610000><62.230000,0.036000,54.610000>5.218200 translate<0,0.000000,0>}
cylinder{<62.230000,-0.1,54.610000><62.230000,0.135000,54.610000>5.040400 translate<0,0.000000,0>}}
box{<-0.476200,0,-1.587500><0.476200,0.036000,1.587500> rotate<0,-90.000000,0> translate<62.230000,0.000000,55.403700>}
//C3 silk screen
cylinder{<0,0,0><0,0.036000,0>0.088900 translate<39.370000,0.000000,34.925000>}
cylinder{<0,0,0><0,0.036000,0>0.088900 translate<39.370000,0.000000,33.655000>}
box{<0,0,-0.088900><1.270000,0.036000,0.088900> rotate<0,-90.000000,0> translate<39.370000,0.000000,33.655000> }
cylinder{<0,0,0><0,0.036000,0>0.088900 translate<40.005000,0.000000,34.290000>}
cylinder{<0,0,0><0,0.036000,0>0.088900 translate<38.735000,0.000000,34.290000>}
box{<0,0,-0.088900><1.270000,0.036000,0.088900> rotate<0,0.000000,0> translate<38.735000,0.000000,34.290000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<38.417500,0.000000,32.702500>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<36.830000,0.000000,32.702500>}
box{<0,0,-0.076200><1.587500,0.036000,0.076200> rotate<0,0.000000,0> translate<36.830000,0.000000,32.702500> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<36.830000,0.000000,32.702500>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<35.242500,0.000000,32.702500>}
box{<0,0,-0.076200><1.587500,0.036000,0.076200> rotate<0,0.000000,0> translate<35.242500,0.000000,32.702500> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<35.242500,0.000000,32.702500>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<35.242500,0.000000,32.067500>}
box{<0,0,-0.076200><0.635000,0.036000,0.076200> rotate<0,-90.000000,0> translate<35.242500,0.000000,32.067500> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<35.242500,0.000000,32.067500>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<38.417500,0.000000,32.067500>}
box{<0,0,-0.076200><3.175000,0.036000,0.076200> rotate<0,0.000000,0> translate<35.242500,0.000000,32.067500> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<38.417500,0.000000,32.067500>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<38.417500,0.000000,32.702500>}
box{<0,0,-0.076200><0.635000,0.036000,0.076200> rotate<0,90.000000,0> translate<38.417500,0.000000,32.702500> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<36.830000,0.000000,32.702500>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<36.830000,0.000000,34.290000>}
box{<0,0,-0.076200><1.587500,0.036000,0.076200> rotate<0,90.000000,0> translate<36.830000,0.000000,34.290000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<36.830000,0.000000,30.480000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<36.830000,0.000000,29.210000>}
box{<0,0,-0.076200><1.270000,0.036000,0.076200> rotate<0,-90.000000,0> translate<36.830000,0.000000,29.210000> }
difference{
cylinder{<36.830000,0,31.750000><36.830000,0.036000,31.750000>5.218200 translate<0,0.000000,0>}
cylinder{<36.830000,-0.1,31.750000><36.830000,0.135000,31.750000>5.040400 translate<0,0.000000,0>}}
box{<-0.476200,0,-1.587500><0.476200,0.036000,1.587500> rotate<0,-270.000000,0> translate<36.830000,0.000000,30.956300>}
//C4 silk screen
cylinder{<0,0,0><0,0.036000,0>0.088900 translate<34.290000,0.000000,51.435000>}
cylinder{<0,0,0><0,0.036000,0>0.088900 translate<34.290000,0.000000,52.705000>}
box{<0,0,-0.088900><1.270000,0.036000,0.088900> rotate<0,90.000000,0> translate<34.290000,0.000000,52.705000> }
cylinder{<0,0,0><0,0.036000,0>0.088900 translate<33.655000,0.000000,52.070000>}
cylinder{<0,0,0><0,0.036000,0>0.088900 translate<34.925000,0.000000,52.070000>}
box{<0,0,-0.088900><1.270000,0.036000,0.088900> rotate<0,0.000000,0> translate<33.655000,0.000000,52.070000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<35.242500,0.000000,53.657500>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<36.830000,0.000000,53.657500>}
box{<0,0,-0.076200><1.587500,0.036000,0.076200> rotate<0,0.000000,0> translate<35.242500,0.000000,53.657500> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<36.830000,0.000000,53.657500>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<38.417500,0.000000,53.657500>}
box{<0,0,-0.076200><1.587500,0.036000,0.076200> rotate<0,0.000000,0> translate<36.830000,0.000000,53.657500> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<38.417500,0.000000,53.657500>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<38.417500,0.000000,54.292500>}
box{<0,0,-0.076200><0.635000,0.036000,0.076200> rotate<0,90.000000,0> translate<38.417500,0.000000,54.292500> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<38.417500,0.000000,54.292500>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<35.242500,0.000000,54.292500>}
box{<0,0,-0.076200><3.175000,0.036000,0.076200> rotate<0,0.000000,0> translate<35.242500,0.000000,54.292500> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<35.242500,0.000000,54.292500>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<35.242500,0.000000,53.657500>}
box{<0,0,-0.076200><0.635000,0.036000,0.076200> rotate<0,-90.000000,0> translate<35.242500,0.000000,53.657500> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<36.830000,0.000000,53.657500>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<36.830000,0.000000,52.070000>}
box{<0,0,-0.076200><1.587500,0.036000,0.076200> rotate<0,-90.000000,0> translate<36.830000,0.000000,52.070000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<36.830000,0.000000,55.880000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<36.830000,0.000000,57.150000>}
box{<0,0,-0.076200><1.270000,0.036000,0.076200> rotate<0,90.000000,0> translate<36.830000,0.000000,57.150000> }
difference{
cylinder{<36.830000,0,54.610000><36.830000,0.036000,54.610000>5.218200 translate<0,0.000000,0>}
cylinder{<36.830000,-0.1,54.610000><36.830000,0.135000,54.610000>5.040400 translate<0,0.000000,0>}}
box{<-0.476200,0,-1.587500><0.476200,0.036000,1.587500> rotate<0,-90.000000,0> translate<36.830000,0.000000,55.403700>}
//C5 silk screen
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<64.135000,0.000000,14.935200>}
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<64.770000,0.000000,14.935200>}
box{<0,0,-0.152400><0.635000,0.036000,0.152400> rotate<0,0.000000,0> translate<64.135000,0.000000,14.935200> }
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<64.770000,0.000000,14.935200>}
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<65.405000,0.000000,14.935200>}
box{<0,0,-0.152400><0.635000,0.036000,0.152400> rotate<0,0.000000,0> translate<64.770000,0.000000,14.935200> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<64.770000,0.000000,14.935200>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<64.770000,0.000000,13.716000>}
box{<0,0,-0.076200><1.219200,0.036000,0.076200> rotate<0,-90.000000,0> translate<64.770000,0.000000,13.716000> }
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<64.135000,0.000000,15.570200>}
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<64.770000,0.000000,15.570200>}
box{<0,0,-0.152400><0.635000,0.036000,0.152400> rotate<0,0.000000,0> translate<64.135000,0.000000,15.570200> }
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<64.770000,0.000000,15.570200>}
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<65.405000,0.000000,15.570200>}
box{<0,0,-0.152400><0.635000,0.036000,0.152400> rotate<0,0.000000,0> translate<64.770000,0.000000,15.570200> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<64.770000,0.000000,15.570200>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<64.770000,0.000000,16.764000>}
box{<0,0,-0.076200><1.193800,0.036000,0.076200> rotate<0,90.000000,0> translate<64.770000,0.000000,16.764000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<63.246000,0.000000,11.557000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<66.294000,0.000000,11.557000>}
box{<0,0,-0.076200><3.048000,0.036000,0.076200> rotate<0,0.000000,0> translate<63.246000,0.000000,11.557000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<66.548000,0.000000,11.811000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<66.548000,0.000000,18.669000>}
box{<0,0,-0.076200><6.858000,0.036000,0.076200> rotate<0,90.000000,0> translate<66.548000,0.000000,18.669000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<66.294000,0.000000,18.923000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<63.246000,0.000000,18.923000>}
box{<0,0,-0.076200><3.048000,0.036000,0.076200> rotate<0,0.000000,0> translate<63.246000,0.000000,18.923000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<62.992000,0.000000,18.669000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<62.992000,0.000000,11.811000>}
box{<0,0,-0.076200><6.858000,0.036000,0.076200> rotate<0,-90.000000,0> translate<62.992000,0.000000,11.811000> }
object{ARC(0.254000,0.152400,90.000000,180.000000,0.036000) translate<63.246000,0.000000,18.669000>}
object{ARC(0.254000,0.152400,0.000000,90.000000,0.036000) translate<66.294000,0.000000,18.669000>}
object{ARC(0.254000,0.152400,270.000000,360.000000,0.036000) translate<66.294000,0.000000,11.811000>}
object{ARC(0.254000,0.152400,180.000000,270.000000,0.036000) translate<63.246000,0.000000,11.811000>}
//C6 silk screen
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<84.124800,0.000000,13.335000>}
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<84.124800,0.000000,13.970000>}
box{<0,0,-0.152400><0.635000,0.036000,0.152400> rotate<0,90.000000,0> translate<84.124800,0.000000,13.970000> }
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<84.124800,0.000000,13.970000>}
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<84.124800,0.000000,14.605000>}
box{<0,0,-0.152400><0.635000,0.036000,0.152400> rotate<0,90.000000,0> translate<84.124800,0.000000,14.605000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<84.124800,0.000000,13.970000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<85.344000,0.000000,13.970000>}
box{<0,0,-0.076200><1.219200,0.036000,0.076200> rotate<0,0.000000,0> translate<84.124800,0.000000,13.970000> }
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<83.489800,0.000000,13.335000>}
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<83.489800,0.000000,13.970000>}
box{<0,0,-0.152400><0.635000,0.036000,0.152400> rotate<0,90.000000,0> translate<83.489800,0.000000,13.970000> }
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<83.489800,0.000000,13.970000>}
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<83.489800,0.000000,14.605000>}
box{<0,0,-0.152400><0.635000,0.036000,0.152400> rotate<0,90.000000,0> translate<83.489800,0.000000,14.605000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.489800,0.000000,13.970000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<82.296000,0.000000,13.970000>}
box{<0,0,-0.076200><1.193800,0.036000,0.076200> rotate<0,0.000000,0> translate<82.296000,0.000000,13.970000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<87.503000,0.000000,12.446000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<87.503000,0.000000,15.494000>}
box{<0,0,-0.076200><3.048000,0.036000,0.076200> rotate<0,90.000000,0> translate<87.503000,0.000000,15.494000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<87.249000,0.000000,15.748000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<80.391000,0.000000,15.748000>}
box{<0,0,-0.076200><6.858000,0.036000,0.076200> rotate<0,0.000000,0> translate<80.391000,0.000000,15.748000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<80.137000,0.000000,15.494000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<80.137000,0.000000,12.446000>}
box{<0,0,-0.076200><3.048000,0.036000,0.076200> rotate<0,-90.000000,0> translate<80.137000,0.000000,12.446000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<80.391000,0.000000,12.192000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<87.249000,0.000000,12.192000>}
box{<0,0,-0.076200><6.858000,0.036000,0.076200> rotate<0,0.000000,0> translate<80.391000,0.000000,12.192000> }
object{ARC(0.254000,0.152400,180.000000,270.000000,0.036000) translate<80.391000,0.000000,12.446000>}
object{ARC(0.254000,0.152400,90.000000,180.000000,0.036000) translate<80.391000,0.000000,15.494000>}
object{ARC(0.254000,0.152400,0.000000,90.000000,0.036000) translate<87.249000,0.000000,15.494000>}
object{ARC(0.254000,0.152400,270.000000,360.000000,0.036000) translate<87.249000,0.000000,12.446000>}
//C7 silk screen
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<90.805000,0.000000,6.654800>}
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<90.170000,0.000000,6.654800>}
box{<0,0,-0.152400><0.635000,0.036000,0.152400> rotate<0,0.000000,0> translate<90.170000,0.000000,6.654800> }
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<90.170000,0.000000,6.654800>}
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<89.535000,0.000000,6.654800>}
box{<0,0,-0.152400><0.635000,0.036000,0.152400> rotate<0,0.000000,0> translate<89.535000,0.000000,6.654800> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<90.170000,0.000000,6.654800>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<90.170000,0.000000,7.874000>}
box{<0,0,-0.076200><1.219200,0.036000,0.076200> rotate<0,90.000000,0> translate<90.170000,0.000000,7.874000> }
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<90.805000,0.000000,6.019800>}
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<90.170000,0.000000,6.019800>}
box{<0,0,-0.152400><0.635000,0.036000,0.152400> rotate<0,0.000000,0> translate<90.170000,0.000000,6.019800> }
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<90.170000,0.000000,6.019800>}
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<89.535000,0.000000,6.019800>}
box{<0,0,-0.152400><0.635000,0.036000,0.152400> rotate<0,0.000000,0> translate<89.535000,0.000000,6.019800> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<90.170000,0.000000,6.019800>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<90.170000,0.000000,4.826000>}
box{<0,0,-0.076200><1.193800,0.036000,0.076200> rotate<0,-90.000000,0> translate<90.170000,0.000000,4.826000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<91.694000,0.000000,10.033000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<88.646000,0.000000,10.033000>}
box{<0,0,-0.076200><3.048000,0.036000,0.076200> rotate<0,0.000000,0> translate<88.646000,0.000000,10.033000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<88.392000,0.000000,9.779000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<88.392000,0.000000,2.921000>}
box{<0,0,-0.076200><6.858000,0.036000,0.076200> rotate<0,-90.000000,0> translate<88.392000,0.000000,2.921000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<88.646000,0.000000,2.667000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<91.694000,0.000000,2.667000>}
box{<0,0,-0.076200><3.048000,0.036000,0.076200> rotate<0,0.000000,0> translate<88.646000,0.000000,2.667000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<91.948000,0.000000,2.921000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<91.948000,0.000000,9.779000>}
box{<0,0,-0.076200><6.858000,0.036000,0.076200> rotate<0,90.000000,0> translate<91.948000,0.000000,9.779000> }
object{ARC(0.254000,0.152400,270.000000,360.000000,0.036000) translate<91.694000,0.000000,2.921000>}
object{ARC(0.254000,0.152400,180.000000,270.000000,0.036000) translate<88.646000,0.000000,2.921000>}
object{ARC(0.254000,0.152400,90.000000,180.000000,0.036000) translate<88.646000,0.000000,9.779000>}
object{ARC(0.254000,0.152400,0.000000,90.000000,0.036000) translate<91.694000,0.000000,9.779000>}
//C8 silk screen
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<81.915000,0.000000,26.365200>}
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<82.550000,0.000000,26.365200>}
box{<0,0,-0.152400><0.635000,0.036000,0.152400> rotate<0,0.000000,0> translate<81.915000,0.000000,26.365200> }
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<82.550000,0.000000,26.365200>}
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<83.185000,0.000000,26.365200>}
box{<0,0,-0.152400><0.635000,0.036000,0.152400> rotate<0,0.000000,0> translate<82.550000,0.000000,26.365200> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<82.550000,0.000000,26.365200>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<82.550000,0.000000,25.146000>}
box{<0,0,-0.076200><1.219200,0.036000,0.076200> rotate<0,-90.000000,0> translate<82.550000,0.000000,25.146000> }
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<81.915000,0.000000,27.000200>}
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<82.550000,0.000000,27.000200>}
box{<0,0,-0.152400><0.635000,0.036000,0.152400> rotate<0,0.000000,0> translate<81.915000,0.000000,27.000200> }
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<82.550000,0.000000,27.000200>}
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<83.185000,0.000000,27.000200>}
box{<0,0,-0.152400><0.635000,0.036000,0.152400> rotate<0,0.000000,0> translate<82.550000,0.000000,27.000200> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<82.550000,0.000000,27.000200>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<82.550000,0.000000,28.194000>}
box{<0,0,-0.076200><1.193800,0.036000,0.076200> rotate<0,90.000000,0> translate<82.550000,0.000000,28.194000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<81.026000,0.000000,22.987000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<84.074000,0.000000,22.987000>}
box{<0,0,-0.076200><3.048000,0.036000,0.076200> rotate<0,0.000000,0> translate<81.026000,0.000000,22.987000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<84.328000,0.000000,23.241000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<84.328000,0.000000,30.099000>}
box{<0,0,-0.076200><6.858000,0.036000,0.076200> rotate<0,90.000000,0> translate<84.328000,0.000000,30.099000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<84.074000,0.000000,30.353000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<81.026000,0.000000,30.353000>}
box{<0,0,-0.076200><3.048000,0.036000,0.076200> rotate<0,0.000000,0> translate<81.026000,0.000000,30.353000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<80.772000,0.000000,30.099000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<80.772000,0.000000,23.241000>}
box{<0,0,-0.076200><6.858000,0.036000,0.076200> rotate<0,-90.000000,0> translate<80.772000,0.000000,23.241000> }
object{ARC(0.254000,0.152400,90.000000,180.000000,0.036000) translate<81.026000,0.000000,30.099000>}
object{ARC(0.254000,0.152400,0.000000,90.000000,0.036000) translate<84.074000,0.000000,30.099000>}
object{ARC(0.254000,0.152400,270.000000,360.000000,0.036000) translate<84.074000,0.000000,23.241000>}
object{ARC(0.254000,0.152400,180.000000,270.000000,0.036000) translate<81.026000,0.000000,23.241000>}
//C9 silk screen
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<75.234800,0.000000,43.815000>}
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<75.234800,0.000000,44.450000>}
box{<0,0,-0.152400><0.635000,0.036000,0.152400> rotate<0,90.000000,0> translate<75.234800,0.000000,44.450000> }
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<75.234800,0.000000,44.450000>}
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<75.234800,0.000000,45.085000>}
box{<0,0,-0.152400><0.635000,0.036000,0.152400> rotate<0,90.000000,0> translate<75.234800,0.000000,45.085000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<75.234800,0.000000,44.450000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<76.454000,0.000000,44.450000>}
box{<0,0,-0.076200><1.219200,0.036000,0.076200> rotate<0,0.000000,0> translate<75.234800,0.000000,44.450000> }
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<74.599800,0.000000,43.815000>}
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<74.599800,0.000000,44.450000>}
box{<0,0,-0.152400><0.635000,0.036000,0.152400> rotate<0,90.000000,0> translate<74.599800,0.000000,44.450000> }
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<74.599800,0.000000,44.450000>}
cylinder{<0,0,0><0,0.036000,0>0.152400 translate<74.599800,0.000000,45.085000>}
box{<0,0,-0.152400><0.635000,0.036000,0.152400> rotate<0,90.000000,0> translate<74.599800,0.000000,45.085000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<74.599800,0.000000,44.450000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<73.406000,0.000000,44.450000>}
box{<0,0,-0.076200><1.193800,0.036000,0.076200> rotate<0,0.000000,0> translate<73.406000,0.000000,44.450000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<78.613000,0.000000,42.926000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<78.613000,0.000000,45.974000>}
box{<0,0,-0.076200><3.048000,0.036000,0.076200> rotate<0,90.000000,0> translate<78.613000,0.000000,45.974000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<78.359000,0.000000,46.228000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<71.501000,0.000000,46.228000>}
box{<0,0,-0.076200><6.858000,0.036000,0.076200> rotate<0,0.000000,0> translate<71.501000,0.000000,46.228000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<71.247000,0.000000,45.974000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<71.247000,0.000000,42.926000>}
box{<0,0,-0.076200><3.048000,0.036000,0.076200> rotate<0,-90.000000,0> translate<71.247000,0.000000,42.926000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<71.501000,0.000000,42.672000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<78.359000,0.000000,42.672000>}
box{<0,0,-0.076200><6.858000,0.036000,0.076200> rotate<0,0.000000,0> translate<71.501000,0.000000,42.672000> }
object{ARC(0.254000,0.152400,180.000000,270.000000,0.036000) translate<71.501000,0.000000,42.926000>}
object{ARC(0.254000,0.152400,90.000000,180.000000,0.036000) translate<71.501000,0.000000,45.974000>}
object{ARC(0.254000,0.152400,0.000000,90.000000,0.036000) translate<78.359000,0.000000,45.974000>}
object{ARC(0.254000,0.152400,270.000000,360.000000,0.036000) translate<78.359000,0.000000,42.926000>}
//C10 silk screen
cylinder{<0,0,0><0,0.036000,0>0.088900 translate<64.770000,0.000000,42.545000>}
cylinder{<0,0,0><0,0.036000,0>0.088900 translate<64.770000,0.000000,41.275000>}
box{<0,0,-0.088900><1.270000,0.036000,0.088900> rotate<0,-90.000000,0> translate<64.770000,0.000000,41.275000> }
cylinder{<0,0,0><0,0.036000,0>0.088900 translate<65.405000,0.000000,41.910000>}
cylinder{<0,0,0><0,0.036000,0>0.088900 translate<64.135000,0.000000,41.910000>}
box{<0,0,-0.088900><1.270000,0.036000,0.088900> rotate<0,0.000000,0> translate<64.135000,0.000000,41.910000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<63.817500,0.000000,40.322500>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<62.230000,0.000000,40.322500>}
box{<0,0,-0.076200><1.587500,0.036000,0.076200> rotate<0,0.000000,0> translate<62.230000,0.000000,40.322500> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<62.230000,0.000000,40.322500>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<60.642500,0.000000,40.322500>}
box{<0,0,-0.076200><1.587500,0.036000,0.076200> rotate<0,0.000000,0> translate<60.642500,0.000000,40.322500> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<60.642500,0.000000,40.322500>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<60.642500,0.000000,39.687500>}
box{<0,0,-0.076200><0.635000,0.036000,0.076200> rotate<0,-90.000000,0> translate<60.642500,0.000000,39.687500> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<60.642500,0.000000,39.687500>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<63.817500,0.000000,39.687500>}
box{<0,0,-0.076200><3.175000,0.036000,0.076200> rotate<0,0.000000,0> translate<60.642500,0.000000,39.687500> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<63.817500,0.000000,39.687500>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<63.817500,0.000000,40.322500>}
box{<0,0,-0.076200><0.635000,0.036000,0.076200> rotate<0,90.000000,0> translate<63.817500,0.000000,40.322500> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<62.230000,0.000000,40.322500>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<62.230000,0.000000,41.910000>}
box{<0,0,-0.076200><1.587500,0.036000,0.076200> rotate<0,90.000000,0> translate<62.230000,0.000000,41.910000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<62.230000,0.000000,38.100000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<62.230000,0.000000,36.830000>}
box{<0,0,-0.076200><1.270000,0.036000,0.076200> rotate<0,-90.000000,0> translate<62.230000,0.000000,36.830000> }
difference{
cylinder{<62.230000,0,39.370000><62.230000,0.036000,39.370000>5.218200 translate<0,0.000000,0>}
cylinder{<62.230000,-0.1,39.370000><62.230000,0.135000,39.370000>5.040400 translate<0,0.000000,0>}}
box{<-0.476200,0,-1.587500><0.476200,0.036000,1.587500> rotate<0,-270.000000,0> translate<62.230000,0.000000,38.576300>}
//C11 silk screen
cylinder{<0,0,0><0,0.036000,0>0.088900 translate<69.215000,0.000000,57.150000>}
cylinder{<0,0,0><0,0.036000,0>0.088900 translate<70.485000,0.000000,57.150000>}
box{<0,0,-0.088900><1.270000,0.036000,0.088900> rotate<0,0.000000,0> translate<69.215000,0.000000,57.150000> }
cylinder{<0,0,0><0,0.036000,0>0.088900 translate<69.850000,0.000000,57.785000>}
cylinder{<0,0,0><0,0.036000,0>0.088900 translate<69.850000,0.000000,56.515000>}
box{<0,0,-0.088900><1.270000,0.036000,0.088900> rotate<0,-90.000000,0> translate<69.850000,0.000000,56.515000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<71.437500,0.000000,56.197500>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<71.437500,0.000000,54.610000>}
box{<0,0,-0.076200><1.587500,0.036000,0.076200> rotate<0,-90.000000,0> translate<71.437500,0.000000,54.610000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<71.437500,0.000000,54.610000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<71.437500,0.000000,53.022500>}
box{<0,0,-0.076200><1.587500,0.036000,0.076200> rotate<0,-90.000000,0> translate<71.437500,0.000000,53.022500> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<71.437500,0.000000,53.022500>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<72.072500,0.000000,53.022500>}
box{<0,0,-0.076200><0.635000,0.036000,0.076200> rotate<0,0.000000,0> translate<71.437500,0.000000,53.022500> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<72.072500,0.000000,53.022500>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<72.072500,0.000000,56.197500>}
box{<0,0,-0.076200><3.175000,0.036000,0.076200> rotate<0,90.000000,0> translate<72.072500,0.000000,56.197500> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<72.072500,0.000000,56.197500>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<71.437500,0.000000,56.197500>}
box{<0,0,-0.076200><0.635000,0.036000,0.076200> rotate<0,0.000000,0> translate<71.437500,0.000000,56.197500> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<71.437500,0.000000,54.610000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<69.850000,0.000000,54.610000>}
box{<0,0,-0.076200><1.587500,0.036000,0.076200> rotate<0,0.000000,0> translate<69.850000,0.000000,54.610000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<73.660000,0.000000,54.610000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<74.930000,0.000000,54.610000>}
box{<0,0,-0.076200><1.270000,0.036000,0.076200> rotate<0,0.000000,0> translate<73.660000,0.000000,54.610000> }
difference{
cylinder{<72.390000,0,54.610000><72.390000,0.036000,54.610000>5.218200 translate<0,0.000000,0>}
cylinder{<72.390000,-0.1,54.610000><72.390000,0.135000,54.610000>5.040400 translate<0,0.000000,0>}}
box{<-0.476200,0,-1.587500><0.476200,0.036000,1.587500> rotate<0,-0.000000,0> translate<73.183700,0.000000,54.610000>}
//D3 silk screen
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<35.560000,0.000000,25.400000>}
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<36.449000,0.000000,25.400000>}
box{<0,0,-0.254000><0.889000,0.036000,0.254000> rotate<0,0.000000,0> translate<35.560000,0.000000,25.400000> }
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<45.720000,0.000000,25.400000>}
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<44.831000,0.000000,25.400000>}
box{<0,0,-0.254000><0.889000,0.036000,0.254000> rotate<0,0.000000,0> translate<44.831000,0.000000,25.400000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<41.275000,0.000000,25.400000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<40.640000,0.000000,25.400000>}
box{<0,0,-0.076200><0.635000,0.036000,0.076200> rotate<0,0.000000,0> translate<40.640000,0.000000,25.400000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<39.624000,0.000000,24.765000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<39.624000,0.000000,26.035000>}
box{<0,0,-0.076200><1.270000,0.036000,0.076200> rotate<0,90.000000,0> translate<39.624000,0.000000,26.035000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<39.624000,0.000000,26.035000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<40.640000,0.000000,25.400000>}
box{<0,0,-0.076200><1.198116,0.036000,0.076200> rotate<0,32.003271,0> translate<39.624000,0.000000,26.035000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<40.640000,0.000000,25.400000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<39.116000,0.000000,25.400000>}
box{<0,0,-0.076200><1.524000,0.036000,0.076200> rotate<0,0.000000,0> translate<39.116000,0.000000,25.400000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<40.640000,0.000000,25.400000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<39.624000,0.000000,24.765000>}
box{<0,0,-0.076200><1.198116,0.036000,0.076200> rotate<0,-32.003271,0> translate<39.624000,0.000000,24.765000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<40.640000,0.000000,24.765000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<40.640000,0.000000,25.400000>}
box{<0,0,-0.076200><0.635000,0.036000,0.076200> rotate<0,90.000000,0> translate<40.640000,0.000000,25.400000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<40.640000,0.000000,25.400000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<40.640000,0.000000,26.035000>}
box{<0,0,-0.076200><0.635000,0.036000,0.076200> rotate<0,90.000000,0> translate<40.640000,0.000000,26.035000> }
object{ARC(0.254000,0.152400,180.000000,270.000000,0.036000) translate<38.608000,0.000000,24.638000>}
object{ARC(0.254000,0.152400,270.000000,360.000000,0.036000) translate<42.672000,0.000000,24.638000>}
object{ARC(0.254000,0.152400,0.000000,90.000000,0.036000) translate<42.672000,0.000000,26.162000>}
object{ARC(0.254000,0.152400,90.000000,180.000000,0.036000) translate<38.608000,0.000000,26.162000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<38.354000,0.000000,26.162000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<38.354000,0.000000,24.638000>}
box{<0,0,-0.076200><1.524000,0.036000,0.076200> rotate<0,-90.000000,0> translate<38.354000,0.000000,24.638000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<42.926000,0.000000,24.638000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<42.926000,0.000000,26.162000>}
box{<0,0,-0.076200><1.524000,0.036000,0.076200> rotate<0,90.000000,0> translate<42.926000,0.000000,26.162000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<42.672000,0.000000,24.384000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<38.608000,0.000000,24.384000>}
box{<0,0,-0.076200><4.064000,0.036000,0.076200> rotate<0,0.000000,0> translate<38.608000,0.000000,24.384000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<42.672000,0.000000,26.416000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<38.608000,0.000000,26.416000>}
box{<0,0,-0.076200><4.064000,0.036000,0.076200> rotate<0,0.000000,0> translate<38.608000,0.000000,26.416000> }
box{<-0.254000,0,-1.016000><0.254000,0.036000,1.016000> rotate<0,-180.000000,0> translate<42.291000,0.000000,25.400000>}
box{<-0.952500,0,-0.254000><0.952500,0.036000,0.254000> rotate<0,-180.000000,0> translate<37.401500,0.000000,25.400000>}
box{<-0.952500,0,-0.254000><0.952500,0.036000,0.254000> rotate<0,-180.000000,0> translate<43.878500,0.000000,25.400000>}
//D4 silk screen
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<45.720000,0.000000,22.860000>}
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<44.831000,0.000000,22.860000>}
box{<0,0,-0.254000><0.889000,0.036000,0.254000> rotate<0,0.000000,0> translate<44.831000,0.000000,22.860000> }
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<35.560000,0.000000,22.860000>}
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<36.449000,0.000000,22.860000>}
box{<0,0,-0.254000><0.889000,0.036000,0.254000> rotate<0,0.000000,0> translate<35.560000,0.000000,22.860000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<40.005000,0.000000,22.860000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<40.640000,0.000000,22.860000>}
box{<0,0,-0.076200><0.635000,0.036000,0.076200> rotate<0,0.000000,0> translate<40.005000,0.000000,22.860000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<41.656000,0.000000,23.495000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<41.656000,0.000000,22.225000>}
box{<0,0,-0.076200><1.270000,0.036000,0.076200> rotate<0,-90.000000,0> translate<41.656000,0.000000,22.225000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<41.656000,0.000000,22.225000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<40.640000,0.000000,22.860000>}
box{<0,0,-0.076200><1.198116,0.036000,0.076200> rotate<0,32.003271,0> translate<40.640000,0.000000,22.860000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<40.640000,0.000000,22.860000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<42.164000,0.000000,22.860000>}
box{<0,0,-0.076200><1.524000,0.036000,0.076200> rotate<0,0.000000,0> translate<40.640000,0.000000,22.860000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<40.640000,0.000000,22.860000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<41.656000,0.000000,23.495000>}
box{<0,0,-0.076200><1.198116,0.036000,0.076200> rotate<0,-32.003271,0> translate<40.640000,0.000000,22.860000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<40.640000,0.000000,23.495000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<40.640000,0.000000,22.860000>}
box{<0,0,-0.076200><0.635000,0.036000,0.076200> rotate<0,-90.000000,0> translate<40.640000,0.000000,22.860000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<40.640000,0.000000,22.860000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<40.640000,0.000000,22.225000>}
box{<0,0,-0.076200><0.635000,0.036000,0.076200> rotate<0,-90.000000,0> translate<40.640000,0.000000,22.225000> }
object{ARC(0.254000,0.152400,0.000000,90.000000,0.036000) translate<42.672000,0.000000,23.622000>}
object{ARC(0.254000,0.152400,90.000000,180.000000,0.036000) translate<38.608000,0.000000,23.622000>}
object{ARC(0.254000,0.152400,180.000000,270.000000,0.036000) translate<38.608000,0.000000,22.098000>}
object{ARC(0.254000,0.152400,270.000000,360.000000,0.036000) translate<42.672000,0.000000,22.098000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<42.926000,0.000000,22.098000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<42.926000,0.000000,23.622000>}
box{<0,0,-0.076200><1.524000,0.036000,0.076200> rotate<0,90.000000,0> translate<42.926000,0.000000,23.622000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<38.354000,0.000000,23.622000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<38.354000,0.000000,22.098000>}
box{<0,0,-0.076200><1.524000,0.036000,0.076200> rotate<0,-90.000000,0> translate<38.354000,0.000000,22.098000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<38.608000,0.000000,23.876000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<42.672000,0.000000,23.876000>}
box{<0,0,-0.076200><4.064000,0.036000,0.076200> rotate<0,0.000000,0> translate<38.608000,0.000000,23.876000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<38.608000,0.000000,21.844000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<42.672000,0.000000,21.844000>}
box{<0,0,-0.076200><4.064000,0.036000,0.076200> rotate<0,0.000000,0> translate<38.608000,0.000000,21.844000> }
box{<-0.254000,0,-1.016000><0.254000,0.036000,1.016000> rotate<0,-0.000000,0> translate<38.989000,0.000000,22.860000>}
box{<-0.952500,0,-0.254000><0.952500,0.036000,0.254000> rotate<0,-0.000000,0> translate<43.878500,0.000000,22.860000>}
box{<-0.952500,0,-0.254000><0.952500,0.036000,0.254000> rotate<0,-0.000000,0> translate<37.401500,0.000000,22.860000>}
//D5 silk screen
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<35.560000,0.000000,20.320000>}
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<36.449000,0.000000,20.320000>}
box{<0,0,-0.254000><0.889000,0.036000,0.254000> rotate<0,0.000000,0> translate<35.560000,0.000000,20.320000> }
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<45.720000,0.000000,20.320000>}
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<44.831000,0.000000,20.320000>}
box{<0,0,-0.254000><0.889000,0.036000,0.254000> rotate<0,0.000000,0> translate<44.831000,0.000000,20.320000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<41.275000,0.000000,20.320000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<40.640000,0.000000,20.320000>}
box{<0,0,-0.076200><0.635000,0.036000,0.076200> rotate<0,0.000000,0> translate<40.640000,0.000000,20.320000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<39.624000,0.000000,19.685000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<39.624000,0.000000,20.955000>}
box{<0,0,-0.076200><1.270000,0.036000,0.076200> rotate<0,90.000000,0> translate<39.624000,0.000000,20.955000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<39.624000,0.000000,20.955000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<40.640000,0.000000,20.320000>}
box{<0,0,-0.076200><1.198116,0.036000,0.076200> rotate<0,32.003271,0> translate<39.624000,0.000000,20.955000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<40.640000,0.000000,20.320000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<39.116000,0.000000,20.320000>}
box{<0,0,-0.076200><1.524000,0.036000,0.076200> rotate<0,0.000000,0> translate<39.116000,0.000000,20.320000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<40.640000,0.000000,20.320000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<39.624000,0.000000,19.685000>}
box{<0,0,-0.076200><1.198116,0.036000,0.076200> rotate<0,-32.003271,0> translate<39.624000,0.000000,19.685000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<40.640000,0.000000,19.685000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<40.640000,0.000000,20.320000>}
box{<0,0,-0.076200><0.635000,0.036000,0.076200> rotate<0,90.000000,0> translate<40.640000,0.000000,20.320000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<40.640000,0.000000,20.320000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<40.640000,0.000000,20.955000>}
box{<0,0,-0.076200><0.635000,0.036000,0.076200> rotate<0,90.000000,0> translate<40.640000,0.000000,20.955000> }
object{ARC(0.254000,0.152400,180.000000,270.000000,0.036000) translate<38.608000,0.000000,19.558000>}
object{ARC(0.254000,0.152400,270.000000,360.000000,0.036000) translate<42.672000,0.000000,19.558000>}
object{ARC(0.254000,0.152400,0.000000,90.000000,0.036000) translate<42.672000,0.000000,21.082000>}
object{ARC(0.254000,0.152400,90.000000,180.000000,0.036000) translate<38.608000,0.000000,21.082000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<38.354000,0.000000,21.082000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<38.354000,0.000000,19.558000>}
box{<0,0,-0.076200><1.524000,0.036000,0.076200> rotate<0,-90.000000,0> translate<38.354000,0.000000,19.558000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<42.926000,0.000000,19.558000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<42.926000,0.000000,21.082000>}
box{<0,0,-0.076200><1.524000,0.036000,0.076200> rotate<0,90.000000,0> translate<42.926000,0.000000,21.082000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<42.672000,0.000000,19.304000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<38.608000,0.000000,19.304000>}
box{<0,0,-0.076200><4.064000,0.036000,0.076200> rotate<0,0.000000,0> translate<38.608000,0.000000,19.304000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<42.672000,0.000000,21.336000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<38.608000,0.000000,21.336000>}
box{<0,0,-0.076200><4.064000,0.036000,0.076200> rotate<0,0.000000,0> translate<38.608000,0.000000,21.336000> }
box{<-0.254000,0,-1.016000><0.254000,0.036000,1.016000> rotate<0,-180.000000,0> translate<42.291000,0.000000,20.320000>}
box{<-0.952500,0,-0.254000><0.952500,0.036000,0.254000> rotate<0,-180.000000,0> translate<37.401500,0.000000,20.320000>}
box{<-0.952500,0,-0.254000><0.952500,0.036000,0.254000> rotate<0,-180.000000,0> translate<43.878500,0.000000,20.320000>}
//D6 silk screen
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<45.720000,0.000000,17.780000>}
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<44.831000,0.000000,17.780000>}
box{<0,0,-0.254000><0.889000,0.036000,0.254000> rotate<0,0.000000,0> translate<44.831000,0.000000,17.780000> }
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<35.560000,0.000000,17.780000>}
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<36.449000,0.000000,17.780000>}
box{<0,0,-0.254000><0.889000,0.036000,0.254000> rotate<0,0.000000,0> translate<35.560000,0.000000,17.780000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<40.005000,0.000000,17.780000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<40.640000,0.000000,17.780000>}
box{<0,0,-0.076200><0.635000,0.036000,0.076200> rotate<0,0.000000,0> translate<40.005000,0.000000,17.780000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<41.656000,0.000000,18.415000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<41.656000,0.000000,17.145000>}
box{<0,0,-0.076200><1.270000,0.036000,0.076200> rotate<0,-90.000000,0> translate<41.656000,0.000000,17.145000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<41.656000,0.000000,17.145000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<40.640000,0.000000,17.780000>}
box{<0,0,-0.076200><1.198116,0.036000,0.076200> rotate<0,32.003271,0> translate<40.640000,0.000000,17.780000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<40.640000,0.000000,17.780000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<42.164000,0.000000,17.780000>}
box{<0,0,-0.076200><1.524000,0.036000,0.076200> rotate<0,0.000000,0> translate<40.640000,0.000000,17.780000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<40.640000,0.000000,17.780000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<41.656000,0.000000,18.415000>}
box{<0,0,-0.076200><1.198116,0.036000,0.076200> rotate<0,-32.003271,0> translate<40.640000,0.000000,17.780000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<40.640000,0.000000,18.415000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<40.640000,0.000000,17.780000>}
box{<0,0,-0.076200><0.635000,0.036000,0.076200> rotate<0,-90.000000,0> translate<40.640000,0.000000,17.780000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<40.640000,0.000000,17.780000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<40.640000,0.000000,17.145000>}
box{<0,0,-0.076200><0.635000,0.036000,0.076200> rotate<0,-90.000000,0> translate<40.640000,0.000000,17.145000> }
object{ARC(0.254000,0.152400,0.000000,90.000000,0.036000) translate<42.672000,0.000000,18.542000>}
object{ARC(0.254000,0.152400,90.000000,180.000000,0.036000) translate<38.608000,0.000000,18.542000>}
object{ARC(0.254000,0.152400,180.000000,270.000000,0.036000) translate<38.608000,0.000000,17.018000>}
object{ARC(0.254000,0.152400,270.000000,360.000000,0.036000) translate<42.672000,0.000000,17.018000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<42.926000,0.000000,17.018000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<42.926000,0.000000,18.542000>}
box{<0,0,-0.076200><1.524000,0.036000,0.076200> rotate<0,90.000000,0> translate<42.926000,0.000000,18.542000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<38.354000,0.000000,18.542000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<38.354000,0.000000,17.018000>}
box{<0,0,-0.076200><1.524000,0.036000,0.076200> rotate<0,-90.000000,0> translate<38.354000,0.000000,17.018000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<38.608000,0.000000,18.796000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<42.672000,0.000000,18.796000>}
box{<0,0,-0.076200><4.064000,0.036000,0.076200> rotate<0,0.000000,0> translate<38.608000,0.000000,18.796000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<38.608000,0.000000,16.764000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<42.672000,0.000000,16.764000>}
box{<0,0,-0.076200><4.064000,0.036000,0.076200> rotate<0,0.000000,0> translate<38.608000,0.000000,16.764000> }
box{<-0.254000,0,-1.016000><0.254000,0.036000,1.016000> rotate<0,-0.000000,0> translate<38.989000,0.000000,17.780000>}
box{<-0.952500,0,-0.254000><0.952500,0.036000,0.254000> rotate<0,-0.000000,0> translate<43.878500,0.000000,17.780000>}
box{<-0.952500,0,-0.254000><0.952500,0.036000,0.254000> rotate<0,-0.000000,0> translate<37.401500,0.000000,17.780000>}
//D7 silk screen
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<35.560000,0.000000,15.240000>}
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<36.449000,0.000000,15.240000>}
box{<0,0,-0.254000><0.889000,0.036000,0.254000> rotate<0,0.000000,0> translate<35.560000,0.000000,15.240000> }
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<45.720000,0.000000,15.240000>}
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<44.831000,0.000000,15.240000>}
box{<0,0,-0.254000><0.889000,0.036000,0.254000> rotate<0,0.000000,0> translate<44.831000,0.000000,15.240000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<41.275000,0.000000,15.240000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<40.640000,0.000000,15.240000>}
box{<0,0,-0.076200><0.635000,0.036000,0.076200> rotate<0,0.000000,0> translate<40.640000,0.000000,15.240000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<39.624000,0.000000,14.605000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<39.624000,0.000000,15.875000>}
box{<0,0,-0.076200><1.270000,0.036000,0.076200> rotate<0,90.000000,0> translate<39.624000,0.000000,15.875000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<39.624000,0.000000,15.875000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<40.640000,0.000000,15.240000>}
box{<0,0,-0.076200><1.198116,0.036000,0.076200> rotate<0,32.003271,0> translate<39.624000,0.000000,15.875000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<40.640000,0.000000,15.240000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<39.116000,0.000000,15.240000>}
box{<0,0,-0.076200><1.524000,0.036000,0.076200> rotate<0,0.000000,0> translate<39.116000,0.000000,15.240000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<40.640000,0.000000,15.240000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<39.624000,0.000000,14.605000>}
box{<0,0,-0.076200><1.198116,0.036000,0.076200> rotate<0,-32.003271,0> translate<39.624000,0.000000,14.605000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<40.640000,0.000000,14.605000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<40.640000,0.000000,15.240000>}
box{<0,0,-0.076200><0.635000,0.036000,0.076200> rotate<0,90.000000,0> translate<40.640000,0.000000,15.240000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<40.640000,0.000000,15.240000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<40.640000,0.000000,15.875000>}
box{<0,0,-0.076200><0.635000,0.036000,0.076200> rotate<0,90.000000,0> translate<40.640000,0.000000,15.875000> }
object{ARC(0.254000,0.152400,180.000000,270.000000,0.036000) translate<38.608000,0.000000,14.478000>}
object{ARC(0.254000,0.152400,270.000000,360.000000,0.036000) translate<42.672000,0.000000,14.478000>}
object{ARC(0.254000,0.152400,0.000000,90.000000,0.036000) translate<42.672000,0.000000,16.002000>}
object{ARC(0.254000,0.152400,90.000000,180.000000,0.036000) translate<38.608000,0.000000,16.002000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<38.354000,0.000000,16.002000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<38.354000,0.000000,14.478000>}
box{<0,0,-0.076200><1.524000,0.036000,0.076200> rotate<0,-90.000000,0> translate<38.354000,0.000000,14.478000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<42.926000,0.000000,14.478000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<42.926000,0.000000,16.002000>}
box{<0,0,-0.076200><1.524000,0.036000,0.076200> rotate<0,90.000000,0> translate<42.926000,0.000000,16.002000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<42.672000,0.000000,14.224000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<38.608000,0.000000,14.224000>}
box{<0,0,-0.076200><4.064000,0.036000,0.076200> rotate<0,0.000000,0> translate<38.608000,0.000000,14.224000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<42.672000,0.000000,16.256000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<38.608000,0.000000,16.256000>}
box{<0,0,-0.076200><4.064000,0.036000,0.076200> rotate<0,0.000000,0> translate<38.608000,0.000000,16.256000> }
box{<-0.254000,0,-1.016000><0.254000,0.036000,1.016000> rotate<0,-180.000000,0> translate<42.291000,0.000000,15.240000>}
box{<-0.952500,0,-0.254000><0.952500,0.036000,0.254000> rotate<0,-180.000000,0> translate<37.401500,0.000000,15.240000>}
box{<-0.952500,0,-0.254000><0.952500,0.036000,0.254000> rotate<0,-180.000000,0> translate<43.878500,0.000000,15.240000>}
//D8 silk screen
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<45.720000,0.000000,12.700000>}
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<44.831000,0.000000,12.700000>}
box{<0,0,-0.254000><0.889000,0.036000,0.254000> rotate<0,0.000000,0> translate<44.831000,0.000000,12.700000> }
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<35.560000,0.000000,12.700000>}
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<36.449000,0.000000,12.700000>}
box{<0,0,-0.254000><0.889000,0.036000,0.254000> rotate<0,0.000000,0> translate<35.560000,0.000000,12.700000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<40.005000,0.000000,12.700000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<40.640000,0.000000,12.700000>}
box{<0,0,-0.076200><0.635000,0.036000,0.076200> rotate<0,0.000000,0> translate<40.005000,0.000000,12.700000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<41.656000,0.000000,13.335000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<41.656000,0.000000,12.065000>}
box{<0,0,-0.076200><1.270000,0.036000,0.076200> rotate<0,-90.000000,0> translate<41.656000,0.000000,12.065000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<41.656000,0.000000,12.065000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<40.640000,0.000000,12.700000>}
box{<0,0,-0.076200><1.198116,0.036000,0.076200> rotate<0,32.003271,0> translate<40.640000,0.000000,12.700000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<40.640000,0.000000,12.700000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<42.164000,0.000000,12.700000>}
box{<0,0,-0.076200><1.524000,0.036000,0.076200> rotate<0,0.000000,0> translate<40.640000,0.000000,12.700000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<40.640000,0.000000,12.700000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<41.656000,0.000000,13.335000>}
box{<0,0,-0.076200><1.198116,0.036000,0.076200> rotate<0,-32.003271,0> translate<40.640000,0.000000,12.700000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<40.640000,0.000000,13.335000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<40.640000,0.000000,12.700000>}
box{<0,0,-0.076200><0.635000,0.036000,0.076200> rotate<0,-90.000000,0> translate<40.640000,0.000000,12.700000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<40.640000,0.000000,12.700000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<40.640000,0.000000,12.065000>}
box{<0,0,-0.076200><0.635000,0.036000,0.076200> rotate<0,-90.000000,0> translate<40.640000,0.000000,12.065000> }
object{ARC(0.254000,0.152400,0.000000,90.000000,0.036000) translate<42.672000,0.000000,13.462000>}
object{ARC(0.254000,0.152400,90.000000,180.000000,0.036000) translate<38.608000,0.000000,13.462000>}
object{ARC(0.254000,0.152400,180.000000,270.000000,0.036000) translate<38.608000,0.000000,11.938000>}
object{ARC(0.254000,0.152400,270.000000,360.000000,0.036000) translate<42.672000,0.000000,11.938000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<42.926000,0.000000,11.938000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<42.926000,0.000000,13.462000>}
box{<0,0,-0.076200><1.524000,0.036000,0.076200> rotate<0,90.000000,0> translate<42.926000,0.000000,13.462000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<38.354000,0.000000,13.462000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<38.354000,0.000000,11.938000>}
box{<0,0,-0.076200><1.524000,0.036000,0.076200> rotate<0,-90.000000,0> translate<38.354000,0.000000,11.938000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<38.608000,0.000000,13.716000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<42.672000,0.000000,13.716000>}
box{<0,0,-0.076200><4.064000,0.036000,0.076200> rotate<0,0.000000,0> translate<38.608000,0.000000,13.716000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<38.608000,0.000000,11.684000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<42.672000,0.000000,11.684000>}
box{<0,0,-0.076200><4.064000,0.036000,0.076200> rotate<0,0.000000,0> translate<38.608000,0.000000,11.684000> }
box{<-0.254000,0,-1.016000><0.254000,0.036000,1.016000> rotate<0,-0.000000,0> translate<38.989000,0.000000,12.700000>}
box{<-0.952500,0,-0.254000><0.952500,0.036000,0.254000> rotate<0,-0.000000,0> translate<43.878500,0.000000,12.700000>}
box{<-0.952500,0,-0.254000><0.952500,0.036000,0.254000> rotate<0,-0.000000,0> translate<37.401500,0.000000,12.700000>}
//D9 silk screen
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<54.610000,0.000000,10.160000>}
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<55.499000,0.000000,10.160000>}
box{<0,0,-0.254000><0.889000,0.036000,0.254000> rotate<0,0.000000,0> translate<54.610000,0.000000,10.160000> }
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<64.770000,0.000000,10.160000>}
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<63.881000,0.000000,10.160000>}
box{<0,0,-0.254000><0.889000,0.036000,0.254000> rotate<0,0.000000,0> translate<63.881000,0.000000,10.160000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<60.325000,0.000000,10.160000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<59.690000,0.000000,10.160000>}
box{<0,0,-0.076200><0.635000,0.036000,0.076200> rotate<0,0.000000,0> translate<59.690000,0.000000,10.160000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<58.674000,0.000000,9.525000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<58.674000,0.000000,10.795000>}
box{<0,0,-0.076200><1.270000,0.036000,0.076200> rotate<0,90.000000,0> translate<58.674000,0.000000,10.795000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<58.674000,0.000000,10.795000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<59.690000,0.000000,10.160000>}
box{<0,0,-0.076200><1.198116,0.036000,0.076200> rotate<0,32.003271,0> translate<58.674000,0.000000,10.795000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<59.690000,0.000000,10.160000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<58.166000,0.000000,10.160000>}
box{<0,0,-0.076200><1.524000,0.036000,0.076200> rotate<0,0.000000,0> translate<58.166000,0.000000,10.160000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<59.690000,0.000000,10.160000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<58.674000,0.000000,9.525000>}
box{<0,0,-0.076200><1.198116,0.036000,0.076200> rotate<0,-32.003271,0> translate<58.674000,0.000000,9.525000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<59.690000,0.000000,9.525000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<59.690000,0.000000,10.160000>}
box{<0,0,-0.076200><0.635000,0.036000,0.076200> rotate<0,90.000000,0> translate<59.690000,0.000000,10.160000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<59.690000,0.000000,10.160000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<59.690000,0.000000,10.795000>}
box{<0,0,-0.076200><0.635000,0.036000,0.076200> rotate<0,90.000000,0> translate<59.690000,0.000000,10.795000> }
object{ARC(0.254000,0.152400,180.000000,270.000000,0.036000) translate<57.658000,0.000000,9.398000>}
object{ARC(0.254000,0.152400,270.000000,360.000000,0.036000) translate<61.722000,0.000000,9.398000>}
object{ARC(0.254000,0.152400,0.000000,90.000000,0.036000) translate<61.722000,0.000000,10.922000>}
object{ARC(0.254000,0.152400,90.000000,180.000000,0.036000) translate<57.658000,0.000000,10.922000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<57.404000,0.000000,10.922000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<57.404000,0.000000,9.398000>}
box{<0,0,-0.076200><1.524000,0.036000,0.076200> rotate<0,-90.000000,0> translate<57.404000,0.000000,9.398000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<61.976000,0.000000,9.398000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<61.976000,0.000000,10.922000>}
box{<0,0,-0.076200><1.524000,0.036000,0.076200> rotate<0,90.000000,0> translate<61.976000,0.000000,10.922000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<61.722000,0.000000,9.144000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<57.658000,0.000000,9.144000>}
box{<0,0,-0.076200><4.064000,0.036000,0.076200> rotate<0,0.000000,0> translate<57.658000,0.000000,9.144000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<61.722000,0.000000,11.176000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<57.658000,0.000000,11.176000>}
box{<0,0,-0.076200><4.064000,0.036000,0.076200> rotate<0,0.000000,0> translate<57.658000,0.000000,11.176000> }
box{<-0.254000,0,-1.016000><0.254000,0.036000,1.016000> rotate<0,-180.000000,0> translate<61.341000,0.000000,10.160000>}
box{<-0.952500,0,-0.254000><0.952500,0.036000,0.254000> rotate<0,-180.000000,0> translate<56.451500,0.000000,10.160000>}
box{<-0.952500,0,-0.254000><0.952500,0.036000,0.254000> rotate<0,-180.000000,0> translate<62.928500,0.000000,10.160000>}
//D10 silk screen
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<64.770000,0.000000,5.080000>}
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<63.881000,0.000000,5.080000>}
box{<0,0,-0.254000><0.889000,0.036000,0.254000> rotate<0,0.000000,0> translate<63.881000,0.000000,5.080000> }
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<54.610000,0.000000,5.080000>}
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<55.499000,0.000000,5.080000>}
box{<0,0,-0.254000><0.889000,0.036000,0.254000> rotate<0,0.000000,0> translate<54.610000,0.000000,5.080000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<59.055000,0.000000,5.080000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<59.690000,0.000000,5.080000>}
box{<0,0,-0.076200><0.635000,0.036000,0.076200> rotate<0,0.000000,0> translate<59.055000,0.000000,5.080000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<60.706000,0.000000,5.715000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<60.706000,0.000000,4.445000>}
box{<0,0,-0.076200><1.270000,0.036000,0.076200> rotate<0,-90.000000,0> translate<60.706000,0.000000,4.445000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<60.706000,0.000000,4.445000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<59.690000,0.000000,5.080000>}
box{<0,0,-0.076200><1.198116,0.036000,0.076200> rotate<0,32.003271,0> translate<59.690000,0.000000,5.080000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<59.690000,0.000000,5.080000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<61.214000,0.000000,5.080000>}
box{<0,0,-0.076200><1.524000,0.036000,0.076200> rotate<0,0.000000,0> translate<59.690000,0.000000,5.080000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<59.690000,0.000000,5.080000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<60.706000,0.000000,5.715000>}
box{<0,0,-0.076200><1.198116,0.036000,0.076200> rotate<0,-32.003271,0> translate<59.690000,0.000000,5.080000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<59.690000,0.000000,5.715000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<59.690000,0.000000,5.080000>}
box{<0,0,-0.076200><0.635000,0.036000,0.076200> rotate<0,-90.000000,0> translate<59.690000,0.000000,5.080000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<59.690000,0.000000,5.080000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<59.690000,0.000000,4.445000>}
box{<0,0,-0.076200><0.635000,0.036000,0.076200> rotate<0,-90.000000,0> translate<59.690000,0.000000,4.445000> }
object{ARC(0.254000,0.152400,0.000000,90.000000,0.036000) translate<61.722000,0.000000,5.842000>}
object{ARC(0.254000,0.152400,90.000000,180.000000,0.036000) translate<57.658000,0.000000,5.842000>}
object{ARC(0.254000,0.152400,180.000000,270.000000,0.036000) translate<57.658000,0.000000,4.318000>}
object{ARC(0.254000,0.152400,270.000000,360.000000,0.036000) translate<61.722000,0.000000,4.318000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<61.976000,0.000000,4.318000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<61.976000,0.000000,5.842000>}
box{<0,0,-0.076200><1.524000,0.036000,0.076200> rotate<0,90.000000,0> translate<61.976000,0.000000,5.842000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<57.404000,0.000000,5.842000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<57.404000,0.000000,4.318000>}
box{<0,0,-0.076200><1.524000,0.036000,0.076200> rotate<0,-90.000000,0> translate<57.404000,0.000000,4.318000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<57.658000,0.000000,6.096000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<61.722000,0.000000,6.096000>}
box{<0,0,-0.076200><4.064000,0.036000,0.076200> rotate<0,0.000000,0> translate<57.658000,0.000000,6.096000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<57.658000,0.000000,4.064000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<61.722000,0.000000,4.064000>}
box{<0,0,-0.076200><4.064000,0.036000,0.076200> rotate<0,0.000000,0> translate<57.658000,0.000000,4.064000> }
box{<-0.254000,0,-1.016000><0.254000,0.036000,1.016000> rotate<0,-0.000000,0> translate<58.039000,0.000000,5.080000>}
box{<-0.952500,0,-0.254000><0.952500,0.036000,0.254000> rotate<0,-0.000000,0> translate<62.928500,0.000000,5.080000>}
box{<-0.952500,0,-0.254000><0.952500,0.036000,0.254000> rotate<0,-0.000000,0> translate<56.451500,0.000000,5.080000>}
//E silk screen
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<93.980000,0.000000,55.880000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<93.980000,0.000000,55.372000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,-90.000000,0> translate<93.980000,0.000000,55.372000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<93.980000,0.000000,55.880000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<93.472000,0.000000,55.880000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,0.000000,0> translate<93.472000,0.000000,55.880000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<91.440000,0.000000,55.880000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<91.948000,0.000000,55.880000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,0.000000,0> translate<91.440000,0.000000,55.880000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<91.440000,0.000000,55.880000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<91.440000,0.000000,55.372000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,-90.000000,0> translate<91.440000,0.000000,55.372000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<91.440000,0.000000,53.340000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<91.440000,0.000000,53.848000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,90.000000,0> translate<91.440000,0.000000,53.848000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<91.440000,0.000000,53.340000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<91.948000,0.000000,53.340000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,0.000000,0> translate<91.440000,0.000000,53.340000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<93.472000,0.000000,53.340000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<93.980000,0.000000,53.340000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,0.000000,0> translate<93.472000,0.000000,53.340000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<93.980000,0.000000,53.340000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<93.980000,0.000000,53.848000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,90.000000,0> translate<93.980000,0.000000,53.848000> }
difference{
cylinder{<92.710000,0,54.610000><92.710000,0.036000,54.610000>1.092200 translate<0,0.000000,0>}
cylinder{<92.710000,-0.1,54.610000><92.710000,0.135000,54.610000>0.939800 translate<0,0.000000,0>}}
//IC1 silk screen
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<72.009000,0.000000,41.910000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<72.009000,0.000000,24.130000>}
box{<0,0,-0.076200><17.780000,0.036000,0.076200> rotate<0,-90.000000,0> translate<72.009000,0.000000,24.130000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<77.851000,0.000000,24.130000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<77.851000,0.000000,41.910000>}
box{<0,0,-0.076200><17.780000,0.036000,0.076200> rotate<0,90.000000,0> translate<77.851000,0.000000,41.910000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<72.009000,0.000000,41.910000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<77.851000,0.000000,41.910000>}
box{<0,0,-0.076200><5.842000,0.036000,0.076200> rotate<0,0.000000,0> translate<72.009000,0.000000,41.910000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<72.009000,0.000000,24.130000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<73.914000,0.000000,24.130000>}
box{<0,0,-0.076200><1.905000,0.036000,0.076200> rotate<0,0.000000,0> translate<72.009000,0.000000,24.130000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<77.851000,0.000000,24.130000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<75.946000,0.000000,24.130000>}
box{<0,0,-0.076200><1.905000,0.036000,0.076200> rotate<0,0.000000,0> translate<75.946000,0.000000,24.130000> }
object{ARC(1.016000,0.152400,0.000000,180.000000,0.036000) translate<74.930000,0.000000,24.130000>}
//IC2 silk screen
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<77.470000,0.000000,16.891000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<67.310000,0.000000,16.891000>}
box{<0,0,-0.076200><10.160000,0.036000,0.076200> rotate<0,0.000000,0> translate<67.310000,0.000000,16.891000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<67.310000,0.000000,11.049000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<77.470000,0.000000,11.049000>}
box{<0,0,-0.076200><10.160000,0.036000,0.076200> rotate<0,0.000000,0> translate<67.310000,0.000000,11.049000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<77.470000,0.000000,16.891000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<77.470000,0.000000,11.049000>}
box{<0,0,-0.076200><5.842000,0.036000,0.076200> rotate<0,-90.000000,0> translate<77.470000,0.000000,11.049000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<67.310000,0.000000,16.891000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<67.310000,0.000000,14.986000>}
box{<0,0,-0.076200><1.905000,0.036000,0.076200> rotate<0,-90.000000,0> translate<67.310000,0.000000,14.986000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<67.310000,0.000000,11.049000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<67.310000,0.000000,12.954000>}
box{<0,0,-0.076200><1.905000,0.036000,0.076200> rotate<0,90.000000,0> translate<67.310000,0.000000,12.954000> }
object{ARC(1.016000,0.152400,270.000000,450.000000,0.036000) translate<67.310000,0.000000,13.970000>}
//IC3 silk screen
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<96.520000,0.000000,28.321000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<86.360000,0.000000,28.321000>}
box{<0,0,-0.076200><10.160000,0.036000,0.076200> rotate<0,0.000000,0> translate<86.360000,0.000000,28.321000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<86.360000,0.000000,22.479000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<96.520000,0.000000,22.479000>}
box{<0,0,-0.076200><10.160000,0.036000,0.076200> rotate<0,0.000000,0> translate<86.360000,0.000000,22.479000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<96.520000,0.000000,28.321000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<96.520000,0.000000,22.479000>}
box{<0,0,-0.076200><5.842000,0.036000,0.076200> rotate<0,-90.000000,0> translate<96.520000,0.000000,22.479000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<86.360000,0.000000,28.321000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<86.360000,0.000000,26.416000>}
box{<0,0,-0.076200><1.905000,0.036000,0.076200> rotate<0,-90.000000,0> translate<86.360000,0.000000,26.416000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<86.360000,0.000000,22.479000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<86.360000,0.000000,24.384000>}
box{<0,0,-0.076200><1.905000,0.036000,0.076200> rotate<0,90.000000,0> translate<86.360000,0.000000,24.384000> }
object{ARC(1.016000,0.152400,270.000000,450.000000,0.036000) translate<86.360000,0.000000,25.400000>}
//IC4 silk screen
cylinder{<0,0,0><0,0.036000,0>0.088900 translate<44.780200,0.000000,49.276000>}
cylinder{<0,0,0><0,0.036000,0>0.088900 translate<44.780200,0.000000,41.656000>}
box{<0,0,-0.088900><7.620000,0.036000,0.088900> rotate<0,-90.000000,0> translate<44.780200,0.000000,41.656000> }
cylinder{<0,0,0><0,0.036000,0>0.088900 translate<49.403000,0.000000,49.276000>}
cylinder{<0,0,0><0,0.036000,0>0.088900 translate<49.403000,0.000000,39.649400>}
box{<0,0,-0.088900><9.626600,0.036000,0.088900> rotate<0,-90.000000,0> translate<49.403000,0.000000,39.649400> }
cylinder{<0,0,0><0,0.036000,0>0.088900 translate<44.780200,0.000000,41.656000>}
cylinder{<0,0,0><0,0.036000,0>0.088900 translate<46.736000,0.000000,39.649400>}
box{<0,0,-0.088900><2.802070,0.036000,0.088900> rotate<0,45.731503,0> translate<44.780200,0.000000,41.656000> }
cylinder{<0,0,0><0,0.036000,0>0.088900 translate<44.780200,0.000000,49.276000>}
cylinder{<0,0,0><0,0.036000,0>0.088900 translate<49.403000,0.000000,49.276000>}
box{<0,0,-0.088900><4.622800,0.036000,0.088900> rotate<0,0.000000,0> translate<44.780200,0.000000,49.276000> }
cylinder{<0,0,0><0,0.036000,0>0.088900 translate<49.403000,0.000000,39.649400>}
cylinder{<0,0,0><0,0.036000,0>0.088900 translate<46.736000,0.000000,39.649400>}
box{<0,0,-0.088900><2.667000,0.036000,0.088900> rotate<0,0.000000,0> translate<46.736000,0.000000,39.649400> }
difference{
cylinder{<45.542200,0,48.514000><45.542200,0.036000,48.514000>0.431800 translate<0,0.000000,0>}
cylinder{<45.542200,-0.1,48.514000><45.542200,0.135000,48.514000>0.431800 translate<0,0.000000,0>}}
box{<-0.698500,0,-0.254000><0.698500,0.036000,0.254000> rotate<0,-270.000000,0> translate<46.990000,0.000000,40.322500>}
box{<-0.381000,0,-0.254000><0.381000,0.036000,0.254000> rotate<0,-270.000000,0> translate<46.990000,0.000000,43.180000>}
box{<-0.381000,0,-0.254000><0.381000,0.036000,0.254000> rotate<0,-270.000000,0> translate<46.990000,0.000000,45.720000>}
box{<-0.698500,0,-0.254000><0.698500,0.036000,0.254000> rotate<0,-270.000000,0> translate<46.990000,0.000000,48.577500>}
box{<-0.889000,0,-0.254000><0.889000,0.036000,0.254000> rotate<0,-270.000000,0> translate<46.990000,0.000000,46.990000>}
box{<-0.889000,0,-0.254000><0.889000,0.036000,0.254000> rotate<0,-270.000000,0> translate<46.990000,0.000000,44.450000>}
box{<-0.889000,0,-0.254000><0.889000,0.036000,0.254000> rotate<0,-270.000000,0> translate<46.990000,0.000000,41.910000>}
//IC5 silk screen
cylinder{<0,0,0><0,0.036000,0>0.088900 translate<55.118000,0.000000,59.436000>}
cylinder{<0,0,0><0,0.036000,0>0.088900 translate<54.864000,0.000000,59.690000>}
box{<0,0,-0.088900><0.359210,0.036000,0.088900> rotate<0,44.997030,0> translate<54.864000,0.000000,59.690000> }
cylinder{<0,0,0><0,0.036000,0>0.088900 translate<55.118000,0.000000,59.436000>}
cylinder{<0,0,0><0,0.036000,0>0.088900 translate<55.118000,0.000000,49.784000>}
box{<0,0,-0.088900><9.652000,0.036000,0.088900> rotate<0,-90.000000,0> translate<55.118000,0.000000,49.784000> }
cylinder{<0,0,0><0,0.036000,0>0.088900 translate<54.864000,0.000000,49.530000>}
cylinder{<0,0,0><0,0.036000,0>0.088900 translate<55.118000,0.000000,49.784000>}
box{<0,0,-0.088900><0.359210,0.036000,0.088900> rotate<0,-44.997030,0> translate<54.864000,0.000000,49.530000> }
cylinder{<0,0,0><0,0.036000,0>0.088900 translate<51.943000,0.000000,59.690000>}
cylinder{<0,0,0><0,0.036000,0>0.088900 translate<54.864000,0.000000,59.690000>}
box{<0,0,-0.088900><2.921000,0.036000,0.088900> rotate<0,0.000000,0> translate<51.943000,0.000000,59.690000> }
cylinder{<0,0,0><0,0.036000,0>0.088900 translate<54.864000,0.000000,49.530000>}
cylinder{<0,0,0><0,0.036000,0>0.088900 translate<51.943000,0.000000,49.530000>}
box{<0,0,-0.088900><2.921000,0.036000,0.088900> rotate<0,0.000000,0> translate<51.943000,0.000000,49.530000> }
difference{
cylinder{<54.508400,0,49.987200><54.508400,0.036000,49.987200>0.254000 translate<0,0.000000,0>}
cylinder{<54.508400,-0.1,49.987200><54.508400,0.135000,49.987200>0.254000 translate<0,0.000000,0>}}
box{<-0.952500,0,-0.635000><0.952500,0.036000,0.635000> rotate<0,-90.000000,0> translate<51.435000,0.000000,50.228500>}
box{<-0.889000,0,-0.381000><0.889000,0.036000,0.381000> rotate<0,-90.000000,0> translate<51.181000,0.000000,52.070000>}
box{<-0.381000,0,-0.635000><0.381000,0.036000,0.635000> rotate<0,-90.000000,0> translate<51.435000,0.000000,53.340000>}
box{<-0.889000,0,-0.381000><0.889000,0.036000,0.381000> rotate<0,-90.000000,0> translate<51.181000,0.000000,54.610000>}
box{<-0.381000,0,-0.635000><0.381000,0.036000,0.635000> rotate<0,-90.000000,0> translate<51.435000,0.000000,55.880000>}
box{<-0.889000,0,-0.381000><0.889000,0.036000,0.381000> rotate<0,-90.000000,0> translate<51.181000,0.000000,57.150000>}
box{<-0.952500,0,-0.635000><0.952500,0.036000,0.635000> rotate<0,-90.000000,0> translate<51.435000,0.000000,58.991500>}
box{<-0.889000,0,-0.254000><0.889000,0.036000,0.254000> rotate<0,-90.000000,0> translate<51.816000,0.000000,52.070000>}
box{<-0.889000,0,-0.254000><0.889000,0.036000,0.254000> rotate<0,-90.000000,0> translate<51.816000,0.000000,54.610000>}
box{<-0.889000,0,-0.254000><0.889000,0.036000,0.254000> rotate<0,-90.000000,0> translate<51.816000,0.000000,57.150000>}
//IC6 silk screen
object{ARC(2.667000,0.152400,287.149482,398.247121,0.036000) translate<55.880500,0.000000,33.020000>}
object{ARC(2.667000,0.152400,141.752879,252.850518,0.036000) translate<55.879500,0.000000,33.020000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<57.975000,0.000000,34.671000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<53.785000,0.000000,34.671000>}
box{<0,0,-0.076200><4.190000,0.036000,0.076200> rotate<0,0.000000,0> translate<53.785000,0.000000,34.671000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<58.134000,0.000000,33.274000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<56.166000,0.000000,33.274000>}
box{<0,0,-0.076200><1.968000,0.036000,0.076200> rotate<0,0.000000,0> translate<56.166000,0.000000,33.274000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<58.535000,0.000000,33.274000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<58.134000,0.000000,33.274000>}
box{<0,0,-0.076200><0.401000,0.036000,0.076200> rotate<0,0.000000,0> translate<58.134000,0.000000,33.274000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<56.166000,0.000000,33.274000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<55.594000,0.000000,33.274000>}
box{<0,0,-0.076200><0.572000,0.036000,0.076200> rotate<0,0.000000,0> translate<55.594000,0.000000,33.274000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<53.626000,0.000000,33.274000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<53.225000,0.000000,33.274000>}
box{<0,0,-0.076200><0.401000,0.036000,0.076200> rotate<0,0.000000,0> translate<53.225000,0.000000,33.274000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<55.594000,0.000000,33.274000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<53.626000,0.000000,33.274000>}
box{<0,0,-0.076200><1.968000,0.036000,0.076200> rotate<0,0.000000,0> translate<53.626000,0.000000,33.274000> }
object{ARC(2.667000,0.152400,252.850518,287.149482,0.036000) translate<55.880000,0.000000,33.020000>}
//IC7 silk screen
object{ARC(2.667000,0.152400,107.149482,218.247121,0.036000) translate<64.769500,0.000000,46.990000>}
object{ARC(2.667000,0.152400,321.752879,432.850518,0.036000) translate<64.770500,0.000000,46.990000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<62.675000,0.000000,45.339000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<66.865000,0.000000,45.339000>}
box{<0,0,-0.076200><4.190000,0.036000,0.076200> rotate<0,0.000000,0> translate<62.675000,0.000000,45.339000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<62.516000,0.000000,46.736000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<64.484000,0.000000,46.736000>}
box{<0,0,-0.076200><1.968000,0.036000,0.076200> rotate<0,0.000000,0> translate<62.516000,0.000000,46.736000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<62.115000,0.000000,46.736000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<62.516000,0.000000,46.736000>}
box{<0,0,-0.076200><0.401000,0.036000,0.076200> rotate<0,0.000000,0> translate<62.115000,0.000000,46.736000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<64.484000,0.000000,46.736000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<65.056000,0.000000,46.736000>}
box{<0,0,-0.076200><0.572000,0.036000,0.076200> rotate<0,0.000000,0> translate<64.484000,0.000000,46.736000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<67.024000,0.000000,46.736000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<67.425000,0.000000,46.736000>}
box{<0,0,-0.076200><0.401000,0.036000,0.076200> rotate<0,0.000000,0> translate<67.024000,0.000000,46.736000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<65.056000,0.000000,46.736000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<67.024000,0.000000,46.736000>}
box{<0,0,-0.076200><1.968000,0.036000,0.076200> rotate<0,0.000000,0> translate<65.056000,0.000000,46.736000> }
object{ARC(2.667000,0.152400,72.850518,107.149482,0.036000) translate<64.770000,0.000000,46.990000>}
//J1 silk screen
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<61.036200,0.000000,15.240000>}
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<58.343800,0.000000,15.240000>}
box{<0,0,-0.304800><2.692400,0.036000,0.304800> rotate<0,0.000000,0> translate<58.343800,0.000000,15.240000> }
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<57.150000,0.000000,15.240000>}
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<58.293000,0.000000,15.240000>}
box{<0,0,-0.304800><1.143000,0.036000,0.304800> rotate<0,0.000000,0> translate<57.150000,0.000000,15.240000> }
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<62.230000,0.000000,15.240000>}
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<61.087000,0.000000,15.240000>}
box{<0,0,-0.304800><1.143000,0.036000,0.304800> rotate<0,0.000000,0> translate<61.087000,0.000000,15.240000> }
//J2 silk screen
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<80.010000,0.000000,46.913800>}
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<80.010000,0.000000,49.606200>}
box{<0,0,-0.304800><2.692400,0.036000,0.304800> rotate<0,90.000000,0> translate<80.010000,0.000000,49.606200> }
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<80.010000,0.000000,50.800000>}
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<80.010000,0.000000,49.657000>}
box{<0,0,-0.304800><1.143000,0.036000,0.304800> rotate<0,-90.000000,0> translate<80.010000,0.000000,49.657000> }
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<80.010000,0.000000,45.720000>}
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<80.010000,0.000000,46.863000>}
box{<0,0,-0.304800><1.143000,0.036000,0.304800> rotate<0,90.000000,0> translate<80.010000,0.000000,46.863000> }
//J3 silk screen
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<95.173800,0.000000,35.560000>}
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<97.866200,0.000000,35.560000>}
box{<0,0,-0.304800><2.692400,0.036000,0.304800> rotate<0,0.000000,0> translate<95.173800,0.000000,35.560000> }
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<99.060000,0.000000,35.560000>}
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<97.917000,0.000000,35.560000>}
box{<0,0,-0.304800><1.143000,0.036000,0.304800> rotate<0,0.000000,0> translate<97.917000,0.000000,35.560000> }
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<93.980000,0.000000,35.560000>}
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<95.123000,0.000000,35.560000>}
box{<0,0,-0.304800><1.143000,0.036000,0.304800> rotate<0,0.000000,0> translate<93.980000,0.000000,35.560000> }
//J4 silk screen
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<82.550000,0.000000,46.913800>}
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<82.550000,0.000000,49.606200>}
box{<0,0,-0.304800><2.692400,0.036000,0.304800> rotate<0,90.000000,0> translate<82.550000,0.000000,49.606200> }
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<82.550000,0.000000,50.800000>}
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<82.550000,0.000000,49.657000>}
box{<0,0,-0.304800><1.143000,0.036000,0.304800> rotate<0,-90.000000,0> translate<82.550000,0.000000,49.657000> }
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<82.550000,0.000000,45.720000>}
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<82.550000,0.000000,46.863000>}
box{<0,0,-0.304800><1.143000,0.036000,0.304800> rotate<0,90.000000,0> translate<82.550000,0.000000,46.863000> }
//J5 silk screen
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<50.723800,0.000000,38.100000>}
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<53.416200,0.000000,38.100000>}
box{<0,0,-0.304800><2.692400,0.036000,0.304800> rotate<0,0.000000,0> translate<50.723800,0.000000,38.100000> }
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<54.610000,0.000000,38.100000>}
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<53.467000,0.000000,38.100000>}
box{<0,0,-0.304800><1.143000,0.036000,0.304800> rotate<0,0.000000,0> translate<53.467000,0.000000,38.100000> }
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<49.530000,0.000000,38.100000>}
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<50.673000,0.000000,38.100000>}
box{<0,0,-0.304800><1.143000,0.036000,0.304800> rotate<0,0.000000,0> translate<49.530000,0.000000,38.100000> }
//J6 silk screen
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<100.330000,0.000000,7.543800>}
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<100.330000,0.000000,10.236200>}
box{<0,0,-0.304800><2.692400,0.036000,0.304800> rotate<0,90.000000,0> translate<100.330000,0.000000,10.236200> }
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<100.330000,0.000000,11.430000>}
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<100.330000,0.000000,10.287000>}
box{<0,0,-0.304800><1.143000,0.036000,0.304800> rotate<0,-90.000000,0> translate<100.330000,0.000000,10.287000> }
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<100.330000,0.000000,6.350000>}
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<100.330000,0.000000,7.493000>}
box{<0,0,-0.304800><1.143000,0.036000,0.304800> rotate<0,90.000000,0> translate<100.330000,0.000000,7.493000> }
//J7 silk screen
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<85.090000,0.000000,22.783800>}
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<85.090000,0.000000,30.556200>}
box{<0,0,-0.304800><7.772400,0.036000,0.304800> rotate<0,90.000000,0> translate<85.090000,0.000000,30.556200> }
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<85.090000,0.000000,31.750000>}
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<85.090000,0.000000,30.607000>}
box{<0,0,-0.304800><1.143000,0.036000,0.304800> rotate<0,-90.000000,0> translate<85.090000,0.000000,30.607000> }
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<85.090000,0.000000,21.590000>}
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<85.090000,0.000000,22.733000>}
box{<0,0,-0.304800><1.143000,0.036000,0.304800> rotate<0,90.000000,0> translate<85.090000,0.000000,22.733000> }
//J8 silk screen
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<94.056200,0.000000,46.990000>}
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<86.283800,0.000000,46.990000>}
box{<0,0,-0.304800><7.772400,0.036000,0.304800> rotate<0,0.000000,0> translate<86.283800,0.000000,46.990000> }
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<85.090000,0.000000,46.990000>}
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<86.233000,0.000000,46.990000>}
box{<0,0,-0.304800><1.143000,0.036000,0.304800> rotate<0,0.000000,0> translate<85.090000,0.000000,46.990000> }
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<95.250000,0.000000,46.990000>}
cylinder{<0,0,0><0,0.036000,0>0.304800 translate<94.107000,0.000000,46.990000>}
box{<0,0,-0.304800><1.143000,0.036000,0.304800> rotate<0,0.000000,0> translate<94.107000,0.000000,46.990000> }
//JP1 silk screen
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<101.600000,0.000000,40.386000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<101.854000,0.000000,40.640000>}
box{<0,0,-0.076200><0.359210,0.036000,0.076200> rotate<0,-44.997030,0> translate<101.600000,0.000000,40.386000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<101.600000,0.000000,40.386000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<101.346000,0.000000,40.640000>}
box{<0,0,-0.076200><0.359210,0.036000,0.076200> rotate<0,44.997030,0> translate<101.346000,0.000000,40.640000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<101.600000,0.000000,38.354000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<101.854000,0.000000,38.100000>}
box{<0,0,-0.076200><0.359210,0.036000,0.076200> rotate<0,44.997030,0> translate<101.600000,0.000000,38.354000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<101.600000,0.000000,38.354000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<101.346000,0.000000,38.100000>}
box{<0,0,-0.076200><0.359210,0.036000,0.076200> rotate<0,-44.997030,0> translate<101.346000,0.000000,38.100000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<101.346000,0.000000,38.100000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<99.314000,0.000000,38.100000>}
box{<0,0,-0.076200><2.032000,0.036000,0.076200> rotate<0,0.000000,0> translate<99.314000,0.000000,38.100000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<99.060000,0.000000,38.354000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<99.314000,0.000000,38.100000>}
box{<0,0,-0.076200><0.359210,0.036000,0.076200> rotate<0,44.997030,0> translate<99.060000,0.000000,38.354000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<103.886000,0.000000,38.100000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<104.140000,0.000000,38.354000>}
box{<0,0,-0.076200><0.359210,0.036000,0.076200> rotate<0,-44.997030,0> translate<103.886000,0.000000,38.100000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<103.886000,0.000000,38.100000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<101.854000,0.000000,38.100000>}
box{<0,0,-0.076200><2.032000,0.036000,0.076200> rotate<0,0.000000,0> translate<101.854000,0.000000,38.100000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<104.140000,0.000000,38.354000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<104.140000,0.000000,40.386000>}
box{<0,0,-0.076200><2.032000,0.036000,0.076200> rotate<0,90.000000,0> translate<104.140000,0.000000,40.386000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<103.886000,0.000000,40.640000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<104.140000,0.000000,40.386000>}
box{<0,0,-0.076200><0.359210,0.036000,0.076200> rotate<0,44.997030,0> translate<103.886000,0.000000,40.640000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<103.886000,0.000000,40.640000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<101.854000,0.000000,40.640000>}
box{<0,0,-0.076200><2.032000,0.036000,0.076200> rotate<0,0.000000,0> translate<101.854000,0.000000,40.640000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<101.346000,0.000000,40.640000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<99.314000,0.000000,40.640000>}
box{<0,0,-0.076200><2.032000,0.036000,0.076200> rotate<0,0.000000,0> translate<99.314000,0.000000,40.640000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<99.060000,0.000000,40.386000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<99.314000,0.000000,40.640000>}
box{<0,0,-0.076200><0.359210,0.036000,0.076200> rotate<0,-44.997030,0> translate<99.060000,0.000000,40.386000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<99.060000,0.000000,40.386000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<99.060000,0.000000,38.354000>}
box{<0,0,-0.076200><2.032000,0.036000,0.076200> rotate<0,-90.000000,0> translate<99.060000,0.000000,38.354000> }
box{<-0.304800,0,-0.304800><0.304800,0.036000,0.304800> rotate<0,-270.000000,0> translate<102.870000,0.000000,39.370000>}
box{<-0.304800,0,-0.304800><0.304800,0.036000,0.304800> rotate<0,-270.000000,0> translate<100.330000,0.000000,39.370000>}
//JP2 silk screen
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<101.600000,0.000000,20.066000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<101.854000,0.000000,20.320000>}
box{<0,0,-0.076200><0.359210,0.036000,0.076200> rotate<0,-44.997030,0> translate<101.600000,0.000000,20.066000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<101.600000,0.000000,20.066000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<101.346000,0.000000,20.320000>}
box{<0,0,-0.076200><0.359210,0.036000,0.076200> rotate<0,44.997030,0> translate<101.346000,0.000000,20.320000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<101.600000,0.000000,18.034000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<101.854000,0.000000,17.780000>}
box{<0,0,-0.076200><0.359210,0.036000,0.076200> rotate<0,44.997030,0> translate<101.600000,0.000000,18.034000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<101.600000,0.000000,18.034000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<101.346000,0.000000,17.780000>}
box{<0,0,-0.076200><0.359210,0.036000,0.076200> rotate<0,-44.997030,0> translate<101.346000,0.000000,17.780000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<101.346000,0.000000,17.780000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<99.314000,0.000000,17.780000>}
box{<0,0,-0.076200><2.032000,0.036000,0.076200> rotate<0,0.000000,0> translate<99.314000,0.000000,17.780000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<99.060000,0.000000,18.034000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<99.314000,0.000000,17.780000>}
box{<0,0,-0.076200><0.359210,0.036000,0.076200> rotate<0,44.997030,0> translate<99.060000,0.000000,18.034000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<103.886000,0.000000,17.780000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<104.140000,0.000000,18.034000>}
box{<0,0,-0.076200><0.359210,0.036000,0.076200> rotate<0,-44.997030,0> translate<103.886000,0.000000,17.780000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<103.886000,0.000000,17.780000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<101.854000,0.000000,17.780000>}
box{<0,0,-0.076200><2.032000,0.036000,0.076200> rotate<0,0.000000,0> translate<101.854000,0.000000,17.780000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<104.140000,0.000000,18.034000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<104.140000,0.000000,20.066000>}
box{<0,0,-0.076200><2.032000,0.036000,0.076200> rotate<0,90.000000,0> translate<104.140000,0.000000,20.066000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<103.886000,0.000000,20.320000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<104.140000,0.000000,20.066000>}
box{<0,0,-0.076200><0.359210,0.036000,0.076200> rotate<0,44.997030,0> translate<103.886000,0.000000,20.320000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<103.886000,0.000000,20.320000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<101.854000,0.000000,20.320000>}
box{<0,0,-0.076200><2.032000,0.036000,0.076200> rotate<0,0.000000,0> translate<101.854000,0.000000,20.320000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<101.346000,0.000000,20.320000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<99.314000,0.000000,20.320000>}
box{<0,0,-0.076200><2.032000,0.036000,0.076200> rotate<0,0.000000,0> translate<99.314000,0.000000,20.320000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<99.060000,0.000000,20.066000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<99.314000,0.000000,20.320000>}
box{<0,0,-0.076200><0.359210,0.036000,0.076200> rotate<0,-44.997030,0> translate<99.060000,0.000000,20.066000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<99.060000,0.000000,20.066000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<99.060000,0.000000,18.034000>}
box{<0,0,-0.076200><2.032000,0.036000,0.076200> rotate<0,-90.000000,0> translate<99.060000,0.000000,18.034000> }
box{<-0.304800,0,-0.304800><0.304800,0.036000,0.304800> rotate<0,-270.000000,0> translate<102.870000,0.000000,19.050000>}
box{<-0.304800,0,-0.304800><0.304800,0.036000,0.304800> rotate<0,-270.000000,0> translate<100.330000,0.000000,19.050000>}
//JP3 silk screen
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<60.960000,0.000000,26.924000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<60.706000,0.000000,26.670000>}
box{<0,0,-0.076200><0.359210,0.036000,0.076200> rotate<0,-44.997030,0> translate<60.706000,0.000000,26.670000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<60.960000,0.000000,26.924000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<61.214000,0.000000,26.670000>}
box{<0,0,-0.076200><0.359210,0.036000,0.076200> rotate<0,44.997030,0> translate<60.960000,0.000000,26.924000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<60.960000,0.000000,28.956000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<60.706000,0.000000,29.210000>}
box{<0,0,-0.076200><0.359210,0.036000,0.076200> rotate<0,44.997030,0> translate<60.706000,0.000000,29.210000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<60.960000,0.000000,28.956000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<61.214000,0.000000,29.210000>}
box{<0,0,-0.076200><0.359210,0.036000,0.076200> rotate<0,-44.997030,0> translate<60.960000,0.000000,28.956000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<61.214000,0.000000,29.210000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<63.246000,0.000000,29.210000>}
box{<0,0,-0.076200><2.032000,0.036000,0.076200> rotate<0,0.000000,0> translate<61.214000,0.000000,29.210000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<63.500000,0.000000,28.956000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<63.246000,0.000000,29.210000>}
box{<0,0,-0.076200><0.359210,0.036000,0.076200> rotate<0,44.997030,0> translate<63.246000,0.000000,29.210000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<58.674000,0.000000,29.210000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<58.420000,0.000000,28.956000>}
box{<0,0,-0.076200><0.359210,0.036000,0.076200> rotate<0,-44.997030,0> translate<58.420000,0.000000,28.956000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<58.674000,0.000000,29.210000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<60.706000,0.000000,29.210000>}
box{<0,0,-0.076200><2.032000,0.036000,0.076200> rotate<0,0.000000,0> translate<58.674000,0.000000,29.210000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<58.420000,0.000000,28.956000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<58.420000,0.000000,26.924000>}
box{<0,0,-0.076200><2.032000,0.036000,0.076200> rotate<0,-90.000000,0> translate<58.420000,0.000000,26.924000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<58.674000,0.000000,26.670000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<58.420000,0.000000,26.924000>}
box{<0,0,-0.076200><0.359210,0.036000,0.076200> rotate<0,44.997030,0> translate<58.420000,0.000000,26.924000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<58.674000,0.000000,26.670000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<60.706000,0.000000,26.670000>}
box{<0,0,-0.076200><2.032000,0.036000,0.076200> rotate<0,0.000000,0> translate<58.674000,0.000000,26.670000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<61.214000,0.000000,26.670000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<63.246000,0.000000,26.670000>}
box{<0,0,-0.076200><2.032000,0.036000,0.076200> rotate<0,0.000000,0> translate<61.214000,0.000000,26.670000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<63.500000,0.000000,26.924000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<63.246000,0.000000,26.670000>}
box{<0,0,-0.076200><0.359210,0.036000,0.076200> rotate<0,-44.997030,0> translate<63.246000,0.000000,26.670000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<63.500000,0.000000,26.924000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<63.500000,0.000000,28.956000>}
box{<0,0,-0.076200><2.032000,0.036000,0.076200> rotate<0,90.000000,0> translate<63.500000,0.000000,28.956000> }
box{<-0.304800,0,-0.304800><0.304800,0.036000,0.304800> rotate<0,-90.000000,0> translate<59.690000,0.000000,27.940000>}
box{<-0.304800,0,-0.304800><0.304800,0.036000,0.304800> rotate<0,-90.000000,0> translate<62.230000,0.000000,27.940000>}
//JP4 silk screen
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<48.514000,0.000000,11.430000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<50.546000,0.000000,11.430000>}
box{<0,0,-0.076200><2.032000,0.036000,0.076200> rotate<0,0.000000,0> translate<48.514000,0.000000,11.430000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<50.800000,0.000000,4.064000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<50.800000,0.000000,6.096000>}
box{<0,0,-0.076200><2.032000,0.036000,0.076200> rotate<0,90.000000,0> translate<50.800000,0.000000,6.096000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<50.546000,0.000000,6.350000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<50.800000,0.000000,6.096000>}
box{<0,0,-0.076200><0.359210,0.036000,0.076200> rotate<0,44.997030,0> translate<50.546000,0.000000,6.350000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<48.260000,0.000000,4.064000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<48.260000,0.000000,6.096000>}
box{<0,0,-0.076200><2.032000,0.036000,0.076200> rotate<0,90.000000,0> translate<48.260000,0.000000,6.096000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<48.514000,0.000000,6.350000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<48.260000,0.000000,6.096000>}
box{<0,0,-0.076200><0.359210,0.036000,0.076200> rotate<0,-44.997030,0> translate<48.260000,0.000000,6.096000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<48.260000,0.000000,4.064000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<48.514000,0.000000,3.810000>}
box{<0,0,-0.076200><0.359210,0.036000,0.076200> rotate<0,44.997030,0> translate<48.260000,0.000000,4.064000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<50.800000,0.000000,4.064000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<50.546000,0.000000,3.810000>}
box{<0,0,-0.076200><0.359210,0.036000,0.076200> rotate<0,-44.997030,0> translate<50.546000,0.000000,3.810000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<50.546000,0.000000,3.810000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<48.514000,0.000000,3.810000>}
box{<0,0,-0.076200><2.032000,0.036000,0.076200> rotate<0,0.000000,0> translate<48.514000,0.000000,3.810000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<50.800000,0.000000,6.604000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<50.546000,0.000000,6.350000>}
box{<0,0,-0.076200><0.359210,0.036000,0.076200> rotate<0,-44.997030,0> translate<50.546000,0.000000,6.350000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<50.800000,0.000000,6.604000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<50.800000,0.000000,8.636000>}
box{<0,0,-0.076200><2.032000,0.036000,0.076200> rotate<0,90.000000,0> translate<50.800000,0.000000,8.636000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<50.546000,0.000000,8.890000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<50.800000,0.000000,8.636000>}
box{<0,0,-0.076200><0.359210,0.036000,0.076200> rotate<0,44.997030,0> translate<50.546000,0.000000,8.890000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<50.800000,0.000000,9.144000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<50.546000,0.000000,8.890000>}
box{<0,0,-0.076200><0.359210,0.036000,0.076200> rotate<0,-44.997030,0> translate<50.546000,0.000000,8.890000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<50.546000,0.000000,11.430000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<50.800000,0.000000,11.176000>}
box{<0,0,-0.076200><0.359210,0.036000,0.076200> rotate<0,44.997030,0> translate<50.546000,0.000000,11.430000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<50.800000,0.000000,9.144000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<50.800000,0.000000,11.176000>}
box{<0,0,-0.076200><2.032000,0.036000,0.076200> rotate<0,90.000000,0> translate<50.800000,0.000000,11.176000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<48.260000,0.000000,6.604000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<48.514000,0.000000,6.350000>}
box{<0,0,-0.076200><0.359210,0.036000,0.076200> rotate<0,44.997030,0> translate<48.260000,0.000000,6.604000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<48.514000,0.000000,8.890000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<48.260000,0.000000,8.636000>}
box{<0,0,-0.076200><0.359210,0.036000,0.076200> rotate<0,-44.997030,0> translate<48.260000,0.000000,8.636000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<48.260000,0.000000,9.144000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<48.514000,0.000000,8.890000>}
box{<0,0,-0.076200><0.359210,0.036000,0.076200> rotate<0,44.997030,0> translate<48.260000,0.000000,9.144000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<48.514000,0.000000,11.430000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<48.260000,0.000000,11.176000>}
box{<0,0,-0.076200><0.359210,0.036000,0.076200> rotate<0,-44.997030,0> translate<48.260000,0.000000,11.176000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<48.260000,0.000000,6.604000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<48.260000,0.000000,8.636000>}
box{<0,0,-0.076200><2.032000,0.036000,0.076200> rotate<0,90.000000,0> translate<48.260000,0.000000,8.636000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<48.260000,0.000000,9.144000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<48.260000,0.000000,11.176000>}
box{<0,0,-0.076200><2.032000,0.036000,0.076200> rotate<0,90.000000,0> translate<48.260000,0.000000,11.176000> }
box{<-0.304800,0,-0.304800><0.304800,0.036000,0.304800> rotate<0,-270.000000,0> translate<49.530000,0.000000,10.160000>}
box{<-0.304800,0,-0.304800><0.304800,0.036000,0.304800> rotate<0,-270.000000,0> translate<49.530000,0.000000,7.620000>}
box{<-0.304800,0,-0.304800><0.304800,0.036000,0.304800> rotate<0,-270.000000,0> translate<49.530000,0.000000,5.080000>}
//JP5 silk screen
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<43.434000,0.000000,11.430000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<45.466000,0.000000,11.430000>}
box{<0,0,-0.076200><2.032000,0.036000,0.076200> rotate<0,0.000000,0> translate<43.434000,0.000000,11.430000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<45.720000,0.000000,4.064000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<45.720000,0.000000,6.096000>}
box{<0,0,-0.076200><2.032000,0.036000,0.076200> rotate<0,90.000000,0> translate<45.720000,0.000000,6.096000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<45.466000,0.000000,6.350000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<45.720000,0.000000,6.096000>}
box{<0,0,-0.076200><0.359210,0.036000,0.076200> rotate<0,44.997030,0> translate<45.466000,0.000000,6.350000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<43.180000,0.000000,4.064000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<43.180000,0.000000,6.096000>}
box{<0,0,-0.076200><2.032000,0.036000,0.076200> rotate<0,90.000000,0> translate<43.180000,0.000000,6.096000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<43.434000,0.000000,6.350000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<43.180000,0.000000,6.096000>}
box{<0,0,-0.076200><0.359210,0.036000,0.076200> rotate<0,-44.997030,0> translate<43.180000,0.000000,6.096000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<43.180000,0.000000,4.064000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<43.434000,0.000000,3.810000>}
box{<0,0,-0.076200><0.359210,0.036000,0.076200> rotate<0,44.997030,0> translate<43.180000,0.000000,4.064000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<45.720000,0.000000,4.064000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<45.466000,0.000000,3.810000>}
box{<0,0,-0.076200><0.359210,0.036000,0.076200> rotate<0,-44.997030,0> translate<45.466000,0.000000,3.810000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<45.466000,0.000000,3.810000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<43.434000,0.000000,3.810000>}
box{<0,0,-0.076200><2.032000,0.036000,0.076200> rotate<0,0.000000,0> translate<43.434000,0.000000,3.810000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<45.720000,0.000000,6.604000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<45.466000,0.000000,6.350000>}
box{<0,0,-0.076200><0.359210,0.036000,0.076200> rotate<0,-44.997030,0> translate<45.466000,0.000000,6.350000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<45.720000,0.000000,6.604000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<45.720000,0.000000,8.636000>}
box{<0,0,-0.076200><2.032000,0.036000,0.076200> rotate<0,90.000000,0> translate<45.720000,0.000000,8.636000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<45.466000,0.000000,8.890000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<45.720000,0.000000,8.636000>}
box{<0,0,-0.076200><0.359210,0.036000,0.076200> rotate<0,44.997030,0> translate<45.466000,0.000000,8.890000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<45.720000,0.000000,9.144000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<45.466000,0.000000,8.890000>}
box{<0,0,-0.076200><0.359210,0.036000,0.076200> rotate<0,-44.997030,0> translate<45.466000,0.000000,8.890000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<45.466000,0.000000,11.430000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<45.720000,0.000000,11.176000>}
box{<0,0,-0.076200><0.359210,0.036000,0.076200> rotate<0,44.997030,0> translate<45.466000,0.000000,11.430000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<45.720000,0.000000,9.144000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<45.720000,0.000000,11.176000>}
box{<0,0,-0.076200><2.032000,0.036000,0.076200> rotate<0,90.000000,0> translate<45.720000,0.000000,11.176000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<43.180000,0.000000,6.604000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<43.434000,0.000000,6.350000>}
box{<0,0,-0.076200><0.359210,0.036000,0.076200> rotate<0,44.997030,0> translate<43.180000,0.000000,6.604000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<43.434000,0.000000,8.890000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<43.180000,0.000000,8.636000>}
box{<0,0,-0.076200><0.359210,0.036000,0.076200> rotate<0,-44.997030,0> translate<43.180000,0.000000,8.636000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<43.180000,0.000000,9.144000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<43.434000,0.000000,8.890000>}
box{<0,0,-0.076200><0.359210,0.036000,0.076200> rotate<0,44.997030,0> translate<43.180000,0.000000,9.144000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<43.434000,0.000000,11.430000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<43.180000,0.000000,11.176000>}
box{<0,0,-0.076200><0.359210,0.036000,0.076200> rotate<0,-44.997030,0> translate<43.180000,0.000000,11.176000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<43.180000,0.000000,6.604000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<43.180000,0.000000,8.636000>}
box{<0,0,-0.076200><2.032000,0.036000,0.076200> rotate<0,90.000000,0> translate<43.180000,0.000000,8.636000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<43.180000,0.000000,9.144000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<43.180000,0.000000,11.176000>}
box{<0,0,-0.076200><2.032000,0.036000,0.076200> rotate<0,90.000000,0> translate<43.180000,0.000000,11.176000> }
box{<-0.304800,0,-0.304800><0.304800,0.036000,0.304800> rotate<0,-270.000000,0> translate<44.450000,0.000000,10.160000>}
box{<-0.304800,0,-0.304800><0.304800,0.036000,0.304800> rotate<0,-270.000000,0> translate<44.450000,0.000000,7.620000>}
box{<-0.304800,0,-0.304800><0.304800,0.036000,0.304800> rotate<0,-270.000000,0> translate<44.450000,0.000000,5.080000>}
//JP6 silk screen
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<106.680000,0.000000,30.226000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<106.680000,0.000000,28.194000>}
box{<0,0,-0.076200><2.032000,0.036000,0.076200> rotate<0,-90.000000,0> translate<106.680000,0.000000,28.194000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<99.314000,0.000000,27.940000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<101.346000,0.000000,27.940000>}
box{<0,0,-0.076200><2.032000,0.036000,0.076200> rotate<0,0.000000,0> translate<99.314000,0.000000,27.940000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<101.600000,0.000000,28.194000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<101.346000,0.000000,27.940000>}
box{<0,0,-0.076200><0.359210,0.036000,0.076200> rotate<0,-44.997030,0> translate<101.346000,0.000000,27.940000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<99.314000,0.000000,30.480000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<101.346000,0.000000,30.480000>}
box{<0,0,-0.076200><2.032000,0.036000,0.076200> rotate<0,0.000000,0> translate<99.314000,0.000000,30.480000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<101.600000,0.000000,30.226000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<101.346000,0.000000,30.480000>}
box{<0,0,-0.076200><0.359210,0.036000,0.076200> rotate<0,44.997030,0> translate<101.346000,0.000000,30.480000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<99.314000,0.000000,30.480000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<99.060000,0.000000,30.226000>}
box{<0,0,-0.076200><0.359210,0.036000,0.076200> rotate<0,-44.997030,0> translate<99.060000,0.000000,30.226000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<99.314000,0.000000,27.940000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<99.060000,0.000000,28.194000>}
box{<0,0,-0.076200><0.359210,0.036000,0.076200> rotate<0,44.997030,0> translate<99.060000,0.000000,28.194000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<99.060000,0.000000,28.194000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<99.060000,0.000000,30.226000>}
box{<0,0,-0.076200><2.032000,0.036000,0.076200> rotate<0,90.000000,0> translate<99.060000,0.000000,30.226000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<101.854000,0.000000,27.940000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<101.600000,0.000000,28.194000>}
box{<0,0,-0.076200><0.359210,0.036000,0.076200> rotate<0,44.997030,0> translate<101.600000,0.000000,28.194000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<101.854000,0.000000,27.940000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<103.886000,0.000000,27.940000>}
box{<0,0,-0.076200><2.032000,0.036000,0.076200> rotate<0,0.000000,0> translate<101.854000,0.000000,27.940000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<104.140000,0.000000,28.194000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<103.886000,0.000000,27.940000>}
box{<0,0,-0.076200><0.359210,0.036000,0.076200> rotate<0,-44.997030,0> translate<103.886000,0.000000,27.940000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<104.394000,0.000000,27.940000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<104.140000,0.000000,28.194000>}
box{<0,0,-0.076200><0.359210,0.036000,0.076200> rotate<0,44.997030,0> translate<104.140000,0.000000,28.194000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<106.680000,0.000000,28.194000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<106.426000,0.000000,27.940000>}
box{<0,0,-0.076200><0.359210,0.036000,0.076200> rotate<0,-44.997030,0> translate<106.426000,0.000000,27.940000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<104.394000,0.000000,27.940000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<106.426000,0.000000,27.940000>}
box{<0,0,-0.076200><2.032000,0.036000,0.076200> rotate<0,0.000000,0> translate<104.394000,0.000000,27.940000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<101.854000,0.000000,30.480000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<101.600000,0.000000,30.226000>}
box{<0,0,-0.076200><0.359210,0.036000,0.076200> rotate<0,-44.997030,0> translate<101.600000,0.000000,30.226000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<104.140000,0.000000,30.226000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<103.886000,0.000000,30.480000>}
box{<0,0,-0.076200><0.359210,0.036000,0.076200> rotate<0,44.997030,0> translate<103.886000,0.000000,30.480000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<104.394000,0.000000,30.480000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<104.140000,0.000000,30.226000>}
box{<0,0,-0.076200><0.359210,0.036000,0.076200> rotate<0,-44.997030,0> translate<104.140000,0.000000,30.226000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<106.680000,0.000000,30.226000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<106.426000,0.000000,30.480000>}
box{<0,0,-0.076200><0.359210,0.036000,0.076200> rotate<0,44.997030,0> translate<106.426000,0.000000,30.480000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<101.854000,0.000000,30.480000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<103.886000,0.000000,30.480000>}
box{<0,0,-0.076200><2.032000,0.036000,0.076200> rotate<0,0.000000,0> translate<101.854000,0.000000,30.480000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<104.394000,0.000000,30.480000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<106.426000,0.000000,30.480000>}
box{<0,0,-0.076200><2.032000,0.036000,0.076200> rotate<0,0.000000,0> translate<104.394000,0.000000,30.480000> }
box{<-0.304800,0,-0.304800><0.304800,0.036000,0.304800> rotate<0,-180.000000,0> translate<105.410000,0.000000,29.210000>}
box{<-0.304800,0,-0.304800><0.304800,0.036000,0.304800> rotate<0,-180.000000,0> translate<102.870000,0.000000,29.210000>}
box{<-0.304800,0,-0.304800><0.304800,0.036000,0.304800> rotate<0,-180.000000,0> translate<100.330000,0.000000,29.210000>}
//PAD3 silk screen
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<6.350000,0.000000,22.860000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<6.350000,0.000000,22.352000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,-90.000000,0> translate<6.350000,0.000000,22.352000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<6.350000,0.000000,22.860000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<5.842000,0.000000,22.860000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,0.000000,0> translate<5.842000,0.000000,22.860000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<3.810000,0.000000,22.860000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<4.318000,0.000000,22.860000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,0.000000,0> translate<3.810000,0.000000,22.860000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<3.810000,0.000000,22.860000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<3.810000,0.000000,22.352000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,-90.000000,0> translate<3.810000,0.000000,22.352000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<3.810000,0.000000,20.320000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<3.810000,0.000000,20.828000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,90.000000,0> translate<3.810000,0.000000,20.828000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<3.810000,0.000000,20.320000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<4.318000,0.000000,20.320000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,0.000000,0> translate<3.810000,0.000000,20.320000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<5.842000,0.000000,20.320000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<6.350000,0.000000,20.320000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,0.000000,0> translate<5.842000,0.000000,20.320000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<6.350000,0.000000,20.320000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<6.350000,0.000000,20.828000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,90.000000,0> translate<6.350000,0.000000,20.828000> }
difference{
cylinder{<5.080000,0,21.590000><5.080000,0.036000,21.590000>1.092200 translate<0,0.000000,0>}
cylinder{<5.080000,-0.1,21.590000><5.080000,0.135000,21.590000>0.939800 translate<0,0.000000,0>}}
//PAD4 silk screen
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<26.670000,0.000000,22.860000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<26.670000,0.000000,22.352000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,-90.000000,0> translate<26.670000,0.000000,22.352000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<26.670000,0.000000,22.860000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<26.162000,0.000000,22.860000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,0.000000,0> translate<26.162000,0.000000,22.860000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<24.130000,0.000000,22.860000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<24.638000,0.000000,22.860000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,0.000000,0> translate<24.130000,0.000000,22.860000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<24.130000,0.000000,22.860000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<24.130000,0.000000,22.352000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,-90.000000,0> translate<24.130000,0.000000,22.352000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<24.130000,0.000000,20.320000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<24.130000,0.000000,20.828000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,90.000000,0> translate<24.130000,0.000000,20.828000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<24.130000,0.000000,20.320000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<24.638000,0.000000,20.320000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,0.000000,0> translate<24.130000,0.000000,20.320000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<26.162000,0.000000,20.320000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<26.670000,0.000000,20.320000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,0.000000,0> translate<26.162000,0.000000,20.320000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<26.670000,0.000000,20.320000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<26.670000,0.000000,20.828000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,90.000000,0> translate<26.670000,0.000000,20.828000> }
difference{
cylinder{<25.400000,0,21.590000><25.400000,0.036000,21.590000>1.092200 translate<0,0.000000,0>}
cylinder{<25.400000,-0.1,21.590000><25.400000,0.135000,21.590000>0.939800 translate<0,0.000000,0>}}
//PAD6 silk screen
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<3.810000,0.000000,58.420000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<3.810000,0.000000,57.912000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,-90.000000,0> translate<3.810000,0.000000,57.912000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<3.810000,0.000000,58.420000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<3.302000,0.000000,58.420000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,0.000000,0> translate<3.302000,0.000000,58.420000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<1.270000,0.000000,58.420000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<1.778000,0.000000,58.420000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,0.000000,0> translate<1.270000,0.000000,58.420000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<1.270000,0.000000,58.420000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<1.270000,0.000000,57.912000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,-90.000000,0> translate<1.270000,0.000000,57.912000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<1.270000,0.000000,55.880000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<1.270000,0.000000,56.388000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,90.000000,0> translate<1.270000,0.000000,56.388000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<1.270000,0.000000,55.880000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<1.778000,0.000000,55.880000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,0.000000,0> translate<1.270000,0.000000,55.880000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<3.302000,0.000000,55.880000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<3.810000,0.000000,55.880000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,0.000000,0> translate<3.302000,0.000000,55.880000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<3.810000,0.000000,55.880000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<3.810000,0.000000,56.388000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,90.000000,0> translate<3.810000,0.000000,56.388000> }
difference{
cylinder{<2.540000,0,57.150000><2.540000,0.036000,57.150000>1.092200 translate<0,0.000000,0>}
cylinder{<2.540000,-0.1,57.150000><2.540000,0.135000,57.150000>0.939800 translate<0,0.000000,0>}}
//PAD7 silk screen
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<111.760000,0.000000,58.420000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<111.760000,0.000000,57.912000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,-90.000000,0> translate<111.760000,0.000000,57.912000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<111.760000,0.000000,58.420000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<111.252000,0.000000,58.420000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,0.000000,0> translate<111.252000,0.000000,58.420000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<109.220000,0.000000,58.420000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<109.728000,0.000000,58.420000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,0.000000,0> translate<109.220000,0.000000,58.420000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<109.220000,0.000000,58.420000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<109.220000,0.000000,57.912000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,-90.000000,0> translate<109.220000,0.000000,57.912000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<109.220000,0.000000,55.880000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<109.220000,0.000000,56.388000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,90.000000,0> translate<109.220000,0.000000,56.388000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<109.220000,0.000000,55.880000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<109.728000,0.000000,55.880000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,0.000000,0> translate<109.220000,0.000000,55.880000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<111.252000,0.000000,55.880000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<111.760000,0.000000,55.880000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,0.000000,0> translate<111.252000,0.000000,55.880000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<111.760000,0.000000,55.880000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<111.760000,0.000000,56.388000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,90.000000,0> translate<111.760000,0.000000,56.388000> }
difference{
cylinder{<110.490000,0,57.150000><110.490000,0.036000,57.150000>1.092200 translate<0,0.000000,0>}
cylinder{<110.490000,-0.1,57.150000><110.490000,0.135000,57.150000>0.939800 translate<0,0.000000,0>}}
//PAD8 silk screen
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<3.810000,0.000000,3.810000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<3.810000,0.000000,3.302000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,-90.000000,0> translate<3.810000,0.000000,3.302000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<3.810000,0.000000,3.810000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<3.302000,0.000000,3.810000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,0.000000,0> translate<3.302000,0.000000,3.810000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<1.270000,0.000000,3.810000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<1.778000,0.000000,3.810000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,0.000000,0> translate<1.270000,0.000000,3.810000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<1.270000,0.000000,3.810000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<1.270000,0.000000,3.302000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,-90.000000,0> translate<1.270000,0.000000,3.302000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<1.270000,0.000000,1.270000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<1.270000,0.000000,1.778000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,90.000000,0> translate<1.270000,0.000000,1.778000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<1.270000,0.000000,1.270000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<1.778000,0.000000,1.270000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,0.000000,0> translate<1.270000,0.000000,1.270000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<3.302000,0.000000,1.270000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<3.810000,0.000000,1.270000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,0.000000,0> translate<3.302000,0.000000,1.270000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<3.810000,0.000000,1.270000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<3.810000,0.000000,1.778000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,90.000000,0> translate<3.810000,0.000000,1.778000> }
difference{
cylinder{<2.540000,0,2.540000><2.540000,0.036000,2.540000>1.092200 translate<0,0.000000,0>}
cylinder{<2.540000,-0.1,2.540000><2.540000,0.135000,2.540000>0.939800 translate<0,0.000000,0>}}
//PAD9 silk screen
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<111.760000,0.000000,5.080000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<111.760000,0.000000,4.572000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,-90.000000,0> translate<111.760000,0.000000,4.572000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<111.760000,0.000000,5.080000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<111.252000,0.000000,5.080000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,0.000000,0> translate<111.252000,0.000000,5.080000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<109.220000,0.000000,5.080000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<109.728000,0.000000,5.080000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,0.000000,0> translate<109.220000,0.000000,5.080000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<109.220000,0.000000,5.080000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<109.220000,0.000000,4.572000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,-90.000000,0> translate<109.220000,0.000000,4.572000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<109.220000,0.000000,2.540000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<109.220000,0.000000,3.048000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,90.000000,0> translate<109.220000,0.000000,3.048000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<109.220000,0.000000,2.540000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<109.728000,0.000000,2.540000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,0.000000,0> translate<109.220000,0.000000,2.540000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<111.252000,0.000000,2.540000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<111.760000,0.000000,2.540000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,0.000000,0> translate<111.252000,0.000000,2.540000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<111.760000,0.000000,2.540000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<111.760000,0.000000,3.048000>}
box{<0,0,-0.076200><0.508000,0.036000,0.076200> rotate<0,90.000000,0> translate<111.760000,0.000000,3.048000> }
difference{
cylinder{<110.490000,0,3.810000><110.490000,0.036000,3.810000>1.092200 translate<0,0.000000,0>}
cylinder{<110.490000,-0.1,3.810000><110.490000,0.135000,3.810000>0.939800 translate<0,0.000000,0>}}
//Q1 silk screen
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<81.153000,0.000000,43.053000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<81.153000,0.000000,41.910000>}
box{<0,0,-0.076200><1.143000,0.036000,0.076200> rotate<0,-90.000000,0> translate<81.153000,0.000000,41.910000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<81.153000,0.000000,41.910000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<81.407000,0.000000,40.386000>}
box{<0,0,-0.076200><1.545022,0.036000,0.076200> rotate<0,80.532363,0> translate<81.153000,0.000000,41.910000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<88.773000,0.000000,40.386000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<89.027000,0.000000,41.910000>}
box{<0,0,-0.076200><1.545022,0.036000,0.076200> rotate<0,-80.532363,0> translate<88.773000,0.000000,40.386000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<89.027000,0.000000,41.910000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<89.027000,0.000000,43.053000>}
box{<0,0,-0.076200><1.143000,0.036000,0.076200> rotate<0,90.000000,0> translate<89.027000,0.000000,43.053000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<81.407000,0.000000,40.386000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<82.296000,0.000000,40.386000>}
box{<0,0,-0.076200><0.889000,0.036000,0.076200> rotate<0,0.000000,0> translate<81.407000,0.000000,40.386000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<82.296000,0.000000,40.386000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.312000,0.000000,40.386000>}
box{<0,0,-0.076200><1.016000,0.036000,0.076200> rotate<0,0.000000,0> translate<82.296000,0.000000,40.386000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.312000,0.000000,40.386000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<84.582000,0.000000,40.386000>}
box{<0,0,-0.076200><1.270000,0.036000,0.076200> rotate<0,0.000000,0> translate<83.312000,0.000000,40.386000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<84.582000,0.000000,40.386000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<85.598000,0.000000,40.386000>}
box{<0,0,-0.076200><1.016000,0.036000,0.076200> rotate<0,0.000000,0> translate<84.582000,0.000000,40.386000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<85.598000,0.000000,40.386000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<86.868000,0.000000,40.386000>}
box{<0,0,-0.076200><1.270000,0.036000,0.076200> rotate<0,0.000000,0> translate<85.598000,0.000000,40.386000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<86.868000,0.000000,40.386000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<87.884000,0.000000,40.386000>}
box{<0,0,-0.076200><1.016000,0.036000,0.076200> rotate<0,0.000000,0> translate<86.868000,0.000000,40.386000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<87.884000,0.000000,40.386000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<88.773000,0.000000,40.386000>}
box{<0,0,-0.076200><0.889000,0.036000,0.076200> rotate<0,0.000000,0> translate<87.884000,0.000000,40.386000> }
difference{
cylinder{<81.915000,0,41.021000><81.915000,0.036000,41.021000>0.482600 translate<0,0.000000,0>}
cylinder{<81.915000,-0.1,41.021000><81.915000,0.135000,41.021000>0.330200 translate<0,0.000000,0>}}
box{<-0.381000,0,-0.190500><0.381000,0.036000,0.190500> rotate<0,-0.000000,0> translate<81.534000,0.000000,42.989500>}
box{<-0.254000,0,-0.190500><0.254000,0.036000,0.190500> rotate<0,-0.000000,0> translate<83.947000,0.000000,42.989500>}
box{<-0.254000,0,-0.190500><0.254000,0.036000,0.190500> rotate<0,-0.000000,0> translate<86.233000,0.000000,42.989500>}
box{<-0.381000,0,-0.190500><0.381000,0.036000,0.190500> rotate<0,-0.000000,0> translate<88.646000,0.000000,42.989500>}
box{<-0.889000,0,-0.190500><0.889000,0.036000,0.190500> rotate<0,-0.000000,0> translate<82.804000,0.000000,42.989500>}
box{<-0.889000,0,-0.190500><0.889000,0.036000,0.190500> rotate<0,-0.000000,0> translate<85.090000,0.000000,42.989500>}
box{<-0.889000,0,-0.190500><0.889000,0.036000,0.190500> rotate<0,-0.000000,0> translate<87.376000,0.000000,42.989500>}
//Q2 silk screen
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<97.917000,0.000000,40.767000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<97.917000,0.000000,41.910000>}
box{<0,0,-0.076200><1.143000,0.036000,0.076200> rotate<0,90.000000,0> translate<97.917000,0.000000,41.910000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<97.917000,0.000000,41.910000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<97.663000,0.000000,43.434000>}
box{<0,0,-0.076200><1.545022,0.036000,0.076200> rotate<0,80.532363,0> translate<97.663000,0.000000,43.434000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<90.297000,0.000000,43.434000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<90.043000,0.000000,41.910000>}
box{<0,0,-0.076200><1.545022,0.036000,0.076200> rotate<0,-80.532363,0> translate<90.043000,0.000000,41.910000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<90.043000,0.000000,41.910000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<90.043000,0.000000,40.767000>}
box{<0,0,-0.076200><1.143000,0.036000,0.076200> rotate<0,-90.000000,0> translate<90.043000,0.000000,40.767000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<97.663000,0.000000,43.434000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<96.774000,0.000000,43.434000>}
box{<0,0,-0.076200><0.889000,0.036000,0.076200> rotate<0,0.000000,0> translate<96.774000,0.000000,43.434000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<96.774000,0.000000,43.434000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<95.758000,0.000000,43.434000>}
box{<0,0,-0.076200><1.016000,0.036000,0.076200> rotate<0,0.000000,0> translate<95.758000,0.000000,43.434000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<95.758000,0.000000,43.434000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<94.488000,0.000000,43.434000>}
box{<0,0,-0.076200><1.270000,0.036000,0.076200> rotate<0,0.000000,0> translate<94.488000,0.000000,43.434000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<94.488000,0.000000,43.434000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<93.472000,0.000000,43.434000>}
box{<0,0,-0.076200><1.016000,0.036000,0.076200> rotate<0,0.000000,0> translate<93.472000,0.000000,43.434000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<93.472000,0.000000,43.434000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<92.202000,0.000000,43.434000>}
box{<0,0,-0.076200><1.270000,0.036000,0.076200> rotate<0,0.000000,0> translate<92.202000,0.000000,43.434000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<92.202000,0.000000,43.434000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<91.186000,0.000000,43.434000>}
box{<0,0,-0.076200><1.016000,0.036000,0.076200> rotate<0,0.000000,0> translate<91.186000,0.000000,43.434000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<91.186000,0.000000,43.434000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<90.297000,0.000000,43.434000>}
box{<0,0,-0.076200><0.889000,0.036000,0.076200> rotate<0,0.000000,0> translate<90.297000,0.000000,43.434000> }
difference{
cylinder{<97.155000,0,42.799000><97.155000,0.036000,42.799000>0.482600 translate<0,0.000000,0>}
cylinder{<97.155000,-0.1,42.799000><97.155000,0.135000,42.799000>0.330200 translate<0,0.000000,0>}}
box{<-0.381000,0,-0.190500><0.381000,0.036000,0.190500> rotate<0,-180.000000,0> translate<97.536000,0.000000,40.830500>}
box{<-0.254000,0,-0.190500><0.254000,0.036000,0.190500> rotate<0,-180.000000,0> translate<95.123000,0.000000,40.830500>}
box{<-0.254000,0,-0.190500><0.254000,0.036000,0.190500> rotate<0,-180.000000,0> translate<92.837000,0.000000,40.830500>}
box{<-0.381000,0,-0.190500><0.381000,0.036000,0.190500> rotate<0,-180.000000,0> translate<90.424000,0.000000,40.830500>}
box{<-0.889000,0,-0.190500><0.889000,0.036000,0.190500> rotate<0,-180.000000,0> translate<96.266000,0.000000,40.830500>}
box{<-0.889000,0,-0.190500><0.889000,0.036000,0.190500> rotate<0,-180.000000,0> translate<93.980000,0.000000,40.830500>}
box{<-0.889000,0,-0.190500><0.889000,0.036000,0.190500> rotate<0,-180.000000,0> translate<91.694000,0.000000,40.830500>}
//R1 silk screen
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<67.310000,0.000000,21.590000>}
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<67.310000,0.000000,22.479000>}
box{<0,0,-0.254000><0.889000,0.036000,0.254000> rotate<0,90.000000,0> translate<67.310000,0.000000,22.479000> }
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<67.310000,0.000000,29.210000>}
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<67.310000,0.000000,28.321000>}
box{<0,0,-0.254000><0.889000,0.036000,0.254000> rotate<0,-90.000000,0> translate<67.310000,0.000000,28.321000> }
object{ARC(0.254000,0.152400,0.000000,90.000000,0.036000) translate<68.072000,0.000000,27.686000>}
object{ARC(0.254000,0.152400,90.000000,180.000000,0.036000) translate<66.548000,0.000000,27.686000>}
object{ARC(0.254000,0.152400,180.000000,270.000000,0.036000) translate<66.548000,0.000000,23.114000>}
object{ARC(0.254000,0.152400,270.000000,360.000000,0.036000) translate<68.072000,0.000000,23.114000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<66.548000,0.000000,27.940000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<68.072000,0.000000,27.940000>}
box{<0,0,-0.076200><1.524000,0.036000,0.076200> rotate<0,0.000000,0> translate<66.548000,0.000000,27.940000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<68.326000,0.000000,27.686000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<68.326000,0.000000,27.305000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,-90.000000,0> translate<68.326000,0.000000,27.305000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<68.199000,0.000000,27.178000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<68.326000,0.000000,27.305000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,-44.997030,0> translate<68.199000,0.000000,27.178000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<66.294000,0.000000,27.686000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<66.294000,0.000000,27.305000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,-90.000000,0> translate<66.294000,0.000000,27.305000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<66.421000,0.000000,27.178000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<66.294000,0.000000,27.305000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,44.997030,0> translate<66.294000,0.000000,27.305000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<68.199000,0.000000,23.622000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<68.326000,0.000000,23.495000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,44.997030,0> translate<68.199000,0.000000,23.622000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<68.199000,0.000000,23.622000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<68.199000,0.000000,27.178000>}
box{<0,0,-0.076200><3.556000,0.036000,0.076200> rotate<0,90.000000,0> translate<68.199000,0.000000,27.178000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<66.421000,0.000000,23.622000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<66.294000,0.000000,23.495000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,-44.997030,0> translate<66.294000,0.000000,23.495000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<66.421000,0.000000,23.622000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<66.421000,0.000000,27.178000>}
box{<0,0,-0.076200><3.556000,0.036000,0.076200> rotate<0,90.000000,0> translate<66.421000,0.000000,27.178000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<68.326000,0.000000,23.114000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<68.326000,0.000000,23.495000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,90.000000,0> translate<68.326000,0.000000,23.495000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<66.294000,0.000000,23.114000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<66.294000,0.000000,23.495000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,90.000000,0> translate<66.294000,0.000000,23.495000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<66.548000,0.000000,22.860000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<68.072000,0.000000,22.860000>}
box{<0,0,-0.076200><1.524000,0.036000,0.076200> rotate<0,0.000000,0> translate<66.548000,0.000000,22.860000> }
box{<-0.190500,0,-0.254000><0.190500,0.036000,0.254000> rotate<0,-270.000000,0> translate<67.310000,0.000000,22.669500>}
box{<-0.190500,0,-0.254000><0.190500,0.036000,0.254000> rotate<0,-270.000000,0> translate<67.310000,0.000000,28.130500>}
//R2 silk screen
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<57.150000,0.000000,20.320000>}
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<58.039000,0.000000,20.320000>}
box{<0,0,-0.254000><0.889000,0.036000,0.254000> rotate<0,0.000000,0> translate<57.150000,0.000000,20.320000> }
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<64.770000,0.000000,20.320000>}
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<63.881000,0.000000,20.320000>}
box{<0,0,-0.254000><0.889000,0.036000,0.254000> rotate<0,0.000000,0> translate<63.881000,0.000000,20.320000> }
object{ARC(0.254000,0.152400,270.000000,360.000000,0.036000) translate<63.246000,0.000000,19.558000>}
object{ARC(0.254000,0.152400,0.000000,90.000000,0.036000) translate<63.246000,0.000000,21.082000>}
object{ARC(0.254000,0.152400,90.000000,180.000000,0.036000) translate<58.674000,0.000000,21.082000>}
object{ARC(0.254000,0.152400,180.000000,270.000000,0.036000) translate<58.674000,0.000000,19.558000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<63.500000,0.000000,21.082000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<63.500000,0.000000,19.558000>}
box{<0,0,-0.076200><1.524000,0.036000,0.076200> rotate<0,-90.000000,0> translate<63.500000,0.000000,19.558000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<63.246000,0.000000,19.304000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<62.865000,0.000000,19.304000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,0.000000,0> translate<62.865000,0.000000,19.304000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<62.738000,0.000000,19.431000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<62.865000,0.000000,19.304000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,44.997030,0> translate<62.738000,0.000000,19.431000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<63.246000,0.000000,21.336000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<62.865000,0.000000,21.336000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,0.000000,0> translate<62.865000,0.000000,21.336000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<62.738000,0.000000,21.209000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<62.865000,0.000000,21.336000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,-44.997030,0> translate<62.738000,0.000000,21.209000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<59.182000,0.000000,19.431000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<59.055000,0.000000,19.304000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,-44.997030,0> translate<59.055000,0.000000,19.304000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<59.182000,0.000000,19.431000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<62.738000,0.000000,19.431000>}
box{<0,0,-0.076200><3.556000,0.036000,0.076200> rotate<0,0.000000,0> translate<59.182000,0.000000,19.431000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<59.182000,0.000000,21.209000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<59.055000,0.000000,21.336000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,44.997030,0> translate<59.055000,0.000000,21.336000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<59.182000,0.000000,21.209000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<62.738000,0.000000,21.209000>}
box{<0,0,-0.076200><3.556000,0.036000,0.076200> rotate<0,0.000000,0> translate<59.182000,0.000000,21.209000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<58.674000,0.000000,19.304000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<59.055000,0.000000,19.304000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,0.000000,0> translate<58.674000,0.000000,19.304000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<58.674000,0.000000,21.336000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<59.055000,0.000000,21.336000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,0.000000,0> translate<58.674000,0.000000,21.336000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<58.420000,0.000000,21.082000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<58.420000,0.000000,19.558000>}
box{<0,0,-0.076200><1.524000,0.036000,0.076200> rotate<0,-90.000000,0> translate<58.420000,0.000000,19.558000> }
box{<-0.190500,0,-0.254000><0.190500,0.036000,0.254000> rotate<0,-180.000000,0> translate<58.229500,0.000000,20.320000>}
box{<-0.190500,0,-0.254000><0.190500,0.036000,0.254000> rotate<0,-180.000000,0> translate<63.690500,0.000000,20.320000>}
//R3 silk screen
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<57.150000,0.000000,22.860000>}
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<58.039000,0.000000,22.860000>}
box{<0,0,-0.254000><0.889000,0.036000,0.254000> rotate<0,0.000000,0> translate<57.150000,0.000000,22.860000> }
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<64.770000,0.000000,22.860000>}
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<63.881000,0.000000,22.860000>}
box{<0,0,-0.254000><0.889000,0.036000,0.254000> rotate<0,0.000000,0> translate<63.881000,0.000000,22.860000> }
object{ARC(0.254000,0.152400,270.000000,360.000000,0.036000) translate<63.246000,0.000000,22.098000>}
object{ARC(0.254000,0.152400,0.000000,90.000000,0.036000) translate<63.246000,0.000000,23.622000>}
object{ARC(0.254000,0.152400,90.000000,180.000000,0.036000) translate<58.674000,0.000000,23.622000>}
object{ARC(0.254000,0.152400,180.000000,270.000000,0.036000) translate<58.674000,0.000000,22.098000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<63.500000,0.000000,23.622000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<63.500000,0.000000,22.098000>}
box{<0,0,-0.076200><1.524000,0.036000,0.076200> rotate<0,-90.000000,0> translate<63.500000,0.000000,22.098000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<63.246000,0.000000,21.844000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<62.865000,0.000000,21.844000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,0.000000,0> translate<62.865000,0.000000,21.844000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<62.738000,0.000000,21.971000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<62.865000,0.000000,21.844000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,44.997030,0> translate<62.738000,0.000000,21.971000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<63.246000,0.000000,23.876000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<62.865000,0.000000,23.876000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,0.000000,0> translate<62.865000,0.000000,23.876000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<62.738000,0.000000,23.749000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<62.865000,0.000000,23.876000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,-44.997030,0> translate<62.738000,0.000000,23.749000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<59.182000,0.000000,21.971000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<59.055000,0.000000,21.844000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,-44.997030,0> translate<59.055000,0.000000,21.844000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<59.182000,0.000000,21.971000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<62.738000,0.000000,21.971000>}
box{<0,0,-0.076200><3.556000,0.036000,0.076200> rotate<0,0.000000,0> translate<59.182000,0.000000,21.971000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<59.182000,0.000000,23.749000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<59.055000,0.000000,23.876000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,44.997030,0> translate<59.055000,0.000000,23.876000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<59.182000,0.000000,23.749000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<62.738000,0.000000,23.749000>}
box{<0,0,-0.076200><3.556000,0.036000,0.076200> rotate<0,0.000000,0> translate<59.182000,0.000000,23.749000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<58.674000,0.000000,21.844000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<59.055000,0.000000,21.844000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,0.000000,0> translate<58.674000,0.000000,21.844000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<58.674000,0.000000,23.876000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<59.055000,0.000000,23.876000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,0.000000,0> translate<58.674000,0.000000,23.876000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<58.420000,0.000000,23.622000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<58.420000,0.000000,22.098000>}
box{<0,0,-0.076200><1.524000,0.036000,0.076200> rotate<0,-90.000000,0> translate<58.420000,0.000000,22.098000> }
box{<-0.190500,0,-0.254000><0.190500,0.036000,0.254000> rotate<0,-180.000000,0> translate<58.229500,0.000000,22.860000>}
box{<-0.190500,0,-0.254000><0.190500,0.036000,0.254000> rotate<0,-180.000000,0> translate<63.690500,0.000000,22.860000>}
//R4 silk screen
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<54.610000,0.000000,20.320000>}
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<54.610000,0.000000,21.209000>}
box{<0,0,-0.254000><0.889000,0.036000,0.254000> rotate<0,90.000000,0> translate<54.610000,0.000000,21.209000> }
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<54.610000,0.000000,27.940000>}
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<54.610000,0.000000,27.051000>}
box{<0,0,-0.254000><0.889000,0.036000,0.254000> rotate<0,-90.000000,0> translate<54.610000,0.000000,27.051000> }
object{ARC(0.254000,0.152400,0.000000,90.000000,0.036000) translate<55.372000,0.000000,26.416000>}
object{ARC(0.254000,0.152400,90.000000,180.000000,0.036000) translate<53.848000,0.000000,26.416000>}
object{ARC(0.254000,0.152400,180.000000,270.000000,0.036000) translate<53.848000,0.000000,21.844000>}
object{ARC(0.254000,0.152400,270.000000,360.000000,0.036000) translate<55.372000,0.000000,21.844000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<53.848000,0.000000,26.670000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<55.372000,0.000000,26.670000>}
box{<0,0,-0.076200><1.524000,0.036000,0.076200> rotate<0,0.000000,0> translate<53.848000,0.000000,26.670000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<55.626000,0.000000,26.416000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<55.626000,0.000000,26.035000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,-90.000000,0> translate<55.626000,0.000000,26.035000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<55.499000,0.000000,25.908000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<55.626000,0.000000,26.035000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,-44.997030,0> translate<55.499000,0.000000,25.908000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<53.594000,0.000000,26.416000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<53.594000,0.000000,26.035000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,-90.000000,0> translate<53.594000,0.000000,26.035000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<53.721000,0.000000,25.908000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<53.594000,0.000000,26.035000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,44.997030,0> translate<53.594000,0.000000,26.035000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<55.499000,0.000000,22.352000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<55.626000,0.000000,22.225000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,44.997030,0> translate<55.499000,0.000000,22.352000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<55.499000,0.000000,22.352000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<55.499000,0.000000,25.908000>}
box{<0,0,-0.076200><3.556000,0.036000,0.076200> rotate<0,90.000000,0> translate<55.499000,0.000000,25.908000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<53.721000,0.000000,22.352000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<53.594000,0.000000,22.225000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,-44.997030,0> translate<53.594000,0.000000,22.225000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<53.721000,0.000000,22.352000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<53.721000,0.000000,25.908000>}
box{<0,0,-0.076200><3.556000,0.036000,0.076200> rotate<0,90.000000,0> translate<53.721000,0.000000,25.908000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<55.626000,0.000000,21.844000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<55.626000,0.000000,22.225000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,90.000000,0> translate<55.626000,0.000000,22.225000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<53.594000,0.000000,21.844000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<53.594000,0.000000,22.225000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,90.000000,0> translate<53.594000,0.000000,22.225000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<53.848000,0.000000,21.590000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<55.372000,0.000000,21.590000>}
box{<0,0,-0.076200><1.524000,0.036000,0.076200> rotate<0,0.000000,0> translate<53.848000,0.000000,21.590000> }
box{<-0.190500,0,-0.254000><0.190500,0.036000,0.254000> rotate<0,-270.000000,0> translate<54.610000,0.000000,21.399500>}
box{<-0.190500,0,-0.254000><0.190500,0.036000,0.254000> rotate<0,-270.000000,0> translate<54.610000,0.000000,26.860500>}
//R5 silk screen
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<52.070000,0.000000,20.320000>}
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<52.070000,0.000000,21.209000>}
box{<0,0,-0.254000><0.889000,0.036000,0.254000> rotate<0,90.000000,0> translate<52.070000,0.000000,21.209000> }
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<52.070000,0.000000,27.940000>}
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<52.070000,0.000000,27.051000>}
box{<0,0,-0.254000><0.889000,0.036000,0.254000> rotate<0,-90.000000,0> translate<52.070000,0.000000,27.051000> }
object{ARC(0.254000,0.152400,0.000000,90.000000,0.036000) translate<52.832000,0.000000,26.416000>}
object{ARC(0.254000,0.152400,90.000000,180.000000,0.036000) translate<51.308000,0.000000,26.416000>}
object{ARC(0.254000,0.152400,180.000000,270.000000,0.036000) translate<51.308000,0.000000,21.844000>}
object{ARC(0.254000,0.152400,270.000000,360.000000,0.036000) translate<52.832000,0.000000,21.844000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<51.308000,0.000000,26.670000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<52.832000,0.000000,26.670000>}
box{<0,0,-0.076200><1.524000,0.036000,0.076200> rotate<0,0.000000,0> translate<51.308000,0.000000,26.670000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<53.086000,0.000000,26.416000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<53.086000,0.000000,26.035000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,-90.000000,0> translate<53.086000,0.000000,26.035000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<52.959000,0.000000,25.908000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<53.086000,0.000000,26.035000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,-44.997030,0> translate<52.959000,0.000000,25.908000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<51.054000,0.000000,26.416000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<51.054000,0.000000,26.035000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,-90.000000,0> translate<51.054000,0.000000,26.035000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<51.181000,0.000000,25.908000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<51.054000,0.000000,26.035000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,44.997030,0> translate<51.054000,0.000000,26.035000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<52.959000,0.000000,22.352000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<53.086000,0.000000,22.225000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,44.997030,0> translate<52.959000,0.000000,22.352000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<52.959000,0.000000,22.352000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<52.959000,0.000000,25.908000>}
box{<0,0,-0.076200><3.556000,0.036000,0.076200> rotate<0,90.000000,0> translate<52.959000,0.000000,25.908000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<51.181000,0.000000,22.352000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<51.054000,0.000000,22.225000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,-44.997030,0> translate<51.054000,0.000000,22.225000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<51.181000,0.000000,22.352000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<51.181000,0.000000,25.908000>}
box{<0,0,-0.076200><3.556000,0.036000,0.076200> rotate<0,90.000000,0> translate<51.181000,0.000000,25.908000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<53.086000,0.000000,21.844000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<53.086000,0.000000,22.225000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,90.000000,0> translate<53.086000,0.000000,22.225000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<51.054000,0.000000,21.844000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<51.054000,0.000000,22.225000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,90.000000,0> translate<51.054000,0.000000,22.225000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<51.308000,0.000000,21.590000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<52.832000,0.000000,21.590000>}
box{<0,0,-0.076200><1.524000,0.036000,0.076200> rotate<0,0.000000,0> translate<51.308000,0.000000,21.590000> }
box{<-0.190500,0,-0.254000><0.190500,0.036000,0.254000> rotate<0,-270.000000,0> translate<52.070000,0.000000,21.399500>}
box{<-0.190500,0,-0.254000><0.190500,0.036000,0.254000> rotate<0,-270.000000,0> translate<52.070000,0.000000,26.860500>}
//R6 silk screen
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<82.550000,0.000000,3.810000>}
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<82.550000,0.000000,4.699000>}
box{<0,0,-0.254000><0.889000,0.036000,0.254000> rotate<0,90.000000,0> translate<82.550000,0.000000,4.699000> }
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<82.550000,0.000000,11.430000>}
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<82.550000,0.000000,10.541000>}
box{<0,0,-0.254000><0.889000,0.036000,0.254000> rotate<0,-90.000000,0> translate<82.550000,0.000000,10.541000> }
object{ARC(0.254000,0.152400,0.000000,90.000000,0.036000) translate<83.312000,0.000000,9.906000>}
object{ARC(0.254000,0.152400,90.000000,180.000000,0.036000) translate<81.788000,0.000000,9.906000>}
object{ARC(0.254000,0.152400,180.000000,270.000000,0.036000) translate<81.788000,0.000000,5.334000>}
object{ARC(0.254000,0.152400,270.000000,360.000000,0.036000) translate<83.312000,0.000000,5.334000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<81.788000,0.000000,10.160000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.312000,0.000000,10.160000>}
box{<0,0,-0.076200><1.524000,0.036000,0.076200> rotate<0,0.000000,0> translate<81.788000,0.000000,10.160000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.566000,0.000000,9.906000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.566000,0.000000,9.525000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,-90.000000,0> translate<83.566000,0.000000,9.525000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.439000,0.000000,9.398000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.566000,0.000000,9.525000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,-44.997030,0> translate<83.439000,0.000000,9.398000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<81.534000,0.000000,9.906000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<81.534000,0.000000,9.525000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,-90.000000,0> translate<81.534000,0.000000,9.525000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<81.661000,0.000000,9.398000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<81.534000,0.000000,9.525000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,44.997030,0> translate<81.534000,0.000000,9.525000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.439000,0.000000,5.842000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.566000,0.000000,5.715000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,44.997030,0> translate<83.439000,0.000000,5.842000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.439000,0.000000,5.842000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.439000,0.000000,9.398000>}
box{<0,0,-0.076200><3.556000,0.036000,0.076200> rotate<0,90.000000,0> translate<83.439000,0.000000,9.398000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<81.661000,0.000000,5.842000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<81.534000,0.000000,5.715000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,-44.997030,0> translate<81.534000,0.000000,5.715000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<81.661000,0.000000,5.842000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<81.661000,0.000000,9.398000>}
box{<0,0,-0.076200><3.556000,0.036000,0.076200> rotate<0,90.000000,0> translate<81.661000,0.000000,9.398000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.566000,0.000000,5.334000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.566000,0.000000,5.715000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,90.000000,0> translate<83.566000,0.000000,5.715000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<81.534000,0.000000,5.334000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<81.534000,0.000000,5.715000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,90.000000,0> translate<81.534000,0.000000,5.715000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<81.788000,0.000000,5.080000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.312000,0.000000,5.080000>}
box{<0,0,-0.076200><1.524000,0.036000,0.076200> rotate<0,0.000000,0> translate<81.788000,0.000000,5.080000> }
box{<-0.190500,0,-0.254000><0.190500,0.036000,0.254000> rotate<0,-270.000000,0> translate<82.550000,0.000000,4.889500>}
box{<-0.190500,0,-0.254000><0.190500,0.036000,0.254000> rotate<0,-270.000000,0> translate<82.550000,0.000000,10.350500>}
//R7 silk screen
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<76.200000,0.000000,5.080000>}
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<75.311000,0.000000,5.080000>}
box{<0,0,-0.254000><0.889000,0.036000,0.254000> rotate<0,0.000000,0> translate<75.311000,0.000000,5.080000> }
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<68.580000,0.000000,5.080000>}
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<69.469000,0.000000,5.080000>}
box{<0,0,-0.254000><0.889000,0.036000,0.254000> rotate<0,0.000000,0> translate<68.580000,0.000000,5.080000> }
object{ARC(0.254000,0.152400,90.000000,180.000000,0.036000) translate<70.104000,0.000000,5.842000>}
object{ARC(0.254000,0.152400,180.000000,270.000000,0.036000) translate<70.104000,0.000000,4.318000>}
object{ARC(0.254000,0.152400,270.000000,360.000000,0.036000) translate<74.676000,0.000000,4.318000>}
object{ARC(0.254000,0.152400,0.000000,90.000000,0.036000) translate<74.676000,0.000000,5.842000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<69.850000,0.000000,4.318000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<69.850000,0.000000,5.842000>}
box{<0,0,-0.076200><1.524000,0.036000,0.076200> rotate<0,90.000000,0> translate<69.850000,0.000000,5.842000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<70.104000,0.000000,6.096000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<70.485000,0.000000,6.096000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,0.000000,0> translate<70.104000,0.000000,6.096000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<70.612000,0.000000,5.969000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<70.485000,0.000000,6.096000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,44.997030,0> translate<70.485000,0.000000,6.096000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<70.104000,0.000000,4.064000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<70.485000,0.000000,4.064000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,0.000000,0> translate<70.104000,0.000000,4.064000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<70.612000,0.000000,4.191000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<70.485000,0.000000,4.064000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,-44.997030,0> translate<70.485000,0.000000,4.064000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<74.168000,0.000000,5.969000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<74.295000,0.000000,6.096000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,-44.997030,0> translate<74.168000,0.000000,5.969000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<74.168000,0.000000,5.969000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<70.612000,0.000000,5.969000>}
box{<0,0,-0.076200><3.556000,0.036000,0.076200> rotate<0,0.000000,0> translate<70.612000,0.000000,5.969000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<74.168000,0.000000,4.191000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<74.295000,0.000000,4.064000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,44.997030,0> translate<74.168000,0.000000,4.191000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<74.168000,0.000000,4.191000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<70.612000,0.000000,4.191000>}
box{<0,0,-0.076200><3.556000,0.036000,0.076200> rotate<0,0.000000,0> translate<70.612000,0.000000,4.191000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<74.676000,0.000000,6.096000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<74.295000,0.000000,6.096000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,0.000000,0> translate<74.295000,0.000000,6.096000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<74.676000,0.000000,4.064000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<74.295000,0.000000,4.064000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,0.000000,0> translate<74.295000,0.000000,4.064000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<74.930000,0.000000,4.318000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<74.930000,0.000000,5.842000>}
box{<0,0,-0.076200><1.524000,0.036000,0.076200> rotate<0,90.000000,0> translate<74.930000,0.000000,5.842000> }
box{<-0.190500,0,-0.254000><0.190500,0.036000,0.254000> rotate<0,-0.000000,0> translate<75.120500,0.000000,5.080000>}
box{<-0.190500,0,-0.254000><0.190500,0.036000,0.254000> rotate<0,-0.000000,0> translate<69.659500,0.000000,5.080000>}
//R8 silk screen
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<78.740000,0.000000,12.700000>}
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<78.740000,0.000000,11.811000>}
box{<0,0,-0.254000><0.889000,0.036000,0.254000> rotate<0,-90.000000,0> translate<78.740000,0.000000,11.811000> }
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<78.740000,0.000000,5.080000>}
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<78.740000,0.000000,5.969000>}
box{<0,0,-0.254000><0.889000,0.036000,0.254000> rotate<0,90.000000,0> translate<78.740000,0.000000,5.969000> }
object{ARC(0.254000,0.152400,180.000000,270.000000,0.036000) translate<77.978000,0.000000,6.604000>}
object{ARC(0.254000,0.152400,270.000000,360.000000,0.036000) translate<79.502000,0.000000,6.604000>}
object{ARC(0.254000,0.152400,0.000000,90.000000,0.036000) translate<79.502000,0.000000,11.176000>}
object{ARC(0.254000,0.152400,90.000000,180.000000,0.036000) translate<77.978000,0.000000,11.176000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<79.502000,0.000000,6.350000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<77.978000,0.000000,6.350000>}
box{<0,0,-0.076200><1.524000,0.036000,0.076200> rotate<0,0.000000,0> translate<77.978000,0.000000,6.350000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<77.724000,0.000000,6.604000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<77.724000,0.000000,6.985000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,90.000000,0> translate<77.724000,0.000000,6.985000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<77.851000,0.000000,7.112000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<77.724000,0.000000,6.985000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,-44.997030,0> translate<77.724000,0.000000,6.985000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<79.756000,0.000000,6.604000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<79.756000,0.000000,6.985000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,90.000000,0> translate<79.756000,0.000000,6.985000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<79.629000,0.000000,7.112000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<79.756000,0.000000,6.985000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,44.997030,0> translate<79.629000,0.000000,7.112000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<77.851000,0.000000,10.668000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<77.724000,0.000000,10.795000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,44.997030,0> translate<77.724000,0.000000,10.795000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<77.851000,0.000000,10.668000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<77.851000,0.000000,7.112000>}
box{<0,0,-0.076200><3.556000,0.036000,0.076200> rotate<0,-90.000000,0> translate<77.851000,0.000000,7.112000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<79.629000,0.000000,10.668000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<79.756000,0.000000,10.795000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,-44.997030,0> translate<79.629000,0.000000,10.668000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<79.629000,0.000000,10.668000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<79.629000,0.000000,7.112000>}
box{<0,0,-0.076200><3.556000,0.036000,0.076200> rotate<0,-90.000000,0> translate<79.629000,0.000000,7.112000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<77.724000,0.000000,11.176000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<77.724000,0.000000,10.795000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,-90.000000,0> translate<77.724000,0.000000,10.795000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<79.756000,0.000000,11.176000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<79.756000,0.000000,10.795000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,-90.000000,0> translate<79.756000,0.000000,10.795000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<79.502000,0.000000,11.430000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<77.978000,0.000000,11.430000>}
box{<0,0,-0.076200><1.524000,0.036000,0.076200> rotate<0,0.000000,0> translate<77.978000,0.000000,11.430000> }
box{<-0.190500,0,-0.254000><0.190500,0.036000,0.254000> rotate<0,-90.000000,0> translate<78.740000,0.000000,11.620500>}
box{<-0.190500,0,-0.254000><0.190500,0.036000,0.254000> rotate<0,-90.000000,0> translate<78.740000,0.000000,6.159500>}
//R9 silk screen
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<78.740000,0.000000,21.590000>}
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<77.851000,0.000000,21.590000>}
box{<0,0,-0.254000><0.889000,0.036000,0.254000> rotate<0,0.000000,0> translate<77.851000,0.000000,21.590000> }
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<71.120000,0.000000,21.590000>}
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<72.009000,0.000000,21.590000>}
box{<0,0,-0.254000><0.889000,0.036000,0.254000> rotate<0,0.000000,0> translate<71.120000,0.000000,21.590000> }
object{ARC(0.254000,0.152400,90.000000,180.000000,0.036000) translate<72.644000,0.000000,22.352000>}
object{ARC(0.254000,0.152400,180.000000,270.000000,0.036000) translate<72.644000,0.000000,20.828000>}
object{ARC(0.254000,0.152400,270.000000,360.000000,0.036000) translate<77.216000,0.000000,20.828000>}
object{ARC(0.254000,0.152400,0.000000,90.000000,0.036000) translate<77.216000,0.000000,22.352000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<72.390000,0.000000,20.828000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<72.390000,0.000000,22.352000>}
box{<0,0,-0.076200><1.524000,0.036000,0.076200> rotate<0,90.000000,0> translate<72.390000,0.000000,22.352000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<72.644000,0.000000,22.606000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<73.025000,0.000000,22.606000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,0.000000,0> translate<72.644000,0.000000,22.606000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<73.152000,0.000000,22.479000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<73.025000,0.000000,22.606000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,44.997030,0> translate<73.025000,0.000000,22.606000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<72.644000,0.000000,20.574000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<73.025000,0.000000,20.574000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,0.000000,0> translate<72.644000,0.000000,20.574000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<73.152000,0.000000,20.701000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<73.025000,0.000000,20.574000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,-44.997030,0> translate<73.025000,0.000000,20.574000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<76.708000,0.000000,22.479000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<76.835000,0.000000,22.606000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,-44.997030,0> translate<76.708000,0.000000,22.479000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<76.708000,0.000000,22.479000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<73.152000,0.000000,22.479000>}
box{<0,0,-0.076200><3.556000,0.036000,0.076200> rotate<0,0.000000,0> translate<73.152000,0.000000,22.479000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<76.708000,0.000000,20.701000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<76.835000,0.000000,20.574000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,44.997030,0> translate<76.708000,0.000000,20.701000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<76.708000,0.000000,20.701000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<73.152000,0.000000,20.701000>}
box{<0,0,-0.076200><3.556000,0.036000,0.076200> rotate<0,0.000000,0> translate<73.152000,0.000000,20.701000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<77.216000,0.000000,22.606000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<76.835000,0.000000,22.606000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,0.000000,0> translate<76.835000,0.000000,22.606000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<77.216000,0.000000,20.574000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<76.835000,0.000000,20.574000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,0.000000,0> translate<76.835000,0.000000,20.574000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<77.470000,0.000000,20.828000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<77.470000,0.000000,22.352000>}
box{<0,0,-0.076200><1.524000,0.036000,0.076200> rotate<0,90.000000,0> translate<77.470000,0.000000,22.352000> }
box{<-0.190500,0,-0.254000><0.190500,0.036000,0.254000> rotate<0,-0.000000,0> translate<77.660500,0.000000,21.590000>}
box{<-0.190500,0,-0.254000><0.190500,0.036000,0.254000> rotate<0,-0.000000,0> translate<72.199500,0.000000,21.590000>}
//R10 silk screen
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<88.900000,0.000000,17.780000>}
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<88.011000,0.000000,17.780000>}
box{<0,0,-0.254000><0.889000,0.036000,0.254000> rotate<0,0.000000,0> translate<88.011000,0.000000,17.780000> }
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<81.280000,0.000000,17.780000>}
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<82.169000,0.000000,17.780000>}
box{<0,0,-0.254000><0.889000,0.036000,0.254000> rotate<0,0.000000,0> translate<81.280000,0.000000,17.780000> }
object{ARC(0.254000,0.152400,90.000000,180.000000,0.036000) translate<82.804000,0.000000,18.542000>}
object{ARC(0.254000,0.152400,180.000000,270.000000,0.036000) translate<82.804000,0.000000,17.018000>}
object{ARC(0.254000,0.152400,270.000000,360.000000,0.036000) translate<87.376000,0.000000,17.018000>}
object{ARC(0.254000,0.152400,0.000000,90.000000,0.036000) translate<87.376000,0.000000,18.542000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<82.550000,0.000000,17.018000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<82.550000,0.000000,18.542000>}
box{<0,0,-0.076200><1.524000,0.036000,0.076200> rotate<0,90.000000,0> translate<82.550000,0.000000,18.542000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<82.804000,0.000000,18.796000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.185000,0.000000,18.796000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,0.000000,0> translate<82.804000,0.000000,18.796000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.312000,0.000000,18.669000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.185000,0.000000,18.796000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,44.997030,0> translate<83.185000,0.000000,18.796000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<82.804000,0.000000,16.764000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.185000,0.000000,16.764000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,0.000000,0> translate<82.804000,0.000000,16.764000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.312000,0.000000,16.891000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.185000,0.000000,16.764000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,-44.997030,0> translate<83.185000,0.000000,16.764000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<86.868000,0.000000,18.669000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<86.995000,0.000000,18.796000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,-44.997030,0> translate<86.868000,0.000000,18.669000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<86.868000,0.000000,18.669000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.312000,0.000000,18.669000>}
box{<0,0,-0.076200><3.556000,0.036000,0.076200> rotate<0,0.000000,0> translate<83.312000,0.000000,18.669000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<86.868000,0.000000,16.891000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<86.995000,0.000000,16.764000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,44.997030,0> translate<86.868000,0.000000,16.891000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<86.868000,0.000000,16.891000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<83.312000,0.000000,16.891000>}
box{<0,0,-0.076200><3.556000,0.036000,0.076200> rotate<0,0.000000,0> translate<83.312000,0.000000,16.891000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<87.376000,0.000000,18.796000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<86.995000,0.000000,18.796000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,0.000000,0> translate<86.995000,0.000000,18.796000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<87.376000,0.000000,16.764000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<86.995000,0.000000,16.764000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,0.000000,0> translate<86.995000,0.000000,16.764000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<87.630000,0.000000,17.018000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<87.630000,0.000000,18.542000>}
box{<0,0,-0.076200><1.524000,0.036000,0.076200> rotate<0,90.000000,0> translate<87.630000,0.000000,18.542000> }
box{<-0.190500,0,-0.254000><0.190500,0.036000,0.254000> rotate<0,-0.000000,0> translate<87.820500,0.000000,17.780000>}
box{<-0.190500,0,-0.254000><0.190500,0.036000,0.254000> rotate<0,-0.000000,0> translate<82.359500,0.000000,17.780000>}
//R11 silk screen
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<86.360000,0.000000,11.430000>}
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<86.360000,0.000000,10.541000>}
box{<0,0,-0.254000><0.889000,0.036000,0.254000> rotate<0,-90.000000,0> translate<86.360000,0.000000,10.541000> }
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<86.360000,0.000000,3.810000>}
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<86.360000,0.000000,4.699000>}
box{<0,0,-0.254000><0.889000,0.036000,0.254000> rotate<0,90.000000,0> translate<86.360000,0.000000,4.699000> }
object{ARC(0.254000,0.152400,180.000000,270.000000,0.036000) translate<85.598000,0.000000,5.334000>}
object{ARC(0.254000,0.152400,270.000000,360.000000,0.036000) translate<87.122000,0.000000,5.334000>}
object{ARC(0.254000,0.152400,0.000000,90.000000,0.036000) translate<87.122000,0.000000,9.906000>}
object{ARC(0.254000,0.152400,90.000000,180.000000,0.036000) translate<85.598000,0.000000,9.906000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<87.122000,0.000000,5.080000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<85.598000,0.000000,5.080000>}
box{<0,0,-0.076200><1.524000,0.036000,0.076200> rotate<0,0.000000,0> translate<85.598000,0.000000,5.080000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<85.344000,0.000000,5.334000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<85.344000,0.000000,5.715000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,90.000000,0> translate<85.344000,0.000000,5.715000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<85.471000,0.000000,5.842000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<85.344000,0.000000,5.715000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,-44.997030,0> translate<85.344000,0.000000,5.715000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<87.376000,0.000000,5.334000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<87.376000,0.000000,5.715000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,90.000000,0> translate<87.376000,0.000000,5.715000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<87.249000,0.000000,5.842000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<87.376000,0.000000,5.715000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,44.997030,0> translate<87.249000,0.000000,5.842000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<85.471000,0.000000,9.398000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<85.344000,0.000000,9.525000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,44.997030,0> translate<85.344000,0.000000,9.525000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<85.471000,0.000000,9.398000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<85.471000,0.000000,5.842000>}
box{<0,0,-0.076200><3.556000,0.036000,0.076200> rotate<0,-90.000000,0> translate<85.471000,0.000000,5.842000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<87.249000,0.000000,9.398000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<87.376000,0.000000,9.525000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,-44.997030,0> translate<87.249000,0.000000,9.398000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<87.249000,0.000000,9.398000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<87.249000,0.000000,5.842000>}
box{<0,0,-0.076200><3.556000,0.036000,0.076200> rotate<0,-90.000000,0> translate<87.249000,0.000000,5.842000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<85.344000,0.000000,9.906000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<85.344000,0.000000,9.525000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,-90.000000,0> translate<85.344000,0.000000,9.525000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<87.376000,0.000000,9.906000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<87.376000,0.000000,9.525000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,-90.000000,0> translate<87.376000,0.000000,9.525000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<87.122000,0.000000,10.160000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<85.598000,0.000000,10.160000>}
box{<0,0,-0.076200><1.524000,0.036000,0.076200> rotate<0,0.000000,0> translate<85.598000,0.000000,10.160000> }
box{<-0.190500,0,-0.254000><0.190500,0.036000,0.254000> rotate<0,-90.000000,0> translate<86.360000,0.000000,10.350500>}
box{<-0.190500,0,-0.254000><0.190500,0.036000,0.254000> rotate<0,-90.000000,0> translate<86.360000,0.000000,4.889500>}
//R12 silk screen
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<104.140000,0.000000,11.430000>}
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<104.140000,0.000000,10.541000>}
box{<0,0,-0.254000><0.889000,0.036000,0.254000> rotate<0,-90.000000,0> translate<104.140000,0.000000,10.541000> }
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<104.140000,0.000000,3.810000>}
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<104.140000,0.000000,4.699000>}
box{<0,0,-0.254000><0.889000,0.036000,0.254000> rotate<0,90.000000,0> translate<104.140000,0.000000,4.699000> }
object{ARC(0.254000,0.152400,180.000000,270.000000,0.036000) translate<103.378000,0.000000,5.334000>}
object{ARC(0.254000,0.152400,270.000000,360.000000,0.036000) translate<104.902000,0.000000,5.334000>}
object{ARC(0.254000,0.152400,0.000000,90.000000,0.036000) translate<104.902000,0.000000,9.906000>}
object{ARC(0.254000,0.152400,90.000000,180.000000,0.036000) translate<103.378000,0.000000,9.906000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<104.902000,0.000000,5.080000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<103.378000,0.000000,5.080000>}
box{<0,0,-0.076200><1.524000,0.036000,0.076200> rotate<0,0.000000,0> translate<103.378000,0.000000,5.080000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<103.124000,0.000000,5.334000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<103.124000,0.000000,5.715000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,90.000000,0> translate<103.124000,0.000000,5.715000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<103.251000,0.000000,5.842000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<103.124000,0.000000,5.715000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,-44.997030,0> translate<103.124000,0.000000,5.715000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<105.156000,0.000000,5.334000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<105.156000,0.000000,5.715000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,90.000000,0> translate<105.156000,0.000000,5.715000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<105.029000,0.000000,5.842000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<105.156000,0.000000,5.715000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,44.997030,0> translate<105.029000,0.000000,5.842000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<103.251000,0.000000,9.398000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<103.124000,0.000000,9.525000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,44.997030,0> translate<103.124000,0.000000,9.525000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<103.251000,0.000000,9.398000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<103.251000,0.000000,5.842000>}
box{<0,0,-0.076200><3.556000,0.036000,0.076200> rotate<0,-90.000000,0> translate<103.251000,0.000000,5.842000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<105.029000,0.000000,9.398000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<105.156000,0.000000,9.525000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,-44.997030,0> translate<105.029000,0.000000,9.398000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<105.029000,0.000000,9.398000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<105.029000,0.000000,5.842000>}
box{<0,0,-0.076200><3.556000,0.036000,0.076200> rotate<0,-90.000000,0> translate<105.029000,0.000000,5.842000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<103.124000,0.000000,9.906000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<103.124000,0.000000,9.525000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,-90.000000,0> translate<103.124000,0.000000,9.525000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<105.156000,0.000000,9.906000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<105.156000,0.000000,9.525000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,-90.000000,0> translate<105.156000,0.000000,9.525000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<104.902000,0.000000,10.160000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<103.378000,0.000000,10.160000>}
box{<0,0,-0.076200><1.524000,0.036000,0.076200> rotate<0,0.000000,0> translate<103.378000,0.000000,10.160000> }
box{<-0.190500,0,-0.254000><0.190500,0.036000,0.254000> rotate<0,-90.000000,0> translate<104.140000,0.000000,10.350500>}
box{<-0.190500,0,-0.254000><0.190500,0.036000,0.254000> rotate<0,-90.000000,0> translate<104.140000,0.000000,4.889500>}
//R13 silk screen
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<97.790000,0.000000,11.430000>}
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<97.790000,0.000000,10.541000>}
box{<0,0,-0.254000><0.889000,0.036000,0.254000> rotate<0,-90.000000,0> translate<97.790000,0.000000,10.541000> }
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<97.790000,0.000000,3.810000>}
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<97.790000,0.000000,4.699000>}
box{<0,0,-0.254000><0.889000,0.036000,0.254000> rotate<0,90.000000,0> translate<97.790000,0.000000,4.699000> }
object{ARC(0.254000,0.152400,180.000000,270.000000,0.036000) translate<97.028000,0.000000,5.334000>}
object{ARC(0.254000,0.152400,270.000000,360.000000,0.036000) translate<98.552000,0.000000,5.334000>}
object{ARC(0.254000,0.152400,0.000000,90.000000,0.036000) translate<98.552000,0.000000,9.906000>}
object{ARC(0.254000,0.152400,90.000000,180.000000,0.036000) translate<97.028000,0.000000,9.906000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<98.552000,0.000000,5.080000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<97.028000,0.000000,5.080000>}
box{<0,0,-0.076200><1.524000,0.036000,0.076200> rotate<0,0.000000,0> translate<97.028000,0.000000,5.080000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<96.774000,0.000000,5.334000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<96.774000,0.000000,5.715000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,90.000000,0> translate<96.774000,0.000000,5.715000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<96.901000,0.000000,5.842000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<96.774000,0.000000,5.715000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,-44.997030,0> translate<96.774000,0.000000,5.715000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<98.806000,0.000000,5.334000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<98.806000,0.000000,5.715000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,90.000000,0> translate<98.806000,0.000000,5.715000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<98.679000,0.000000,5.842000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<98.806000,0.000000,5.715000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,44.997030,0> translate<98.679000,0.000000,5.842000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<96.901000,0.000000,9.398000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<96.774000,0.000000,9.525000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,44.997030,0> translate<96.774000,0.000000,9.525000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<96.901000,0.000000,9.398000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<96.901000,0.000000,5.842000>}
box{<0,0,-0.076200><3.556000,0.036000,0.076200> rotate<0,-90.000000,0> translate<96.901000,0.000000,5.842000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<98.679000,0.000000,9.398000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<98.806000,0.000000,9.525000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,-44.997030,0> translate<98.679000,0.000000,9.398000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<98.679000,0.000000,9.398000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<98.679000,0.000000,5.842000>}
box{<0,0,-0.076200><3.556000,0.036000,0.076200> rotate<0,-90.000000,0> translate<98.679000,0.000000,5.842000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<96.774000,0.000000,9.906000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<96.774000,0.000000,9.525000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,-90.000000,0> translate<96.774000,0.000000,9.525000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<98.806000,0.000000,9.906000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<98.806000,0.000000,9.525000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,-90.000000,0> translate<98.806000,0.000000,9.525000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<98.552000,0.000000,10.160000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<97.028000,0.000000,10.160000>}
box{<0,0,-0.076200><1.524000,0.036000,0.076200> rotate<0,0.000000,0> translate<97.028000,0.000000,10.160000> }
box{<-0.190500,0,-0.254000><0.190500,0.036000,0.254000> rotate<0,-90.000000,0> translate<97.790000,0.000000,10.350500>}
box{<-0.190500,0,-0.254000><0.190500,0.036000,0.254000> rotate<0,-90.000000,0> translate<97.790000,0.000000,4.889500>}
//R14 silk screen
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<104.140000,0.000000,13.970000>}
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<103.251000,0.000000,13.970000>}
box{<0,0,-0.254000><0.889000,0.036000,0.254000> rotate<0,0.000000,0> translate<103.251000,0.000000,13.970000> }
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<96.520000,0.000000,13.970000>}
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<97.409000,0.000000,13.970000>}
box{<0,0,-0.254000><0.889000,0.036000,0.254000> rotate<0,0.000000,0> translate<96.520000,0.000000,13.970000> }
object{ARC(0.254000,0.152400,90.000000,180.000000,0.036000) translate<98.044000,0.000000,14.732000>}
object{ARC(0.254000,0.152400,180.000000,270.000000,0.036000) translate<98.044000,0.000000,13.208000>}
object{ARC(0.254000,0.152400,270.000000,360.000000,0.036000) translate<102.616000,0.000000,13.208000>}
object{ARC(0.254000,0.152400,0.000000,90.000000,0.036000) translate<102.616000,0.000000,14.732000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<97.790000,0.000000,13.208000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<97.790000,0.000000,14.732000>}
box{<0,0,-0.076200><1.524000,0.036000,0.076200> rotate<0,90.000000,0> translate<97.790000,0.000000,14.732000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<98.044000,0.000000,14.986000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<98.425000,0.000000,14.986000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,0.000000,0> translate<98.044000,0.000000,14.986000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<98.552000,0.000000,14.859000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<98.425000,0.000000,14.986000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,44.997030,0> translate<98.425000,0.000000,14.986000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<98.044000,0.000000,12.954000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<98.425000,0.000000,12.954000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,0.000000,0> translate<98.044000,0.000000,12.954000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<98.552000,0.000000,13.081000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<98.425000,0.000000,12.954000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,-44.997030,0> translate<98.425000,0.000000,12.954000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<102.108000,0.000000,14.859000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<102.235000,0.000000,14.986000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,-44.997030,0> translate<102.108000,0.000000,14.859000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<102.108000,0.000000,14.859000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<98.552000,0.000000,14.859000>}
box{<0,0,-0.076200><3.556000,0.036000,0.076200> rotate<0,0.000000,0> translate<98.552000,0.000000,14.859000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<102.108000,0.000000,13.081000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<102.235000,0.000000,12.954000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,44.997030,0> translate<102.108000,0.000000,13.081000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<102.108000,0.000000,13.081000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<98.552000,0.000000,13.081000>}
box{<0,0,-0.076200><3.556000,0.036000,0.076200> rotate<0,0.000000,0> translate<98.552000,0.000000,13.081000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<102.616000,0.000000,14.986000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<102.235000,0.000000,14.986000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,0.000000,0> translate<102.235000,0.000000,14.986000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<102.616000,0.000000,12.954000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<102.235000,0.000000,12.954000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,0.000000,0> translate<102.235000,0.000000,12.954000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<102.870000,0.000000,13.208000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<102.870000,0.000000,14.732000>}
box{<0,0,-0.076200><1.524000,0.036000,0.076200> rotate<0,90.000000,0> translate<102.870000,0.000000,14.732000> }
box{<-0.190500,0,-0.254000><0.190500,0.036000,0.254000> rotate<0,-0.000000,0> translate<103.060500,0.000000,13.970000>}
box{<-0.190500,0,-0.254000><0.190500,0.036000,0.254000> rotate<0,-0.000000,0> translate<97.599500,0.000000,13.970000>}
//R15 silk screen
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<101.600000,0.000000,33.020000>}
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<100.711000,0.000000,33.020000>}
box{<0,0,-0.254000><0.889000,0.036000,0.254000> rotate<0,0.000000,0> translate<100.711000,0.000000,33.020000> }
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<93.980000,0.000000,33.020000>}
cylinder{<0,0,0><0,0.036000,0>0.254000 translate<94.869000,0.000000,33.020000>}
box{<0,0,-0.254000><0.889000,0.036000,0.254000> rotate<0,0.000000,0> translate<93.980000,0.000000,33.020000> }
object{ARC(0.254000,0.152400,90.000000,180.000000,0.036000) translate<95.504000,0.000000,33.782000>}
object{ARC(0.254000,0.152400,180.000000,270.000000,0.036000) translate<95.504000,0.000000,32.258000>}
object{ARC(0.254000,0.152400,270.000000,360.000000,0.036000) translate<100.076000,0.000000,32.258000>}
object{ARC(0.254000,0.152400,0.000000,90.000000,0.036000) translate<100.076000,0.000000,33.782000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<95.250000,0.000000,32.258000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<95.250000,0.000000,33.782000>}
box{<0,0,-0.076200><1.524000,0.036000,0.076200> rotate<0,90.000000,0> translate<95.250000,0.000000,33.782000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<95.504000,0.000000,34.036000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<95.885000,0.000000,34.036000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,0.000000,0> translate<95.504000,0.000000,34.036000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<96.012000,0.000000,33.909000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<95.885000,0.000000,34.036000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,44.997030,0> translate<95.885000,0.000000,34.036000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<95.504000,0.000000,32.004000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<95.885000,0.000000,32.004000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,0.000000,0> translate<95.504000,0.000000,32.004000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<96.012000,0.000000,32.131000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<95.885000,0.000000,32.004000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,-44.997030,0> translate<95.885000,0.000000,32.004000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<99.568000,0.000000,33.909000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<99.695000,0.000000,34.036000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,-44.997030,0> translate<99.568000,0.000000,33.909000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<99.568000,0.000000,33.909000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<96.012000,0.000000,33.909000>}
box{<0,0,-0.076200><3.556000,0.036000,0.076200> rotate<0,0.000000,0> translate<96.012000,0.000000,33.909000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<99.568000,0.000000,32.131000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<99.695000,0.000000,32.004000>}
box{<0,0,-0.076200><0.179605,0.036000,0.076200> rotate<0,44.997030,0> translate<99.568000,0.000000,32.131000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<99.568000,0.000000,32.131000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<96.012000,0.000000,32.131000>}
box{<0,0,-0.076200><3.556000,0.036000,0.076200> rotate<0,0.000000,0> translate<96.012000,0.000000,32.131000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<100.076000,0.000000,34.036000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<99.695000,0.000000,34.036000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,0.000000,0> translate<99.695000,0.000000,34.036000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<100.076000,0.000000,32.004000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<99.695000,0.000000,32.004000>}
box{<0,0,-0.076200><0.381000,0.036000,0.076200> rotate<0,0.000000,0> translate<99.695000,0.000000,32.004000> }
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<100.330000,0.000000,32.258000>}
cylinder{<0,0,0><0,0.036000,0>0.076200 translate<100.330000,0.000000,33.782000>}
box{<0,0,-0.076200><1.524000,0.036000,0.076200> rotate<0,90.000000,0> translate<100.330000,0.000000,33.782000> }
box{<-0.190500,0,-0.254000><0.190500,0.036000,0.254000> rotate<0,-0.000000,0> translate<100.520500,0.000000,33.020000>}
box{<-0.190500,0,-0.254000><0.190500,0.036000,0.254000> rotate<0,-0.000000,0> translate<95.059500,0.000000,33.020000>}
//U$3 silk screen
cylinder{<0,0,0><0,0.036000,0>0.063500 translate<30.480000,0.000000,24.130000>}
cylinder{<0,0,0><0,0.036000,0>0.063500 translate<0.000000,0.000000,24.130000>}
box{<0,0,-0.063500><30.480000,0.036000,0.063500> rotate<0,0.000000,0> translate<0.000000,0.000000,24.130000> }
cylinder{<0,0,0><0,0.036000,0>0.063500 translate<0.000000,0.000000,24.130000>}
cylinder{<0,0,0><0,0.036000,0>0.063500 translate<0.000000,0.000000,54.610000>}
box{<0,0,-0.063500><30.480000,0.036000,0.063500> rotate<0,90.000000,0> translate<0.000000,0.000000,54.610000> }
cylinder{<0,0,0><0,0.036000,0>0.063500 translate<0.000000,0.000000,54.610000>}
cylinder{<0,0,0><0,0.036000,0>0.063500 translate<30.480000,0.000000,54.610000>}
box{<0,0,-0.063500><30.480000,0.036000,0.063500> rotate<0,0.000000,0> translate<0.000000,0.000000,54.610000> }
cylinder{<0,0,0><0,0.036000,0>0.063500 translate<30.480000,0.000000,54.610000>}
cylinder{<0,0,0><0,0.036000,0>0.063500 translate<30.480000,0.000000,24.130000>}
box{<0,0,-0.063500><30.480000,0.036000,0.063500> rotate<0,-90.000000,0> translate<30.480000,0.000000,24.130000> }
//U$4 silk screen
difference{
cylinder{<36.830000,0,43.180000><36.830000,0.036000,43.180000>5.143500 translate<0,0.000000,0>}
cylinder{<36.830000,-0.1,43.180000><36.830000,0.135000,43.180000>5.016500 translate<0,0.000000,0>}}
texture{col_slk}
}
#end
translate<mac_x_ver,mac_y_ver,mac_z_ver>
rotate<mac_x_rot,mac_y_rot,mac_z_rot>
}//End union
#end

#if(use_file_as_inc=off)
object{  KARAKTERISZTIKA_RAJZOLO(-56.510000,0,-29.845000,pcb_rotate_x,pcb_rotate_y,pcb_rotate_z)
#if(pcb_upsidedown=on)
rotate pcb_rotdir*180
#end
}
#end


//Parts not found in 3dpack.dat or 3dusrpac.dat are:
//B	B	2,54/1,0
//C	C	2,54/1,0
//E	E	2,54/1,0
//J1	J5MM	05
//J2	J5MM	05
//J3	J5MM	05
//J4	J5MM	05
//J5	J5MM	05
//J6	J5MM	05
//J7	J10MM	10
//J8	J10MM	10
//PAD3		2,54/1,0
//PAD4		2,54/1,0
//PAD6		2,54/1,0
//PAD7		2,54/1,0
//PAD8		2,54/1,0
//PAD9		2,54/1,0
